/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.graph.DexAnnotationElement;
import com.android.tools.r8.graph.DexEncodedAnnotation;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import java.util.ArrayList;
import java.util.List;

public class DexAnnotation
extends DexItem {
    public static final int VISIBILITY_BUILD = 0;
    public static final int VISIBILITY_RUNTIME = 1;
    public static final int VISIBILITY_SYSTEM = 2;
    public final int visibility;
    public final DexEncodedAnnotation annotation;

    public DexAnnotation(int visibility, DexEncodedAnnotation annotation) {
        this.visibility = visibility;
        this.annotation = annotation;
    }

    public int hashCode() {
        return this.visibility + this.annotation.hashCode() * 3;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof DexAnnotation) {
            DexAnnotation o = (DexAnnotation)other;
            return this.visibility == o.visibility && this.annotation.equals(o.annotation);
        }
        return false;
    }

    public String toString() {
        return this.visibility + " " + this.annotation;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        this.annotation.collectIndexedItems(indexedItems);
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        mixedItems.add(this);
    }

    public static DexAnnotation createEnclosingClassAnnotation(DexType enclosingClass, DexItemFactory factory) {
        return DexAnnotation.createSystemValueAnnotation(factory.annotationEnclosingClass, factory, new DexValue.DexValueType(enclosingClass));
    }

    public static DexAnnotation createEnclosingMethodAnnotation(DexMethod enclosingMethod, DexItemFactory factory) {
        return DexAnnotation.createSystemValueAnnotation(factory.annotationEnclosingMethod, factory, new DexValue.DexValueMethod(enclosingMethod));
    }

    public static boolean isEnclosingClassAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        return annotation.annotation.type == factory.annotationEnclosingClass;
    }

    public static boolean isEnclosingMethodAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        return annotation.annotation.type == factory.annotationEnclosingMethod;
    }

    public static boolean isInnerClassesAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        return annotation.annotation.type == factory.annotationMemberClasses || annotation.annotation.type == factory.annotationInnerClass;
    }

    public static DexAnnotation createInnerClassAnnotation(String clazz, int access, DexItemFactory factory) {
        return new DexAnnotation(2, new DexEncodedAnnotation(factory.annotationInnerClass, new DexAnnotationElement[]{new DexAnnotationElement(factory.createString("accessFlags"), DexValue.DexValueInt.create(access)), new DexAnnotationElement(factory.createString("name"), clazz == null ? DexValue.DexValueNull.NULL : new DexValue.DexValueString(factory.createString(clazz)))}));
    }

    public static DexAnnotation createMemberClassesAnnotation(List<DexType> classes, DexItemFactory factory) {
        DexValue[] values = new DexValue[classes.size()];
        for (int i = 0; i < classes.size(); ++i) {
            values[i] = new DexValue.DexValueType(classes.get(i));
        }
        return DexAnnotation.createSystemValueAnnotation(factory.annotationMemberClasses, factory, new DexValue.DexValueArray(values));
    }

    public static DexAnnotation createSourceDebugExtensionAnnotation(DexValue value, DexItemFactory factory) {
        return new DexAnnotation(2, new DexEncodedAnnotation(factory.annotationSourceDebugExtension, new DexAnnotationElement[]{new DexAnnotationElement(factory.createString("value"), value)}));
    }

    public static DexAnnotation createMethodParametersAnnotation(DexValue[] names, DexValue[] accessFlags, DexItemFactory factory) {
        assert (names.length == accessFlags.length);
        return new DexAnnotation(2, new DexEncodedAnnotation(factory.annotationMethodParameters, new DexAnnotationElement[]{new DexAnnotationElement(factory.createString("names"), new DexValue.DexValueArray(names)), new DexAnnotationElement(factory.createString("accessFlags"), new DexValue.DexValueArray(accessFlags))}));
    }

    public static DexAnnotation createAnnotationDefaultAnnotation(DexType type, List<DexAnnotationElement> defaults, DexItemFactory factory) {
        return DexAnnotation.createSystemValueAnnotation(factory.annotationDefault, factory, new DexValue.DexValueAnnotation(new DexEncodedAnnotation(type, defaults.toArray(new DexAnnotationElement[defaults.size()]))));
    }

    public static DexAnnotation createSignatureAnnotation(String signature, DexItemFactory factory) {
        return DexAnnotation.createSystemValueAnnotation(factory.annotationSignature, factory, DexAnnotation.compressSignature(signature, factory));
    }

    public static DexAnnotation createThrowsAnnotation(DexValue[] exceptions, DexItemFactory factory) {
        return DexAnnotation.createSystemValueAnnotation(factory.annotationThrows, factory, new DexValue.DexValueArray(exceptions));
    }

    private static DexAnnotation createSystemValueAnnotation(DexType type, DexItemFactory factory, DexValue value) {
        return new DexAnnotation(2, new DexEncodedAnnotation(type, new DexAnnotationElement[]{new DexAnnotationElement(factory.createString("value"), value)}));
    }

    public static boolean isThrowingAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        return annotation.annotation.type == factory.annotationThrows;
    }

    public static boolean isSignatureAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        return annotation.annotation.type == factory.annotationSignature;
    }

    public static boolean isSourceDebugExtension(DexAnnotation annotation, DexItemFactory factory) {
        return annotation.annotation.type == factory.annotationSourceDebugExtension;
    }

    private static DexValue compressSignature(String signature, DexItemFactory factory) {
        int length = signature.length();
        ArrayList<DexValue> parts = new ArrayList<DexValue>();
        int at = 0;
        while (at < length) {
            int endAt;
            char c = signature.charAt(at);
            if (c == 'L') {
                for (endAt = at + 1; endAt < length; ++endAt) {
                    c = signature.charAt(endAt);
                    if (c != ';' && c != '<') continue;
                    ++endAt;
                    break;
                }
            } else {
                while (endAt < length && (c = signature.charAt(endAt)) != 'L') {
                    ++endAt;
                }
            }
            parts.add(DexAnnotation.toDexValue(signature.substring(at, endAt), factory));
            at = endAt;
        }
        return new DexValue.DexValueArray(parts.toArray(new DexValue[parts.size()]));
    }

    private static DexValue toDexValue(String string, DexItemFactory factory) {
        return new DexValue.DexValueString(factory.createString(string));
    }
}

