/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.Descriptor;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.PresortedComparable;
import com.android.tools.r8.naming.NamingLens;

public class DexMethod
extends Descriptor<DexEncodedMethod, DexMethod>
implements PresortedComparable<DexMethod> {
    public final DexType holder;
    public final DexProto proto;
    public final DexString name;
    private DexEncodedMethod singleTargetCache;

    DexMethod(DexType holder, DexProto proto, DexString name) {
        this.holder = holder;
        this.proto = proto;
        this.name = name;
        if (!name.isValidMethodName()) {
            throw new CompilationError("Method name '" + name.toString() + "' cannot be represented in dex format.");
        }
    }

    public String toString() {
        return "Method " + this.holder + "." + this.name + " " + this.proto.toString();
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        if (indexedItems.addMethod(this)) {
            this.holder.collectIndexedItems(indexedItems);
            this.proto.collectIndexedItems(indexedItems);
            indexedItems.getRenamedName(this).collectIndexedItems(indexedItems);
        }
    }

    @Override
    public int getOffset(ObjectToOffsetMapping mapping) {
        return mapping.getOffsetFor(this);
    }

    @Override
    public int computeHashCode() {
        return this.holder.hashCode() + this.proto.hashCode() * 7 + this.name.hashCode() * 31;
    }

    @Override
    public boolean computeEquals(Object other) {
        if (other instanceof DexMethod) {
            DexMethod o = (DexMethod)other;
            return this.holder.equals(o.holder) && this.name.equals(o.name) && this.proto.equals(o.proto);
        }
        return false;
    }

    @Override
    public int compareTo(DexMethod other) {
        return this.sortedCompareTo(other.getSortedIndex());
    }

    @Override
    public int slowCompareTo(DexMethod other) {
        int result = this.holder.slowCompareTo(other.holder);
        if (result != 0) {
            return result;
        }
        result = this.name.slowCompareTo(other.name);
        if (result != 0) {
            return result;
        }
        return this.proto.slowCompareTo(other.proto);
    }

    @Override
    public int slowCompareTo(DexMethod other, NamingLens namingLens) {
        int result = this.holder.slowCompareTo(other.holder, namingLens);
        if (result != 0) {
            return result;
        }
        result = namingLens.lookupName(this).slowCompareTo(namingLens.lookupName(other));
        if (result != 0) {
            return result;
        }
        return this.proto.slowCompareTo(other.proto, namingLens);
    }

    @Override
    public int layeredCompareTo(DexMethod other, NamingLens namingLens) {
        int result = this.holder.compareTo(other.holder);
        if (result != 0) {
            return result;
        }
        result = namingLens.lookupName(this).compareTo(namingLens.lookupName(other));
        if (result != 0) {
            return result;
        }
        return this.proto.compareTo(other.proto);
    }

    @Override
    public boolean match(DexEncodedMethod entry) {
        return entry.method.name == this.name && entry.method.proto == this.proto;
    }

    @Override
    public DexType getHolder() {
        return this.holder;
    }

    public String qualifiedName() {
        return this.holder + "." + this.name;
    }

    @Override
    public String toSmaliString() {
        return this.holder.toSmaliString() + "->" + this.name + this.proto.toSmaliString();
    }

    @Override
    public String toSourceString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.proto.returnType.toSourceString());
        builder.append(" ");
        builder.append(this.holder.toSourceString());
        builder.append(".");
        builder.append(this.name);
        builder.append("(");
        for (int i = 0; i < this.proto.parameters.values.length; ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(this.proto.parameters.values[i].toSourceString());
        }
        builder.append(")");
        return builder.toString();
    }

    public synchronized void setSingleVirtualMethodCache(DexEncodedMethod method) {
        this.singleTargetCache = method == null ? DexEncodedMethod.SENTINEL : method;
    }

    public synchronized boolean isSingleVirtualMethodCached() {
        return this.singleTargetCache != null;
    }

    public synchronized DexEncodedMethod getSingleVirtualMethodCache() {
        assert (this.isSingleVirtualMethodCached());
        return this.singleTargetCache == DexEncodedMethod.SENTINEL ? null : this.singleTargetCache;
    }
}

