/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CheckCast;
import com.android.tools.r8.ir.code.DominatorTree;
import com.android.tools.r8.ir.code.Goto;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.MoveType;
import com.android.tools.r8.ir.code.Return;
import com.android.tools.r8.ir.code.Value;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class BasicBlockInstructionIterator
implements InstructionIterator,
InstructionListIterator {
    protected final BasicBlock block;
    protected final ListIterator<Instruction> listIterator;
    protected Instruction current;

    protected BasicBlockInstructionIterator(BasicBlock block) {
        this.block = block;
        this.listIterator = block.getInstructions().listIterator();
    }

    protected BasicBlockInstructionIterator(BasicBlock block, int index) {
        this.block = block;
        this.listIterator = block.getInstructions().listIterator(index);
    }

    protected BasicBlockInstructionIterator(BasicBlock block, Instruction instruction) {
        this(block);
        this.nextUntil(x -> x == instruction);
    }

    @Override
    public boolean hasNext() {
        return this.listIterator.hasNext();
    }

    @Override
    public Instruction next() {
        this.current = this.listIterator.next();
        return this.current;
    }

    @Override
    public int nextIndex() {
        return this.listIterator.nextIndex();
    }

    @Override
    public boolean hasPrevious() {
        return this.listIterator.hasPrevious();
    }

    @Override
    public Instruction previous() {
        this.current = this.listIterator.previous();
        return this.current;
    }

    @Override
    public int previousIndex() {
        return this.listIterator.previousIndex();
    }

    @Override
    public void add(Instruction instruction) {
        instruction.setBlock(this.block);
        assert (instruction.getBlock() == this.block);
        this.listIterator.add(instruction);
    }

    @Override
    public void set(Instruction instruction) {
        instruction.setBlock(this.block);
        assert (instruction.getBlock() == this.block);
        this.listIterator.set(instruction);
    }

    @Override
    public void remove() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        assert (this.current.outValue() == null || this.current.outValue().numberOfAllUsers() == 0);
        for (int i = 0; i < this.current.inValues().size(); ++i) {
            Value value = this.current.inValues().get(i);
            value.removeUser(this.current);
        }
        for (Value value : this.current.getDebugValues()) {
            value.removeDebugUser(this.current);
        }
        Value previousLocalValue = this.current.getPreviousLocalValue();
        if (previousLocalValue != null) {
            previousLocalValue.removeDebugUser(this.current);
        }
        this.listIterator.remove();
        this.current = null;
    }

    @Override
    public void detach() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        this.listIterator.remove();
        this.current = null;
    }

    @Override
    public void replaceCurrentInstruction(Instruction newInstruction) {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        for (Value value : this.current.inValues()) {
            value.removeUser(this.current);
        }
        if (this.current.outValue() != null) {
            assert (newInstruction.outValue() != null);
            this.current.outValue().replaceUsers(newInstruction.outValue());
        }
        for (Value value : this.current.getDebugValues()) {
            BasicBlockInstructionIterator.replaceInstructionInList(this.current, newInstruction, value.getDebugLocalStarts());
            BasicBlockInstructionIterator.replaceInstructionInList(this.current, newInstruction, value.getDebugLocalEnds());
            value.removeDebugUser(this.current);
            newInstruction.addDebugValue(value);
        }
        newInstruction.setBlock(this.block);
        this.listIterator.remove();
        this.listIterator.add(newInstruction);
        this.current.clearBlock();
    }

    private static void replaceInstructionInList(Instruction instruction, Instruction newInstruction, List<Instruction> instructions) {
        for (int i = 0; i < instructions.size(); ++i) {
            if (instructions.get(i) != instruction) continue;
            instructions.set(i, newInstruction);
        }
    }

    private BasicBlock peekPrevious(ListIterator<BasicBlock> blocksIterator) {
        BasicBlock block = blocksIterator.previous();
        blocksIterator.next();
        return block;
    }

    @Override
    public BasicBlock split(IRCode code, ListIterator<BasicBlock> blocksIterator) {
        LinkedList<BasicBlock> blocks = code.blocks;
        assert (blocksIterator == null || this.peekPrevious(blocksIterator) == this.block);
        int blockNumber = code.getHighestBlockNumber() + 1;
        assert (this.hasNext());
        boolean keepCatchHandlers = this.hasPrevious() && this.peekPrevious().instructionTypeCanThrow();
        BasicBlock newBlock = this.block.createSplitBlock(blockNumber, keepCatchHandlers);
        Goto newGoto = new Goto(this.block);
        this.listIterator.add(newGoto);
        while (this.listIterator.hasNext()) {
            Instruction instruction = this.listIterator.next();
            newBlock.getInstructions().addLast(instruction);
            instruction.setBlock(newBlock);
            this.listIterator.remove();
        }
        if (code.getNormalExitBlock() == this.block) {
            code.setNormalExitBlock(newBlock);
        }
        if (blocksIterator == null) {
            blocks.add(blocks.indexOf(this.block) + 1, newBlock);
        } else {
            blocksIterator.add(newBlock);
        }
        return newBlock;
    }

    @Override
    public BasicBlock split(int instructions, IRCode code, ListIterator<BasicBlock> blocksIterator) {
        BasicBlock newBlock = this.split(code, blocksIterator);
        assert (blocksIterator == null || this.peekPrevious(blocksIterator) == newBlock);
        InstructionListIterator iterator = newBlock.listIterator();
        for (int i = 0; i < instructions; ++i) {
            iterator.next();
        }
        iterator.split(code, blocksIterator);
        return newBlock;
    }

    private boolean canThrow(IRCode code) {
        InstructionIterator iterator = code.instructionIterator();
        while (iterator.hasNext()) {
            boolean throwing = ((Instruction)iterator.next()).instructionTypeCanThrow();
            if (!throwing) continue;
            return true;
        }
        return false;
    }

    private void splitBlockAndCopyCatchHandlers(IRCode code, BasicBlock invokeBlock, BasicBlock inlinedBlock, ListIterator<BasicBlock> blocksIterator) {
        InstructionListIterator instructionsIterator = inlinedBlock.listIterator();
        BasicBlock currentBlock = inlinedBlock;
        while (currentBlock != null && instructionsIterator.hasNext()) {
            assert (!currentBlock.hasCatchHandlers());
            Instruction throwingInstruction = instructionsIterator.nextUntil(Instruction::instructionTypeCanThrow);
            if (throwingInstruction != null) {
                BasicBlock b;
                BasicBlock nextBlock;
                if (instructionsIterator.hasNext()) {
                    nextBlock = instructionsIterator.split(code, blocksIterator);
                    assert (nextBlock.getPredecessors().size() == 1);
                    assert (currentBlock == nextBlock.getPredecessors().get(0));
                    b = blocksIterator.previous();
                    assert (b == nextBlock);
                } else {
                    nextBlock = null;
                }
                currentBlock.copyCatchHandlers(code, blocksIterator, invokeBlock);
                if (nextBlock != null) {
                    b = blocksIterator.next();
                    assert (b == nextBlock);
                    instructionsIterator = nextBlock.listIterator();
                } else {
                    instructionsIterator = null;
                }
                currentBlock = nextBlock;
                continue;
            }
            assert (!instructionsIterator.hasNext());
            instructionsIterator = null;
            currentBlock = null;
        }
    }

    private void appendCatchHandlers(IRCode code, BasicBlock invokeBlock, IRCode inlinee, ListIterator<BasicBlock> blocksIterator) {
        BasicBlock inlineeBlock = null;
        for (int i = 0; i < inlinee.blocks.size(); ++i) {
            inlineeBlock = blocksIterator.previous();
        }
        assert (inlineeBlock == inlinee.blocks.getFirst());
        inlineeBlock = blocksIterator.next();
        assert (inlineeBlock == inlinee.blocks.getFirst());
        for (BasicBlock inlinedBlock : inlinee.blocks) {
            assert (inlineeBlock == inlinedBlock);
            if (inlinedBlock.hasCatchHandlers()) {
                inlinedBlock.copyCatchHandlers(code, blocksIterator, invokeBlock);
            } else {
                this.splitBlockAndCopyCatchHandlers(code, invokeBlock, inlinedBlock, blocksIterator);
            }
            inlineeBlock = blocksIterator.next();
        }
    }

    private void removeArgumentInstructions(IRCode inlinee) {
        int index = 0;
        InstructionListIterator inlineeIterator = inlinee.blocks.getFirst().listIterator();
        List<Value> arguments = inlinee.collectArguments();
        while (inlineeIterator.hasNext()) {
            Instruction instruction = (Instruction)inlineeIterator.next();
            if (!instruction.isArgument()) continue;
            assert (instruction.outValue().numberOfAllUsers() == 0);
            assert (instruction.outValue() == arguments.get(index++));
            inlineeIterator.remove();
        }
    }

    @Override
    public BasicBlock inlineInvoke(IRCode code, IRCode inlinee, ListIterator<BasicBlock> blocksIterator, List<BasicBlock> blocksToRemove, DexType downcast) {
        assert (blocksToRemove != null);
        boolean inlineeCanThrow = this.canThrow(inlinee);
        BasicBlock invokeBlock = this.split(1, code, blocksIterator);
        assert (invokeBlock.getInstructions().size() == 2);
        assert (invokeBlock.getInstructions().getFirst().isInvoke());
        Invoke invoke = invokeBlock.getInstructions().getFirst().asInvoke();
        BasicBlock invokePredecessor = invokeBlock.getPredecessors().get(0);
        BasicBlock invokeSuccessor = invokeBlock.getSuccessors().get(0);
        CheckCast castInstruction = null;
        List<Value> arguments = inlinee.collectArguments();
        assert (invoke.inValues().size() == arguments.size());
        for (int i = 0; i < invoke.inValues().size(); ++i) {
            if (i == 0 && downcast != null) {
                Value invokeValue = invoke.inValues().get(0);
                Value receiverValue = arguments.get(0);
                Value value = code.createValue(MoveType.OBJECT);
                castInstruction = new CheckCast(value, invokeValue, downcast);
                receiverValue.replaceUsers(value);
                continue;
            }
            arguments.get(i).replaceUsers(invoke.inValues().get(i));
        }
        this.removeArgumentInstructions(inlinee);
        if (castInstruction != null) {
            inlinee.blocks.getFirst().listIterator().split(inlinee);
            BasicBlock newBlock = inlinee.blocks.getFirst();
            assert (newBlock.getInstructions().size() == 1);
            newBlock.getInstructions().addFirst(castInstruction);
            castInstruction.setBlock(newBlock);
        }
        BasicBlock inlineEntry = inlinee.blocks.getFirst();
        BasicBlock inlineExit = null;
        if (inlinee.getNormalExitBlock() == null) {
            assert (inlineeCanThrow);
            assert (!invokeBlock.hasCatchHandlers());
            blocksToRemove.addAll(invokePredecessor.unlink(invokeBlock, new DominatorTree(code, blocksToRemove)));
        } else {
            InstructionListIterator inlineeIterator = inlinee.getNormalExitBlock().listIterator();
            inlineeIterator.nextUntil(Instruction::isReturn);
            Return ret = ((Instruction)inlineeIterator.previous()).asReturn();
            if (invoke.outValue() != null) {
                assert (!ret.isReturnVoid());
                invoke.outValue().replaceUsers(ret.returnValue());
            }
            BasicBlock returnBlock = inlineeIterator.split(inlinee);
            inlineExit = returnBlock.unlinkSinglePredecessor();
            InstructionListIterator returnBlockIterator = returnBlock.listIterator();
            returnBlockIterator.next();
            returnBlockIterator.remove();
            assert (!returnBlockIterator.hasNext());
            inlinee.blocks.remove(returnBlock);
            invokeBlock.unlinkSinglePredecessor();
            InstructionListIterator invokeBlockIterator = invokeBlock.listIterator();
            invokeBlockIterator.next();
            invokeBlockIterator.remove();
            invokeSuccessor = invokeBlock;
        }
        invokePredecessor.link(inlineEntry);
        if (inlineExit != null) {
            inlineExit.link(invokeSuccessor);
        }
        if (blocksIterator == null) {
            blocksIterator = code.blocks.listIterator(code.blocks.indexOf(invokeBlock));
            blocksIterator.next();
        } else {
            blocksIterator.previous();
            blocksIterator.previous();
        }
        int blockNumber = code.getHighestBlockNumber() + 1;
        for (BasicBlock bb : inlinee.blocks) {
            bb.setNumber(blockNumber++);
            blocksIterator.add(bb);
        }
        if (invokeBlock.hasCatchHandlers()) {
            this.appendCatchHandlers(code, invokeBlock, inlinee, blocksIterator);
        }
        return invokeSuccessor;
    }
}

