/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.code.MoveType;
import com.android.tools.r8.ir.code.NumericType;

public enum ConstType {
    INT,
    LONG,
    FLOAT,
    DOUBLE,
    OBJECT,
    INT_OR_FLOAT,
    LONG_OR_DOUBLE;


    public static ConstType fromNumericType(NumericType type) {
        switch (type) {
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                return INT;
            }
            case LONG: {
                return LONG;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
        }
        throw new Unreachable("Invalid numeric type '" + (Object)((Object)type) + "'");
    }

    public static ConstType fromMoveType(MoveType moveType) {
        switch (moveType) {
            case SINGLE: {
                return INT_OR_FLOAT;
            }
            case WIDE: {
                return LONG_OR_DOUBLE;
            }
            case OBJECT: {
                return INT;
            }
        }
        throw new Unreachable("Invalid move type '" + (Object)((Object)moveType) + "'");
    }
}

