/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.JumpInstruction;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.utils.CfgPrinter;
import java.util.List;

public class If
extends JumpInstruction {
    private Type type;

    public If(Type type, Value value) {
        super(null, value);
        this.type = type;
    }

    public If(Type type, List<Value> values) {
        super(null, values);
        this.type = type;
    }

    public boolean isZeroTest() {
        return this.inValues.size() == 1;
    }

    public Type getType() {
        return this.type;
    }

    public void invert() {
        BasicBlock tmp = this.getTrueTarget();
        this.setTrueTarget(this.fallthroughBlock());
        this.setFallthroughBlock(tmp);
        this.type = this.type.inverted();
    }

    public BasicBlock getTrueTarget() {
        assert (this.getBlock().exit() == this);
        List<BasicBlock> successors = this.getBlock().getSuccessors();
        assert (successors.size() >= 2);
        return successors.get(successors.size() - 2);
    }

    public void setTrueTarget(BasicBlock block) {
        assert (this.getBlock().exit() == this);
        List<BasicBlock> successors = this.getBlock().getSuccessors();
        assert (successors.size() >= 2);
        successors.set(successors.size() - 2, block);
    }

    @Override
    public BasicBlock fallthroughBlock() {
        assert (this.getBlock().exit() == this);
        List<BasicBlock> successors = this.getBlock().getSuccessors();
        assert (successors.size() >= 2);
        return successors.get(successors.size() - 1);
    }

    @Override
    public void setFallthroughBlock(BasicBlock block) {
        List<BasicBlock> successors = this.getBlock().getSuccessors();
        successors.set(successors.size() - 1, block);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        builder.addIf(this);
    }

    @Override
    public String toString() {
        return super.toString() + " " + (Object)((Object)this.type) + " block " + this.getTrueTarget().getNumber() + " (fallthrough " + this.fallthroughBlock().getNumber() + ")";
    }

    @Override
    public int maxInValueRegister() {
        return this.isZeroTest() ? 255 : 15;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "If instructions define no values.";
        return 0;
    }

    @Override
    public void print(CfgPrinter printer) {
        super.print(printer);
        printer.append(" B").append(this.getTrueTarget().getNumber());
    }

    @Override
    public boolean identicalNonValueParts(Instruction other) {
        If o = other.asIf();
        return o.getTrueTarget() == this.getTrueTarget() && o.fallthroughBlock() == this.fallthroughBlock() && o.type == this.type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        assert (other.isIf());
        assert (false) : "Not supported";
        return 0;
    }

    public BasicBlock targetFromCondition(int cond) {
        switch (this.type) {
            case EQ: {
                return cond == 0 ? this.getTrueTarget() : this.fallthroughBlock();
            }
            case NE: {
                return cond != 0 ? this.getTrueTarget() : this.fallthroughBlock();
            }
            case GE: {
                return cond >= 0 ? this.getTrueTarget() : this.fallthroughBlock();
            }
            case GT: {
                return cond > 0 ? this.getTrueTarget() : this.fallthroughBlock();
            }
            case LE: {
                return cond <= 0 ? this.getTrueTarget() : this.fallthroughBlock();
            }
            case LT: {
                return cond < 0 ? this.getTrueTarget() : this.fallthroughBlock();
            }
        }
        throw new Unreachable("Unexpected condition type " + (Object)((Object)this.type));
    }

    @Override
    public boolean isIf() {
        return true;
    }

    @Override
    public If asIf() {
        return this;
    }

    public static enum Type {
        EQ,
        GE,
        GT,
        LE,
        LT,
        NE;


        public Type forSwappedOperands() {
            switch (this) {
                case EQ: 
                case NE: {
                    return this;
                }
                case GE: {
                    return LE;
                }
                case GT: {
                    return LT;
                }
                case LE: {
                    return GE;
                }
                case LT: {
                    return GT;
                }
            }
            throw new Unreachable("Unknown if condition type.");
        }

        public Type inverted() {
            switch (this) {
                case EQ: {
                    return NE;
                }
                case GE: {
                    return LT;
                }
                case GT: {
                    return LE;
                }
                case LE: {
                    return GT;
                }
                case LT: {
                    return GE;
                }
                case NE: {
                    return EQ;
                }
            }
            throw new Unreachable("Unknown if condition type.");
        }
    }
}

