/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.code.Base3Format;
import com.android.tools.r8.code.InvokeVirtualRange;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningOracle;
import java.util.List;

public class InvokeVirtual
extends InvokeMethodWithReceiver {
    public InvokeVirtual(DexMethod target, Value result, List<Value> arguments) {
        super(target, result, arguments);
    }

    @Override
    public Invoke.Type getType() {
        return Invoke.Type.VIRTUAL;
    }

    @Override
    protected String getTypeString() {
        return "Virtual";
    }

    @Override
    public DexEncodedMethod computeSingleTarget(AppInfoWithSubtyping appInfo) {
        return appInfo.lookupSingleVirtualTarget(this.getInvokedMethod());
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Base3Format instruction;
        int argumentRegisters = this.requiredArgumentRegisters();
        builder.requestOutgoingRegisters(argumentRegisters);
        if (this.needsRangedInvoke(builder)) {
            assert (this.argumentsConsecutive(builder));
            int firstRegister = this.argumentRegisterValue(0, builder);
            instruction = new InvokeVirtualRange(firstRegister, argumentRegisters, this.getInvokedMethod());
        } else {
            int[] individualArgumentRegisters = new int[5];
            int argumentRegistersCount = this.fillArgumentRegisters(builder, individualArgumentRegisters);
            instruction = new com.android.tools.r8.code.InvokeVirtual(argumentRegistersCount, this.getInvokedMethod(), individualArgumentRegisters[0], individualArgumentRegisters[1], individualArgumentRegisters[2], individualArgumentRegisters[3], individualArgumentRegisters[4]);
        }
        this.addInvokeAndMoveResult(instruction, builder);
    }

    @Override
    public boolean identicalNonValueParts(Instruction other) {
        if (!other.isInvokeVirtual()) {
            return false;
        }
        return super.identicalNonValueParts(other);
    }

    @Override
    public boolean isInvokeVirtual() {
        return true;
    }

    @Override
    public InvokeVirtual asInvokeVirtual() {
        return this;
    }

    @Override
    public Inliner.InlineAction computeInlining(InliningOracle decider) {
        return decider.computeForInvokeVirtual(this);
    }
}

