/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.Descriptor;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.JarApplicationReader;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.Cmp;
import com.android.tools.r8.ir.code.ConstType;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.Monitor;
import com.android.tools.r8.ir.code.MoveType;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.JarState;
import com.android.tools.r8.ir.conversion.SourceCode;
import it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

public class JarSourceCode
implements SourceCode {
    private static final String INT_ARRAY_DESC = "[I";
    private static final String REFLECT_ARRAY_DESC = "Ljava/lang/reflect/Array;";
    private static final String REFLECT_ARRAY_NEW_INSTANCE_NAME = "newInstance";
    private static final String REFLECT_ARRAY_NEW_INSTANCE_DESC = "(Ljava/lang/Class;[I)Ljava/lang/Object;";
    private static final String METHODHANDLE_INVOKE_OR_INVOKEEXACT_DESC = "([Ljava/lang/Object;)Ljava/lang/Object;";
    private static final Type CLASS_TYPE = Type.getObjectType((String)"java/lang/Class");
    private static final Type STRING_TYPE = Type.getObjectType((String)"java/lang/String");
    private static final Type INT_ARRAY_TYPE = Type.getObjectType((String)"[I");
    private static final Type THROWABLE_TYPE = Type.getObjectType((String)"java/lang/Throwable");
    private static final int[] NO_TARGETS = new int[0];
    private final JarApplicationReader application;
    private final MethodNode node;
    private final DexType clazz;
    private final List<Type> parameterTypes;
    private final LabelNode initialLabel;
    private TraceMethodVisitor printVisitor = null;
    private final JarState state;
    private AbstractInsnNode currentInstruction = null;
    private static final int EXCEPTIONAL_SYNC_EXIT_OFFSET = -2;
    private static final TryCatchBlock EXCEPTIONAL_SYNC_EXIT = new TryCatchBlock(-2, 0, Integer.MAX_VALUE, null);
    private Monitor monitorEnter = null;
    private boolean generatingMethodSynchronization = false;

    public JarSourceCode(DexType clazz, MethodNode node, JarApplicationReader application) {
        assert (node != null);
        assert (node.desc != null);
        this.node = node;
        this.application = application;
        this.clazz = clazz;
        this.parameterTypes = Arrays.asList(Type.getArgumentTypes((String)node.desc));
        this.state = new JarState(node.maxLocals, JarSourceCode.computeLocals(node.localVariables, application));
        AbstractInsnNode first = node.instructions.getFirst();
        this.initialLabel = first instanceof LabelNode ? (LabelNode)first : null;
    }

    private static Map<LocalVariableNode, DebugLocalInfo> computeLocals(List localNodes, JarApplicationReader application) {
        HashMap canonical = new HashMap(localNodes.size());
        HashMap<LocalVariableNode, DebugLocalInfo> localVariables = new HashMap<LocalVariableNode, DebugLocalInfo>(localNodes.size());
        for (Object o : localNodes) {
            LocalVariableNode node = (LocalVariableNode)o;
            localVariables.computeIfAbsent(node, n -> JarSourceCode.canonicalizeLocal(n, canonical, application));
        }
        return localVariables;
    }

    private static DebugLocalInfo canonicalizeLocal(LocalVariableNode node, Map<DebugLocalInfo, DebugLocalInfo> canonicalLocalVariables, JarApplicationReader application) {
        DebugLocalInfo info = new DebugLocalInfo(application.getString(node.name), application.getTypeFromDescriptor(node.desc), node.signature == null ? null : application.getString(node.signature));
        DebugLocalInfo canonical = canonicalLocalVariables.putIfAbsent(info, info);
        return canonical != null ? canonical : info;
    }

    private boolean isStatic() {
        return (this.node.access & 8) > 0;
    }

    private boolean isSynchronized() {
        return (this.node.access & 0x20) > 0;
    }

    private int formalParameterCount() {
        return this.parameterTypes.size();
    }

    private int actualArgumentCount() {
        return this.isStatic() ? this.formalParameterCount() : this.formalParameterCount() + 1;
    }

    @Override
    public int instructionCount() {
        return this.node.instructions.size();
    }

    @Override
    public int instructionIndex(int instructionOffset) {
        return instructionOffset;
    }

    @Override
    public int instructionOffset(int instructionIndex) {
        return instructionIndex;
    }

    @Override
    public boolean verifyRegister(int register) {
        return true;
    }

    @Override
    public void setUp() {
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean needsPrelude() {
        return this.isSynchronized() || this.actualArgumentCount() > 0 || !this.node.localVariables.isEmpty();
    }

    @Override
    public void buildPrelude(IRBuilder builder) {
        HashMap<Integer, MoveType> initializedLocals = new HashMap<Integer, MoveType>(this.node.localVariables.size());
        if (this.initialLabel != null) {
            this.state.openLocals(this.initialLabel);
        }
        int argumentRegister = 0;
        if (!this.isStatic()) {
            Type thisType = Type.getType((String)this.clazz.descriptor.toString());
            int register = this.state.writeLocal(argumentRegister++, thisType);
            builder.addThisArgument(register);
            initializedLocals.put(register, JarSourceCode.moveType(thisType));
        }
        for (Type type : this.parameterTypes) {
            MoveType moveType = JarSourceCode.moveType(type);
            int register = this.state.writeLocal(argumentRegister, type);
            builder.addNonThisArgument(register, moveType);
            argumentRegister += moveType.requiredRegisters();
            initializedLocals.put(register, moveType);
        }
        if (this.isSynchronized()) {
            int monitorRegister;
            this.generatingMethodSynchronization = true;
            Type clazzType = Type.getType((String)this.clazz.toDescriptorString());
            if (this.isStatic()) {
                monitorRegister = this.state.push(clazzType);
                this.state.pop();
                builder.addConstClass(monitorRegister, this.clazz);
            } else {
                assert (this.actualArgumentCount() > 0);
                monitorRegister = this.state.readLocal((int)0, (Type)clazzType).register;
            }
            this.monitorEnter = builder.addMonitor(Monitor.Type.ENTER, monitorRegister);
            this.generatingMethodSynchronization = false;
        }
        for (Object o : this.node.localVariables) {
            LocalVariableNode local = (LocalVariableNode)o;
            Type localType = Type.getType((String)local.desc);
            int localRegister = this.state.getLocalRegister(local.index, localType);
            MoveType exitingLocalType = (MoveType)((Object)initializedLocals.get(localRegister));
            assert (exitingLocalType == null || exitingLocalType == JarSourceCode.moveType(localType));
            if (exitingLocalType != null) continue;
            int localRegister2 = this.state.writeLocal(local.index, localType);
            assert (localRegister == localRegister2);
            initializedLocals.put(localRegister, JarSourceCode.moveType(localType));
            builder.addDebugUninitialized(localRegister, JarSourceCode.constType(localType));
        }
        this.computeBlockEntryJarStates(builder);
    }

    private void computeBlockEntryJarStates(IRBuilder builder) {
        Int2ReferenceSortedMap<IRBuilder.BlockInfo> CFG = builder.getCFG();
        LinkedList<JarStateWorklistItem> worklist = new LinkedList<JarStateWorklistItem>();
        IRBuilder.BlockInfo entry = (IRBuilder.BlockInfo)CFG.get(-1);
        if (CFG.get(0) != null) {
            entry = (IRBuilder.BlockInfo)CFG.get(0);
        }
        worklist.add(new JarStateWorklistItem(entry, 0));
        this.state.recordStateForTarget(0, this);
        JarStateWorklistItem item = (JarStateWorklistItem)worklist.poll();
        while (item != null) {
            int i;
            this.state.restoreState(item.instructionIndex);
            for (i = 0; i < this.node.tryCatchBlocks.size(); ++i) {
                TryCatchBlockNode tryCatchBlockNode = (TryCatchBlockNode)this.node.tryCatchBlocks.get(i);
                if (tryCatchBlockNode.handler != this.getInstruction(item.instructionIndex)) continue;
                this.state.push(THROWABLE_TYPE);
                break;
            }
            for (i = item.instructionIndex; i <= this.instructionCount(); ++i) {
                if (i == this.instructionCount() || i != item.instructionIndex && CFG.containsKey(i)) {
                    item.blockInfo.normalSuccessors.iterator().forEachRemaining(offset -> {
                        if (this.state.recordStateForTarget((int)offset, this) && offset >= 0) {
                            worklist.add(new JarStateWorklistItem((IRBuilder.BlockInfo)CFG.get(offset.intValue()), (int)offset));
                        }
                    });
                    item.blockInfo.exceptionalSuccessors.iterator().forEachRemaining(offset -> {
                        if (this.state.recordStateForExceptionalTarget((int)offset, this) && offset >= 0) {
                            worklist.add(new JarStateWorklistItem((IRBuilder.BlockInfo)CFG.get(offset.intValue()), (int)offset));
                        }
                    });
                    break;
                }
                AbstractInsnNode insn = this.getInstruction(i);
                this.updateState(insn);
                if (JarSourceCode.isControlFlowInstruction(insn)) continue;
                this.updateStateForLocalVariableEnd(insn);
            }
            item = (JarStateWorklistItem)worklist.poll();
        }
    }

    private void updateStateForLocalVariableEnd(AbstractInsnNode insn) {
        assert (!JarSourceCode.isControlFlowInstruction(insn));
        if (!(insn.getNext() instanceof LabelNode)) {
            return;
        }
        LabelNode label = (LabelNode)insn.getNext();
        List<JarState.Local> locals = this.state.getLocalsToClose(label);
        this.state.closeLocals(locals);
    }

    @Override
    public void buildPostlude(IRBuilder builder) {
        if (this.isSynchronized()) {
            this.generatingMethodSynchronization = true;
            this.buildMonitorExit(builder);
            this.generatingMethodSynchronization = false;
        }
    }

    private void buildExceptionalPostlude(IRBuilder builder) {
        assert (this.isSynchronized());
        this.generatingMethodSynchronization = true;
        int exceptionRegister = 0;
        builder.addMoveException(exceptionRegister);
        this.buildMonitorExit(builder);
        builder.addThrow(exceptionRegister);
        this.generatingMethodSynchronization = false;
    }

    private void buildMonitorExit(IRBuilder builder) {
        assert (this.generatingMethodSynchronization);
        builder.add(new Monitor(Monitor.Type.EXIT, this.monitorEnter.inValues().get(0)));
    }

    @Override
    public void closedCurrentBlockWithFallthrough(int fallthroughInstructionIndex) {
    }

    @Override
    public void closedCurrentBlock() {
    }

    @Override
    public void buildInstruction(IRBuilder builder, int instructionIndex) {
        AbstractInsnNode insn;
        if (instructionIndex == -2) {
            this.buildExceptionalPostlude(builder);
            return;
        }
        this.currentInstruction = insn = this.getInstruction(instructionIndex);
        assert (this.verifyExceptionEdgesAreRecorded(insn));
        if (builder.getCFG().containsKey(instructionIndex) || instructionIndex == 0) {
            this.state.restoreState(instructionIndex);
            for (int i = 0; i < this.node.tryCatchBlocks.size(); ++i) {
                TryCatchBlockNode tryCatchBlockNode = (TryCatchBlockNode)this.node.tryCatchBlocks.get(i);
                if (tryCatchBlockNode.handler != insn) continue;
                builder.addMoveException(this.state.push(THROWABLE_TYPE));
                break;
            }
        }
        if (!JarSourceCode.isControlFlowInstruction(insn)) {
            this.processLocalVariableEnd(insn, builder);
        }
        this.build(insn, builder);
    }

    private boolean verifyExceptionEdgesAreRecorded(AbstractInsnNode insn) {
        if (this.canThrow(insn)) {
            for (TryCatchBlock tryCatchBlock : this.getTryHandlers(insn)) {
                assert (tryCatchBlock.getHandler() == -2 || this.state.hasState(tryCatchBlock.getHandler()));
            }
        }
        return true;
    }

    @Override
    public void resolveAndBuildSwitch(int value, int fallthroughOffset, int payloadOffset, IRBuilder builder) {
        throw new Unreachable();
    }

    @Override
    public void resolveAndBuildNewArrayFilledData(int arrayRef, int payloadOffset, IRBuilder builder) {
        throw new Unreachable();
    }

    @Override
    public DebugLocalInfo getCurrentLocal(int register) {
        return this.generatingMethodSynchronization ? null : this.state.getLocalInfoForRegister(register);
    }

    @Override
    public CatchHandlers<Integer> getCurrentCatchHandlers() {
        if (this.generatingMethodSynchronization) {
            return null;
        }
        List<TryCatchBlock> tryCatchBlocks = this.getTryHandlers(this.currentInstruction);
        if (tryCatchBlocks.isEmpty()) {
            return null;
        }
        return new CatchHandlers<Integer>(this.getTryHandlerGuards(tryCatchBlocks), this.getTryHandlerOffsets(tryCatchBlocks));
    }

    @Override
    public boolean verifyCurrentInstructionCanThrow() {
        return this.generatingMethodSynchronization || this.canThrow(this.currentInstruction);
    }

    @Override
    public boolean verifyLocalInScope(DebugLocalInfo local) {
        for (JarState.Local open : this.state.getLocals()) {
            if (open.info == null || open.info.name != local.name) continue;
            return true;
        }
        return false;
    }

    private AbstractInsnNode getInstruction(int index) {
        return this.node.instructions.get(index);
    }

    private static boolean isReturn(AbstractInsnNode insn) {
        return 172 <= insn.getOpcode() && insn.getOpcode() <= 177;
    }

    private static boolean isSwitch(AbstractInsnNode insn) {
        return 170 == insn.getOpcode() || insn.getOpcode() == 171;
    }

    private static boolean isThrow(AbstractInsnNode insn) {
        return 191 == insn.getOpcode();
    }

    private static boolean isControlFlowInstruction(AbstractInsnNode insn) {
        return JarSourceCode.isReturn(insn) || JarSourceCode.isThrow(insn) || JarSourceCode.isSwitch(insn) || insn instanceof JumpInsnNode || insn.getOpcode() == 169;
    }

    private boolean canThrow(AbstractInsnNode insn) {
        switch (insn.getOpcode()) {
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 108: 
            case 109: 
            case 112: 
            case 113: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 197: {
                return true;
            }
            case 18: {
                LdcInsnNode ldc = (LdcInsnNode)insn;
                return ldc.cst instanceof String || ldc.cst instanceof Type;
            }
        }
        return false;
    }

    @Override
    public int traceInstruction(int index, IRBuilder builder) {
        AbstractInsnNode insn = this.getInstruction(index);
        if (insn instanceof LabelNode || insn instanceof LineNumberNode) {
            return -1;
        }
        if (JarSourceCode.isReturn(insn)) {
            return index;
        }
        int[] targets = this.getTargets(insn);
        if (targets != NO_TARGETS) {
            assert (!this.canThrow(insn));
            for (int target : targets) {
                builder.ensureNormalSuccessorBlock(index, target);
            }
            return index;
        }
        if (this.canThrow(insn)) {
            List<TryCatchBlock> tryCatchBlocks = this.getTryHandlers(insn);
            if (!tryCatchBlocks.isEmpty()) {
                HashSet<Integer> seenHandlerOffsets = new HashSet<Integer>();
                for (TryCatchBlock tryCatchBlock : tryCatchBlocks) {
                    builder.ensureBlockWithoutEnqueuing(tryCatchBlock.getStart());
                    int handler = tryCatchBlock.getHandler();
                    if (seenHandlerOffsets.contains(handler)) continue;
                    seenHandlerOffsets.add(handler);
                    builder.ensureExceptionalSuccessorBlock(index, handler);
                }
                if (!JarSourceCode.isThrow(insn)) {
                    builder.ensureNormalSuccessorBlock(index, this.getOffset(insn.getNext()));
                }
                return index;
            }
            return JarSourceCode.isThrow(insn) ? index : -1;
        }
        return -1;
    }

    private List<TryCatchBlock> getPotentialTryHandlers(AbstractInsnNode insn) {
        int offset = this.getOffset(insn);
        return this.getPotentialTryHandlers(offset);
    }

    private boolean tryBlockRelevant(TryCatchBlockNode tryHandler, int offset) {
        int start = this.getOffset((AbstractInsnNode)tryHandler.start);
        int end = this.getOffset((AbstractInsnNode)tryHandler.end);
        return start <= offset && offset < end;
    }

    private List<TryCatchBlock> getPotentialTryHandlers(int offset) {
        ArrayList<TryCatchBlock> handlers = new ArrayList<TryCatchBlock>();
        for (int i = 0; i < this.node.tryCatchBlocks.size(); ++i) {
            TryCatchBlockNode tryBlock = (TryCatchBlockNode)this.node.tryCatchBlocks.get(i);
            if (!this.tryBlockRelevant(tryBlock, offset)) continue;
            handlers.add(new TryCatchBlock(tryBlock, this));
        }
        return handlers;
    }

    private List<TryCatchBlock> getTryHandlers(AbstractInsnNode insn) {
        ArrayList<TryCatchBlock> handlers = new ArrayList<TryCatchBlock>();
        HashSet<String> seen = new HashSet<String>();
        for (TryCatchBlock tryCatchBlock : this.getPotentialTryHandlers(insn)) {
            if (tryCatchBlock.getType() == null) {
                handlers.add(tryCatchBlock);
                return handlers;
            }
            if (seen.contains(tryCatchBlock.getType())) continue;
            seen.add(tryCatchBlock.getType());
            handlers.add(tryCatchBlock);
        }
        if (this.isSynchronized()) {
            assert (handlers.isEmpty() || ((TryCatchBlock)handlers.get(handlers.size() - 1)).getType() != null);
            handlers.add(EXCEPTIONAL_SYNC_EXIT);
        }
        return handlers;
    }

    private List<Integer> getTryHandlerOffsets(List<TryCatchBlock> tryCatchBlocks) {
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        for (TryCatchBlock tryCatchBlock : tryCatchBlocks) {
            offsets.add(tryCatchBlock.getHandler());
        }
        return offsets;
    }

    private List<DexType> getTryHandlerGuards(List<TryCatchBlock> tryCatchBlocks) {
        ArrayList<DexType> guards = new ArrayList<DexType>();
        for (TryCatchBlock tryCatchBlock : tryCatchBlocks) {
            guards.add(tryCatchBlock.getType() == null ? DexItemFactory.catchAllType : this.application.getTypeFromName(tryCatchBlock.getType()));
        }
        return guards;
    }

    int getOffset(AbstractInsnNode insn) {
        return this.node.instructions.indexOf(insn);
    }

    private int[] getTargets(AbstractInsnNode insn) {
        switch (insn.getType()) {
            case 11: {
                TableSwitchInsnNode switchInsn = (TableSwitchInsnNode)insn;
                return this.getSwitchTargets(switchInsn.dflt, switchInsn.labels);
            }
            case 12: {
                LookupSwitchInsnNode switchInsn = (LookupSwitchInsnNode)insn;
                return this.getSwitchTargets(switchInsn.dflt, switchInsn.labels);
            }
            case 7: {
                return this.getJumpTargets((JumpInsnNode)insn);
            }
            case 2: {
                return this.getVarTargets((VarInsnNode)insn);
            }
        }
        return NO_TARGETS;
    }

    private int[] getSwitchTargets(LabelNode dflt, List labels) {
        int[] targets = new int[1 + labels.size()];
        targets[0] = this.getOffset((AbstractInsnNode)dflt);
        for (int i = 1; i < targets.length; ++i) {
            targets[i] = this.getOffset((AbstractInsnNode)((LabelNode)labels.get(i - 1)));
        }
        return targets;
    }

    private int[] getJumpTargets(JumpInsnNode jump) {
        switch (jump.getOpcode()) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 198: 
            case 199: {
                return new int[]{this.getOffset((AbstractInsnNode)jump.label), this.getOffset(jump.getNext())};
            }
            case 167: {
                return new int[]{this.getOffset((AbstractInsnNode)jump.label)};
            }
            case 168: {
                throw new Unreachable("JSR should be handled by the ASM jsr inliner");
            }
        }
        throw new Unreachable("Unexpected opcode in jump instruction: " + jump);
    }

    private int[] getVarTargets(VarInsnNode insn) {
        if (insn.getOpcode() == 169) {
            throw new Unreachable("RET should be handled by the ASM jsr inliner");
        }
        return NO_TARGETS;
    }

    private static MoveType moveType(Type type) {
        switch (type.getSort()) {
            case 9: 
            case 10: {
                return MoveType.OBJECT;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return MoveType.SINGLE;
            }
            case 7: 
            case 8: {
                return MoveType.WIDE;
            }
        }
        throw new Unreachable("Invalid type in moveType: " + type);
    }

    private static ConstType constType(Type type) {
        switch (type.getSort()) {
            case 9: 
            case 10: {
                return ConstType.OBJECT;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return ConstType.INT;
            }
            case 6: {
                return ConstType.FLOAT;
            }
            case 7: {
                return ConstType.LONG;
            }
            case 8: {
                return ConstType.DOUBLE;
            }
        }
        throw new Unreachable("Invalid type in constType: " + type);
    }

    private static MemberType memberType(Type type) {
        switch (type.getSort()) {
            case 9: 
            case 10: {
                return MemberType.OBJECT;
            }
            case 1: {
                return MemberType.BOOLEAN;
            }
            case 3: {
                return MemberType.BYTE;
            }
            case 4: {
                return MemberType.SHORT;
            }
            case 2: {
                return MemberType.CHAR;
            }
            case 5: 
            case 6: {
                return MemberType.SINGLE;
            }
            case 7: 
            case 8: {
                return MemberType.WIDE;
            }
        }
        throw new Unreachable("Invalid type in memberType: " + type);
    }

    private static MemberType memberType(String fieldDesc) {
        return JarSourceCode.memberType(Type.getType((String)fieldDesc));
    }

    private static NumericType numericType(Type type) {
        switch (type.getSort()) {
            case 3: {
                return NumericType.BYTE;
            }
            case 2: {
                return NumericType.CHAR;
            }
            case 4: {
                return NumericType.SHORT;
            }
            case 5: {
                return NumericType.INT;
            }
            case 7: {
                return NumericType.LONG;
            }
            case 6: {
                return NumericType.FLOAT;
            }
            case 8: {
                return NumericType.DOUBLE;
            }
        }
        throw new Unreachable("Invalid type in numericType: " + type);
    }

    private Invoke.Type invokeType(MethodInsnNode method) {
        switch (method.getOpcode()) {
            case 182: {
                if (this.isCallToPolymorphicSignatureMethod(method)) {
                    return Invoke.Type.POLYMORPHIC;
                }
                return Invoke.Type.VIRTUAL;
            }
            case 184: {
                return Invoke.Type.STATIC;
            }
            case 185: {
                return Invoke.Type.INTERFACE;
            }
            case 183: {
                DexType owner = this.application.getTypeFromName(method.owner);
                if (owner == this.clazz || method.name.equals("<init>")) {
                    return Invoke.Type.DIRECT;
                }
                return Invoke.Type.SUPER;
            }
        }
        throw new Unreachable("Unexpected MethodInsnNode opcode: " + method.getOpcode());
    }

    private static Type makeArrayType(Type elementType) {
        return Type.getObjectType((String)("[" + elementType.getDescriptor()));
    }

    private static String arrayTypeDesc(int arrayTypeCode) {
        switch (arrayTypeCode) {
            case 4: {
                return "[Z";
            }
            case 5: {
                return "[C";
            }
            case 6: {
                return "[F";
            }
            case 7: {
                return "[D";
            }
            case 8: {
                return "[B";
            }
            case 9: {
                return "[S";
            }
            case 10: {
                return INT_ARRAY_DESC;
            }
            case 11: {
                return "[J";
            }
        }
        throw new Unreachable("Unexpected array-type code " + arrayTypeCode);
    }

    private static Type getArrayElementTypeForOpcode(int opcode) {
        switch (opcode) {
            case 46: 
            case 79: {
                return Type.INT_TYPE;
            }
            case 48: 
            case 81: {
                return Type.FLOAT_TYPE;
            }
            case 47: 
            case 80: {
                return Type.LONG_TYPE;
            }
            case 49: 
            case 82: {
                return Type.DOUBLE_TYPE;
            }
            case 50: 
            case 83: {
                return JarState.NULL_TYPE;
            }
            case 51: 
            case 84: {
                return Type.BYTE_TYPE;
            }
            case 52: 
            case 85: {
                return Type.CHAR_TYPE;
            }
            case 53: 
            case 86: {
                return Type.SHORT_TYPE;
            }
        }
        throw new Unreachable("Unexpected array opcode " + opcode);
    }

    private static boolean isCompatibleArrayElementType(int opcode, Type type) {
        switch (opcode) {
            case 46: 
            case 79: {
                return JarState.Slot.isCompatible(type, Type.INT_TYPE);
            }
            case 48: 
            case 81: {
                return JarState.Slot.isCompatible(type, Type.FLOAT_TYPE);
            }
            case 47: 
            case 80: {
                return JarState.Slot.isCompatible(type, Type.LONG_TYPE);
            }
            case 49: 
            case 82: {
                return JarState.Slot.isCompatible(type, Type.DOUBLE_TYPE);
            }
            case 50: 
            case 83: {
                return JarState.Slot.isCompatible(type, JarState.REFERENCE_TYPE);
            }
            case 51: 
            case 84: {
                return JarState.Slot.isCompatible(type, Type.BYTE_TYPE) || JarState.Slot.isCompatible(type, Type.BOOLEAN_TYPE);
            }
            case 52: 
            case 85: {
                return JarState.Slot.isCompatible(type, Type.CHAR_TYPE);
            }
            case 53: 
            case 86: {
                return JarState.Slot.isCompatible(type, Type.SHORT_TYPE);
            }
        }
        throw new Unreachable("Unexpected array opcode " + opcode);
    }

    private static If.Type ifType(int opcode) {
        switch (opcode) {
            case 153: 
            case 159: 
            case 165: {
                return If.Type.EQ;
            }
            case 154: 
            case 160: 
            case 166: {
                return If.Type.NE;
            }
            case 155: 
            case 161: {
                return If.Type.LT;
            }
            case 156: 
            case 162: {
                return If.Type.GE;
            }
            case 157: 
            case 163: {
                return If.Type.GT;
            }
            case 158: 
            case 164: {
                return If.Type.LE;
            }
        }
        throw new Unreachable("Unexpected If instruction opcode: " + opcode);
    }

    private static Type opType(int opcode) {
        switch (opcode) {
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 116: 
            case 120: 
            case 122: 
            case 124: {
                return Type.INT_TYPE;
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 117: 
            case 121: 
            case 123: 
            case 125: {
                return Type.LONG_TYPE;
            }
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: 
            case 118: {
                return Type.FLOAT_TYPE;
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: 
            case 119: {
                return Type.DOUBLE_TYPE;
            }
        }
        throw new Unreachable("Unexpected opcode " + opcode);
    }

    private void updateState(AbstractInsnNode insn) {
        switch (insn.getType()) {
            case 0: {
                this.updateState((InsnNode)insn);
                break;
            }
            case 1: {
                this.updateState((IntInsnNode)insn);
                break;
            }
            case 2: {
                this.updateState((VarInsnNode)insn);
                break;
            }
            case 3: {
                this.updateState((TypeInsnNode)insn);
                break;
            }
            case 4: {
                this.updateState((FieldInsnNode)insn);
                break;
            }
            case 5: {
                this.updateState((MethodInsnNode)insn);
                break;
            }
            case 6: {
                this.updateState((InvokeDynamicInsnNode)insn);
                break;
            }
            case 7: {
                this.updateState((JumpInsnNode)insn);
                break;
            }
            case 8: {
                this.updateState((LabelNode)insn);
                break;
            }
            case 9: {
                this.updateState((LdcInsnNode)insn);
                break;
            }
            case 10: {
                this.updateState((IincInsnNode)insn);
                break;
            }
            case 11: {
                this.updateState((TableSwitchInsnNode)insn);
                break;
            }
            case 12: {
                this.updateState((LookupSwitchInsnNode)insn);
                break;
            }
            case 13: {
                this.updateState((MultiANewArrayInsnNode)insn);
                break;
            }
            case 15: {
                this.updateState((LineNumberNode)insn);
                break;
            }
            default: {
                throw new Unreachable("Unexpected instruction " + insn);
            }
        }
    }

    private void updateState(InsnNode insn) {
        int opcode = insn.getOpcode();
        switch (opcode) {
            case 0: {
                break;
            }
            case 1: {
                this.state.push(JarState.NULL_TYPE);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.state.push(Type.INT_TYPE);
                break;
            }
            case 9: 
            case 10: {
                this.state.push(Type.LONG_TYPE);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                this.state.push(Type.FLOAT_TYPE);
                break;
            }
            case 14: 
            case 15: {
                this.state.push(Type.DOUBLE_TYPE);
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                this.state.pop();
                Type elementType = this.state.pop(JarState.ARRAY_TYPE).getArrayElementType();
                if (elementType == null) {
                    elementType = JarState.NULL_TYPE;
                }
                this.state.push(elementType);
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.state.pop();
                this.state.pop();
                this.state.pop();
                break;
            }
            case 87: {
                JarState.Slot value = this.state.pop();
                assert (value.isCategory1());
                break;
            }
            case 88: {
                JarState.Slot value = this.state.pop();
                if (!value.isCategory1()) break;
                JarState.Slot value2 = this.state.pop();
                assert (value2.isCategory1());
                break;
            }
            case 89: {
                JarState.Slot value = this.state.peek();
                assert (value.isCategory1());
                this.state.push(value.type);
                break;
            }
            case 90: {
                JarState.Slot value1 = this.state.pop();
                JarState.Slot value2 = this.state.pop();
                assert (value1.isCategory1() && value2.isCategory1());
                int stack2 = this.state.push(value1.type);
                int stack1 = this.state.push(value2.type);
                this.state.push(value1.type);
                assert (value2.register == stack2);
                assert (value1.register == stack1);
                break;
            }
            case 91: {
                JarState.Slot value1 = this.state.pop();
                JarState.Slot value2 = this.state.pop();
                assert (value1.isCategory1());
                if (value2.isCategory1()) {
                    JarState.Slot value3 = this.state.pop();
                    assert (value3.isCategory1());
                    this.updateStateForDupOneBelowTwo(value3, value2, value1);
                    break;
                }
                this.updateStateForDupOneBelowOne(value2, value1);
                break;
            }
            case 92: {
                JarState.Slot value1 = this.state.pop();
                if (value1.isCategory1()) {
                    JarState.Slot value2 = this.state.pop();
                    assert (value2.isCategory1());
                    this.state.push(value2.type);
                    this.state.push(value1.type);
                    this.state.push(value2.type);
                    this.state.push(value1.type);
                    break;
                }
                this.state.push(value1.type);
                this.state.push(value1.type);
                break;
            }
            case 93: {
                JarState.Slot value1 = this.state.pop();
                JarState.Slot value2 = this.state.pop();
                assert (value2.isCategory1());
                if (value1.isCategory1()) {
                    JarState.Slot value3 = this.state.pop();
                    assert (value3.isCategory1());
                    this.updateStateForDupTwoBelowOne(value3, value2, value1);
                    break;
                }
                this.updateStateForDupOneBelowOne(value2, value1);
                break;
            }
            case 94: {
                JarState.Slot value1 = this.state.pop();
                JarState.Slot value2 = this.state.pop();
                if (!value1.isCategory1() && !value2.isCategory1()) {
                    this.updateStateForDupOneBelowOne(value2, value1);
                    break;
                }
                JarState.Slot value3 = this.state.pop();
                if (!value1.isCategory1()) {
                    assert (value2.isCategory1());
                    assert (value3.isCategory1());
                    this.updateStateForDupOneBelowTwo(value3, value2, value1);
                    break;
                }
                if (!value3.isCategory1()) {
                    assert (value1.isCategory1());
                    assert (value2.isCategory1());
                    this.updateStateForDupTwoBelowOne(value3, value2, value1);
                    break;
                }
                JarState.Slot value4 = this.state.pop();
                assert (value1.isCategory1());
                assert (value2.isCategory1());
                assert (value3.isCategory1());
                assert (value4.isCategory1());
                this.updateStateForDupTwoBelowTwo(value4, value3, value2, value1);
                break;
            }
            case 95: {
                JarState.Slot value1 = this.state.pop();
                JarState.Slot value2 = this.state.pop();
                assert (value1.isCategory1() && value2.isCategory1());
                this.state.push(value1.type);
                this.state.push(value2.type);
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                Type type = JarSourceCode.opType(opcode);
                this.state.pop();
                this.state.pop();
                this.state.push(type);
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                Type type = JarSourceCode.opType(opcode);
                this.state.pop();
                this.state.push(type);
                break;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: {
                Type type = JarSourceCode.opType(opcode);
                this.state.pop();
                this.state.pop();
                this.state.push(type);
                break;
            }
            case 126: 
            case 127: {
                Type type = opcode == 126 ? Type.INT_TYPE : Type.LONG_TYPE;
                this.state.pop();
                this.state.pop();
                this.state.push(type);
                break;
            }
            case 128: 
            case 129: {
                Type type = opcode == 128 ? Type.INT_TYPE : Type.LONG_TYPE;
                this.state.pop();
                this.state.pop();
                this.state.push(type);
                break;
            }
            case 130: 
            case 131: {
                Type type = opcode == 130 ? Type.INT_TYPE : Type.LONG_TYPE;
                this.state.pop();
                this.state.pop();
                this.state.push(type);
                break;
            }
            case 133: {
                this.updateStateForConversion(Type.INT_TYPE, Type.LONG_TYPE);
                break;
            }
            case 134: {
                this.updateStateForConversion(Type.INT_TYPE, Type.FLOAT_TYPE);
                break;
            }
            case 135: {
                this.updateStateForConversion(Type.INT_TYPE, Type.DOUBLE_TYPE);
                break;
            }
            case 136: {
                this.updateStateForConversion(Type.LONG_TYPE, Type.INT_TYPE);
                break;
            }
            case 137: {
                this.updateStateForConversion(Type.LONG_TYPE, Type.FLOAT_TYPE);
                break;
            }
            case 138: {
                this.updateStateForConversion(Type.LONG_TYPE, Type.DOUBLE_TYPE);
                break;
            }
            case 139: {
                this.updateStateForConversion(Type.FLOAT_TYPE, Type.INT_TYPE);
                break;
            }
            case 140: {
                this.updateStateForConversion(Type.FLOAT_TYPE, Type.LONG_TYPE);
                break;
            }
            case 141: {
                this.updateStateForConversion(Type.FLOAT_TYPE, Type.DOUBLE_TYPE);
                break;
            }
            case 142: {
                this.updateStateForConversion(Type.DOUBLE_TYPE, Type.INT_TYPE);
                break;
            }
            case 143: {
                this.updateStateForConversion(Type.DOUBLE_TYPE, Type.LONG_TYPE);
                break;
            }
            case 144: {
                this.updateStateForConversion(Type.DOUBLE_TYPE, Type.FLOAT_TYPE);
                break;
            }
            case 145: {
                this.updateStateForConversion(Type.INT_TYPE, Type.BYTE_TYPE);
                break;
            }
            case 146: {
                this.updateStateForConversion(Type.INT_TYPE, Type.CHAR_TYPE);
                break;
            }
            case 147: {
                this.updateStateForConversion(Type.INT_TYPE, Type.SHORT_TYPE);
                break;
            }
            case 148: {
                this.state.pop();
                this.state.pop();
                this.state.push(Type.INT_TYPE);
                break;
            }
            case 149: 
            case 150: {
                this.state.pop();
                this.state.pop();
                this.state.push(Type.INT_TYPE);
                break;
            }
            case 151: 
            case 152: {
                this.state.pop();
                this.state.pop();
                this.state.push(Type.INT_TYPE);
                break;
            }
            case 172: {
                this.state.pop();
                break;
            }
            case 173: {
                this.state.pop();
                break;
            }
            case 174: {
                this.state.pop();
                break;
            }
            case 175: {
                this.state.pop();
                break;
            }
            case 176: {
                this.state.pop(JarState.REFERENCE_TYPE);
                break;
            }
            case 177: {
                break;
            }
            case 190: {
                this.state.pop(JarState.ARRAY_TYPE);
                this.state.push(Type.INT_TYPE);
                break;
            }
            case 191: {
                this.state.pop(JarState.OBJECT_TYPE);
                break;
            }
            case 194: {
                this.state.pop(JarState.REFERENCE_TYPE);
                break;
            }
            case 195: {
                this.state.pop(JarState.REFERENCE_TYPE);
                break;
            }
            default: {
                throw new Unreachable("Unexpected Insn opcode: " + insn.getOpcode());
            }
        }
    }

    private void updateStateForDupOneBelowTwo(JarState.Slot value3, JarState.Slot value2, JarState.Slot value1) {
        this.state.push(value1.type);
        this.state.push(value3.type);
        this.state.push(value2.type);
        this.state.push(value1.type);
    }

    private void updateStateForDupOneBelowOne(JarState.Slot value2, JarState.Slot value1) {
        this.state.push(value1.type);
        this.state.push(value2.type);
        this.state.push(value1.type);
    }

    private void updateStateForDupTwoBelowOne(JarState.Slot value3, JarState.Slot value2, JarState.Slot value1) {
        this.state.push(value2.type);
        this.state.push(value1.type);
        this.state.push(value3.type);
        this.state.push(value2.type);
        this.state.push(value1.type);
    }

    private void updateStateForDupTwoBelowTwo(JarState.Slot value4, JarState.Slot value3, JarState.Slot value2, JarState.Slot value1) {
        this.state.push(value2.type);
        this.state.push(value1.type);
        this.state.push(value4.type);
        this.state.push(value3.type);
        this.state.push(value2.type);
        this.state.push(value1.type);
    }

    private void updateState(IntInsnNode insn) {
        switch (insn.getOpcode()) {
            case 16: 
            case 17: {
                this.state.push(Type.INT_TYPE);
                break;
            }
            case 188: {
                String desc = JarSourceCode.arrayTypeDesc(insn.operand);
                Type type = Type.getType((String)desc);
                this.state.pop();
                this.state.push(type);
                break;
            }
            default: {
                throw new Unreachable("Unexpected IntInsn opcode: " + insn.getOpcode());
            }
        }
    }

    private void updateState(VarInsnNode insn) {
        Type expectedType;
        int opcode = insn.getOpcode();
        switch (opcode) {
            case 21: 
            case 54: {
                expectedType = Type.INT_TYPE;
                break;
            }
            case 23: 
            case 56: {
                expectedType = Type.FLOAT_TYPE;
                break;
            }
            case 22: 
            case 55: {
                expectedType = Type.LONG_TYPE;
                break;
            }
            case 24: 
            case 57: {
                expectedType = Type.DOUBLE_TYPE;
                break;
            }
            case 25: 
            case 58: {
                expectedType = JarState.REFERENCE_TYPE;
                break;
            }
            case 169: {
                throw new Unreachable("RET should be handled by the ASM jsr inliner");
            }
            default: {
                throw new Unreachable("Unexpected VarInsn opcode: " + insn.getOpcode());
            }
        }
        if (21 <= opcode && opcode <= 25) {
            JarState.Slot src = this.state.readLocal(insn.var, expectedType);
            this.state.push(src.type);
        } else {
            assert (54 <= opcode && opcode <= 58);
            JarState.Slot slot = this.state.pop();
            if (slot.type == JarState.NULL_TYPE && expectedType != JarState.REFERENCE_TYPE) {
                this.state.writeLocal(insn.var, expectedType);
            } else {
                this.state.writeLocal(insn.var, slot.type);
            }
        }
    }

    private void updateState(TypeInsnNode insn) {
        Type type = Type.getObjectType((String)insn.desc);
        switch (insn.getOpcode()) {
            case 187: {
                this.state.push(type);
                break;
            }
            case 189: {
                Type arrayType = JarSourceCode.makeArrayType(type);
                this.state.pop();
                this.state.push(arrayType);
                break;
            }
            case 192: {
                this.state.pop(type);
                this.state.push(type);
                break;
            }
            case 193: {
                this.state.pop(JarState.REFERENCE_TYPE);
                this.state.push(Type.INT_TYPE);
                break;
            }
            default: {
                throw new Unreachable("Unexpected TypeInsn opcode: " + insn.getOpcode());
            }
        }
    }

    private void updateState(FieldInsnNode insn) {
        Type type = Type.getType((String)insn.desc);
        switch (insn.getOpcode()) {
            case 178: {
                this.state.push(type);
                break;
            }
            case 179: {
                this.state.pop();
                break;
            }
            case 180: {
                this.state.pop(JarState.OBJECT_TYPE);
                this.state.push(type);
                break;
            }
            case 181: {
                this.state.pop();
                this.state.pop(JarState.OBJECT_TYPE);
                break;
            }
            default: {
                throw new Unreachable("Unexpected FieldInsn opcode: " + insn.getOpcode());
            }
        }
    }

    private void updateState(MethodInsnNode insn) {
        this.updateStateForInvoke(insn.desc, insn.getOpcode() != 184);
    }

    private void updateState(InvokeDynamicInsnNode insn) {
        this.updateStateForInvoke(insn.desc, false);
    }

    private void updateStateForInvoke(String desc, boolean implicitReceiver) {
        Type returnType;
        Type[] parameterTypes = Type.getArgumentTypes((String)desc);
        this.state.popReverse(parameterTypes.length);
        if (implicitReceiver) {
            this.state.pop();
        }
        if ((returnType = Type.getReturnType((String)desc)) != Type.VOID_TYPE) {
            this.state.push(returnType);
        }
    }

    private void updateState(JumpInsnNode insn) {
        int[] targets = this.getTargets((AbstractInsnNode)insn);
        int opcode = insn.getOpcode();
        if (153 <= opcode && opcode <= 166) {
            assert (targets.length == 2);
            if (opcode <= 158) {
                this.state.pop();
            } else {
                this.state.pop();
                this.state.pop();
            }
        } else {
            switch (opcode) {
                case 167: {
                    assert (targets.length == 1);
                    break;
                }
                case 198: 
                case 199: {
                    this.state.pop();
                    break;
                }
                case 168: {
                    throw new Unreachable("JSR should be handled by the ASM jsr inliner");
                }
                default: {
                    throw new Unreachable("Unexpected JumpInsn opcode: " + insn.getOpcode());
                }
            }
        }
    }

    private void updateState(LabelNode insn) {
        if (insn != this.initialLabel) {
            this.state.openLocals(insn);
        }
    }

    private void updateState(LdcInsnNode insn) {
        if (insn.cst instanceof Type) {
            Type type = (Type)insn.cst;
            this.state.push(type);
        } else if (insn.cst instanceof String) {
            this.state.push(STRING_TYPE);
        } else if (insn.cst instanceof Long) {
            this.state.push(Type.LONG_TYPE);
        } else if (insn.cst instanceof Double) {
            this.state.push(Type.DOUBLE_TYPE);
        } else if (insn.cst instanceof Integer) {
            this.state.push(Type.INT_TYPE);
        } else {
            assert (insn.cst instanceof Float);
            this.state.push(Type.FLOAT_TYPE);
        }
    }

    private void updateState(IincInsnNode insn) {
        this.state.readLocal(insn.var, Type.INT_TYPE);
    }

    private void updateState(TableSwitchInsnNode insn) {
        this.state.pop();
    }

    private void updateState(LookupSwitchInsnNode insn) {
        this.state.pop();
    }

    private void updateState(MultiANewArrayInsnNode insn) {
        Type arrayType = Type.getObjectType((String)insn.desc);
        this.state.popReverse(insn.dims, Type.INT_TYPE);
        this.state.push(arrayType);
    }

    private void updateState(LineNumberNode insn) {
    }

    private void updateStateForConversion(Type from, Type to) {
        this.state.pop();
        this.state.push(to);
    }

    private void build(AbstractInsnNode insn, IRBuilder builder) {
        switch (insn.getType()) {
            case 0: {
                this.build((InsnNode)insn, builder);
                break;
            }
            case 1: {
                this.build((IntInsnNode)insn, builder);
                break;
            }
            case 2: {
                this.build((VarInsnNode)insn, builder);
                break;
            }
            case 3: {
                this.build((TypeInsnNode)insn, builder);
                break;
            }
            case 4: {
                this.build((FieldInsnNode)insn, builder);
                break;
            }
            case 5: {
                this.build((MethodInsnNode)insn, builder);
                break;
            }
            case 6: {
                this.build((InvokeDynamicInsnNode)insn, builder);
                break;
            }
            case 7: {
                this.build((JumpInsnNode)insn, builder);
                break;
            }
            case 8: {
                this.build((LabelNode)insn, builder);
                break;
            }
            case 9: {
                this.build((LdcInsnNode)insn, builder);
                break;
            }
            case 10: {
                this.build((IincInsnNode)insn, builder);
                break;
            }
            case 11: {
                this.build((TableSwitchInsnNode)insn, builder);
                break;
            }
            case 12: {
                this.build((LookupSwitchInsnNode)insn, builder);
                break;
            }
            case 13: {
                this.build((MultiANewArrayInsnNode)insn, builder);
                break;
            }
            case 15: {
                this.build((LineNumberNode)insn, builder);
                break;
            }
            default: {
                throw new Unreachable("Unexpected instruction " + insn);
            }
        }
    }

    private void processLocalVariableEnd(AbstractInsnNode insn, IRBuilder builder) {
        assert (!JarSourceCode.isControlFlowInstruction(insn));
        if (!(insn.getNext() instanceof LabelNode)) {
            return;
        }
        LabelNode label = (LabelNode)insn.getNext();
        List<JarState.Local> locals = this.state.getLocalsToClose(label);
        for (JarState.Local local : locals) {
            builder.addDebugLocalEnd(local.slot.register, local.info);
        }
        this.state.closeLocals(locals);
    }

    private void processLocalVariablesAtControlEdge(AbstractInsnNode insn, IRBuilder builder) {
        assert (JarSourceCode.isControlFlowInstruction(insn) && !JarSourceCode.isReturn(insn));
        if (!(insn.getNext() instanceof LabelNode)) {
            return;
        }
        LabelNode label = (LabelNode)insn.getNext();
        for (JarState.Local local : this.state.getLocalsToClose(label)) {
            builder.addDebugLocalRead(local.slot.register, local.info);
        }
    }

    private void processLocalVariablesAtExit(AbstractInsnNode insn, IRBuilder builder) {
        assert (JarSourceCode.isReturn(insn) || JarSourceCode.isThrow(insn));
        for (JarState.Local local : this.state.getLocals()) {
            if (local.info == null) continue;
            builder.addDebugLocalRead(local.slot.register, local.info);
        }
    }

    private void build(InsnNode insn, IRBuilder builder) {
        int opcode = insn.getOpcode();
        switch (opcode) {
            case 0: {
                break;
            }
            case 1: {
                builder.addNullConst(this.state.push(JarState.NULL_TYPE), 0L);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                builder.addIntConst(this.state.push(Type.INT_TYPE), opcode - 3);
                break;
            }
            case 9: 
            case 10: {
                builder.addLongConst(this.state.push(Type.LONG_TYPE), opcode - 9);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                builder.addFloatConst(this.state.push(Type.FLOAT_TYPE), Float.floatToRawIntBits(opcode - 11));
                break;
            }
            case 14: 
            case 15: {
                builder.addDoubleConst(this.state.push(Type.DOUBLE_TYPE), Double.doubleToRawLongBits(opcode - 14));
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                JarState.Slot index = this.state.pop(Type.INT_TYPE);
                JarState.Slot array = this.state.pop(JarState.ARRAY_TYPE);
                Type elementType = array.getArrayElementType();
                if (elementType == null) {
                    elementType = JarSourceCode.getArrayElementTypeForOpcode(opcode);
                }
                int dest = this.state.push(elementType);
                assert (JarSourceCode.isCompatibleArrayElementType(opcode, elementType));
                builder.addArrayGet(JarSourceCode.memberType(elementType), dest, array.register, index.register);
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                JarState.Slot value = this.state.pop();
                JarState.Slot index = this.state.pop(Type.INT_TYPE);
                JarState.Slot array = this.state.pop(JarState.ARRAY_TYPE);
                Type elementType = array.getArrayElementType();
                if (elementType == null) {
                    elementType = JarSourceCode.getArrayElementTypeForOpcode(opcode);
                }
                assert (JarSourceCode.isCompatibleArrayElementType(opcode, elementType));
                assert (JarSourceCode.isCompatibleArrayElementType(opcode, value.type));
                builder.addArrayPut(JarSourceCode.memberType(elementType), value.register, array.register, index.register);
                break;
            }
            case 87: {
                JarState.Slot value = this.state.pop();
                assert (value.isCategory1());
                break;
            }
            case 88: {
                JarState.Slot value = this.state.pop();
                if (!value.isCategory1()) break;
                JarState.Slot value2 = this.state.pop();
                assert (value2.isCategory1());
                break;
            }
            case 89: {
                JarState.Slot value = this.state.peek();
                assert (value.isCategory1());
                int copy = this.state.push(value.type);
                builder.addMove(JarSourceCode.moveType(value.type), copy, value.register);
                break;
            }
            case 90: {
                JarState.Slot value1 = this.state.pop();
                JarState.Slot value2 = this.state.pop();
                assert (value1.isCategory1() && value2.isCategory1());
                int stack2 = this.state.push(value1.type);
                int stack1 = this.state.push(value2.type);
                int stack0 = this.state.push(value1.type);
                assert (value2.register == stack2);
                assert (value1.register == stack1);
                builder.addMove(JarSourceCode.moveType(value1.type), stack0, stack1);
                builder.addMove(JarSourceCode.moveType(value2.type), stack1, stack2);
                builder.addMove(JarSourceCode.moveType(value1.type), stack2, stack0);
                break;
            }
            case 91: {
                JarState.Slot value1 = this.state.pop();
                JarState.Slot value2 = this.state.pop();
                assert (value1.isCategory1());
                if (value2.isCategory1()) {
                    JarState.Slot value3 = this.state.pop();
                    assert (value3.isCategory1());
                    this.dupOneBelowTwo(value3, value2, value1, builder);
                    break;
                }
                this.dupOneBelowOne(value2, value1, builder);
                break;
            }
            case 92: {
                JarState.Slot value1 = this.state.pop();
                if (value1.isCategory1()) {
                    JarState.Slot value2 = this.state.pop();
                    assert (value2.isCategory1());
                    this.state.push(value2.type);
                    this.state.push(value1.type);
                    int copy2 = this.state.push(value2.type);
                    int copy1 = this.state.push(value1.type);
                    builder.addMove(JarSourceCode.moveType(value1.type), copy1, value1.register);
                    builder.addMove(JarSourceCode.moveType(value2.type), copy2, value2.register);
                    break;
                }
                this.state.push(value1.type);
                int copy1 = this.state.push(value1.type);
                builder.addMove(JarSourceCode.moveType(value1.type), copy1, value1.register);
                break;
            }
            case 93: {
                JarState.Slot value1 = this.state.pop();
                JarState.Slot value2 = this.state.pop();
                assert (value2.isCategory1());
                if (value1.isCategory1()) {
                    JarState.Slot value3 = this.state.pop();
                    assert (value3.isCategory1());
                    this.dupTwoBelowOne(value3, value2, value1, builder);
                    break;
                }
                this.dupOneBelowOne(value2, value1, builder);
                break;
            }
            case 94: {
                JarState.Slot value1 = this.state.pop();
                JarState.Slot value2 = this.state.pop();
                if (!value1.isCategory1() && !value2.isCategory1()) {
                    this.dupOneBelowOne(value2, value1, builder);
                    break;
                }
                JarState.Slot value3 = this.state.pop();
                if (!value1.isCategory1()) {
                    assert (value2.isCategory1());
                    assert (value3.isCategory1());
                    this.dupOneBelowTwo(value3, value2, value1, builder);
                    break;
                }
                if (!value3.isCategory1()) {
                    assert (value1.isCategory1());
                    assert (value2.isCategory1());
                    this.dupTwoBelowOne(value3, value2, value1, builder);
                    break;
                }
                JarState.Slot value4 = this.state.pop();
                assert (value1.isCategory1());
                assert (value2.isCategory1());
                assert (value3.isCategory1());
                assert (value4.isCategory1());
                this.dupTwoBelowTwo(value4, value3, value2, value1, builder);
                break;
            }
            case 95: {
                JarState.Slot value1 = this.state.pop();
                JarState.Slot value2 = this.state.pop();
                assert (value1.isCategory1() && value2.isCategory1());
                this.state.push(value1.type);
                this.state.push(value2.type);
                int tmp = this.state.push(value1.type);
                builder.addMove(JarSourceCode.moveType(value1.type), tmp, value1.register);
                builder.addMove(JarSourceCode.moveType(value2.type), value1.register, value2.register);
                builder.addMove(JarSourceCode.moveType(value1.type), value2.register, tmp);
                this.state.pop();
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                Type type = JarSourceCode.opType(opcode);
                NumericType numericType = JarSourceCode.numericType(type);
                int right = this.state.pop((Type)type).register;
                int left = this.state.pop((Type)type).register;
                int dest = this.state.push(type);
                if (opcode <= 99) {
                    builder.addAdd(numericType, dest, left, right);
                    break;
                }
                if (opcode <= 103) {
                    builder.addSub(numericType, dest, left, right);
                    break;
                }
                if (opcode <= 107) {
                    builder.addMul(numericType, dest, left, right);
                    break;
                }
                if (opcode <= 111) {
                    builder.addDiv(numericType, dest, left, right);
                    break;
                }
                assert (112 <= opcode && opcode <= 115);
                builder.addRem(numericType, dest, left, right);
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                Type type = JarSourceCode.opType(opcode);
                NumericType numericType = JarSourceCode.numericType(type);
                int value = this.state.pop((Type)type).register;
                int dest = this.state.push(type);
                builder.addNeg(numericType, dest, value);
                break;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: {
                Type type = JarSourceCode.opType(opcode);
                NumericType numericType = JarSourceCode.numericType(type);
                int right = this.state.pop((Type)Type.INT_TYPE).register;
                int left = this.state.pop((Type)type).register;
                int dest = this.state.push(type);
                if (opcode <= 121) {
                    builder.addShl(numericType, dest, left, right);
                    break;
                }
                if (opcode <= 123) {
                    builder.addShr(numericType, dest, left, right);
                    break;
                }
                assert (opcode == 124 || opcode == 125);
                builder.addUshr(numericType, dest, left, right);
                break;
            }
            case 126: 
            case 127: {
                Type type = opcode == 126 ? Type.INT_TYPE : Type.LONG_TYPE;
                int right = this.state.pop((Type)type).register;
                int left = this.state.pop((Type)type).register;
                int dest = this.state.push(type);
                builder.addAnd(JarSourceCode.numericType(type), dest, left, right);
                break;
            }
            case 128: 
            case 129: {
                Type type = opcode == 128 ? Type.INT_TYPE : Type.LONG_TYPE;
                int right = this.state.pop((Type)type).register;
                int left = this.state.pop((Type)type).register;
                int dest = this.state.push(type);
                builder.addOr(JarSourceCode.numericType(type), dest, left, right);
                break;
            }
            case 130: 
            case 131: {
                Type type = opcode == 130 ? Type.INT_TYPE : Type.LONG_TYPE;
                int right = this.state.pop((Type)type).register;
                int left = this.state.pop((Type)type).register;
                int dest = this.state.push(type);
                builder.addXor(JarSourceCode.numericType(type), dest, left, right);
                break;
            }
            case 133: {
                this.buildConversion(Type.INT_TYPE, Type.LONG_TYPE, builder);
                break;
            }
            case 134: {
                this.buildConversion(Type.INT_TYPE, Type.FLOAT_TYPE, builder);
                break;
            }
            case 135: {
                this.buildConversion(Type.INT_TYPE, Type.DOUBLE_TYPE, builder);
                break;
            }
            case 136: {
                this.buildConversion(Type.LONG_TYPE, Type.INT_TYPE, builder);
                break;
            }
            case 137: {
                this.buildConversion(Type.LONG_TYPE, Type.FLOAT_TYPE, builder);
                break;
            }
            case 138: {
                this.buildConversion(Type.LONG_TYPE, Type.DOUBLE_TYPE, builder);
                break;
            }
            case 139: {
                this.buildConversion(Type.FLOAT_TYPE, Type.INT_TYPE, builder);
                break;
            }
            case 140: {
                this.buildConversion(Type.FLOAT_TYPE, Type.LONG_TYPE, builder);
                break;
            }
            case 141: {
                this.buildConversion(Type.FLOAT_TYPE, Type.DOUBLE_TYPE, builder);
                break;
            }
            case 142: {
                this.buildConversion(Type.DOUBLE_TYPE, Type.INT_TYPE, builder);
                break;
            }
            case 143: {
                this.buildConversion(Type.DOUBLE_TYPE, Type.LONG_TYPE, builder);
                break;
            }
            case 144: {
                this.buildConversion(Type.DOUBLE_TYPE, Type.FLOAT_TYPE, builder);
                break;
            }
            case 145: {
                this.buildConversion(Type.INT_TYPE, Type.BYTE_TYPE, builder);
                break;
            }
            case 146: {
                this.buildConversion(Type.INT_TYPE, Type.CHAR_TYPE, builder);
                break;
            }
            case 147: {
                this.buildConversion(Type.INT_TYPE, Type.SHORT_TYPE, builder);
                break;
            }
            case 148: {
                JarState.Slot right = this.state.pop(Type.LONG_TYPE);
                JarState.Slot left = this.state.pop(Type.LONG_TYPE);
                int dest = this.state.push(Type.INT_TYPE);
                builder.addCmp(NumericType.LONG, Cmp.Bias.NONE, dest, left.register, right.register);
                break;
            }
            case 149: 
            case 150: {
                JarState.Slot right = this.state.pop(Type.FLOAT_TYPE);
                JarState.Slot left = this.state.pop(Type.FLOAT_TYPE);
                int dest = this.state.push(Type.INT_TYPE);
                Cmp.Bias bias = opcode == 149 ? Cmp.Bias.LT : Cmp.Bias.GT;
                builder.addCmp(NumericType.FLOAT, bias, dest, left.register, right.register);
                break;
            }
            case 151: 
            case 152: {
                JarState.Slot right = this.state.pop(Type.DOUBLE_TYPE);
                JarState.Slot left = this.state.pop(Type.DOUBLE_TYPE);
                int dest = this.state.push(Type.INT_TYPE);
                Cmp.Bias bias = opcode == 151 ? Cmp.Bias.LT : Cmp.Bias.GT;
                builder.addCmp(NumericType.DOUBLE, bias, dest, left.register, right.register);
                break;
            }
            case 172: {
                JarState.Slot value = this.state.pop(Type.INT_TYPE);
                this.addReturn(insn, MoveType.SINGLE, value.register, builder);
                break;
            }
            case 173: {
                JarState.Slot value = this.state.pop(Type.LONG_TYPE);
                this.addReturn(insn, MoveType.WIDE, value.register, builder);
                break;
            }
            case 174: {
                JarState.Slot value = this.state.pop(Type.FLOAT_TYPE);
                this.addReturn(insn, MoveType.SINGLE, value.register, builder);
                break;
            }
            case 175: {
                JarState.Slot value = this.state.pop(Type.DOUBLE_TYPE);
                this.addReturn(insn, MoveType.WIDE, value.register, builder);
                break;
            }
            case 176: {
                JarState.Slot obj = this.state.pop(JarState.REFERENCE_TYPE);
                this.addReturn(insn, MoveType.OBJECT, obj.register, builder);
                break;
            }
            case 177: {
                this.addReturn(insn, null, -1, builder);
                break;
            }
            case 190: {
                JarState.Slot array = this.state.pop(JarState.ARRAY_TYPE);
                int dest = this.state.push(Type.INT_TYPE);
                builder.addArrayLength(dest, array.register);
                break;
            }
            case 191: {
                JarState.Slot object = this.state.pop(JarState.OBJECT_TYPE);
                this.addThrow(insn, object.register, builder);
                break;
            }
            case 194: {
                JarState.Slot object = this.state.pop(JarState.REFERENCE_TYPE);
                builder.addMonitor(Monitor.Type.ENTER, object.register);
                break;
            }
            case 195: {
                JarState.Slot object = this.state.pop(JarState.REFERENCE_TYPE);
                builder.addMonitor(Monitor.Type.EXIT, object.register);
                break;
            }
            default: {
                throw new Unreachable("Unexpected Insn opcode: " + insn.getOpcode());
            }
        }
    }

    private void addThrow(InsnNode insn, int register, IRBuilder builder) {
        if (this.getTryHandlers((AbstractInsnNode)insn).isEmpty()) {
            this.processLocalVariablesAtExit((AbstractInsnNode)insn, builder);
        } else {
            this.processLocalVariablesAtControlEdge((AbstractInsnNode)insn, builder);
        }
        builder.addThrow(register);
    }

    private void addReturn(InsnNode insn, MoveType type, int register, IRBuilder builder) {
        this.processLocalVariablesAtExit((AbstractInsnNode)insn, builder);
        if (type == null) {
            assert (register == -1);
            builder.addReturn();
        } else {
            builder.addReturn(type, register);
        }
    }

    private void dupOneBelowTwo(JarState.Slot value3, JarState.Slot value2, JarState.Slot value1, IRBuilder builder) {
        int stack3 = this.state.push(value1.type);
        int stack2 = this.state.push(value3.type);
        int stack1 = this.state.push(value2.type);
        int stack0 = this.state.push(value1.type);
        assert (value3.register == stack3);
        assert (value2.register == stack2);
        assert (value1.register == stack1);
        builder.addMove(JarSourceCode.moveType(value1.type), stack0, stack1);
        builder.addMove(JarSourceCode.moveType(value2.type), stack1, stack2);
        builder.addMove(JarSourceCode.moveType(value3.type), stack2, stack3);
        builder.addMove(JarSourceCode.moveType(value1.type), stack3, stack0);
    }

    private void dupOneBelowOne(JarState.Slot value2, JarState.Slot value1, IRBuilder builder) {
        int stack2 = this.state.push(value1.type);
        int stack1 = this.state.push(value2.type);
        int stack0 = this.state.push(value1.type);
        assert (value2.register == stack2);
        assert (value1.register == stack1);
        builder.addMove(JarSourceCode.moveType(value1.type), stack0, stack1);
        builder.addMove(JarSourceCode.moveType(value2.type), stack1, stack2);
        builder.addMove(JarSourceCode.moveType(value1.type), stack2, stack0);
    }

    private void dupTwoBelowOne(JarState.Slot value3, JarState.Slot value2, JarState.Slot value1, IRBuilder builder) {
        int stack4 = this.state.push(value2.type);
        int stack3 = this.state.push(value1.type);
        int stack2 = this.state.push(value3.type);
        int stack1 = this.state.push(value2.type);
        int stack0 = this.state.push(value1.type);
        assert (value3.register == stack4);
        assert (value2.register == stack3);
        assert (value1.register == stack2);
        builder.addMove(JarSourceCode.moveType(value1.type), stack0, stack2);
        builder.addMove(JarSourceCode.moveType(value2.type), stack1, stack3);
        builder.addMove(JarSourceCode.moveType(value3.type), stack2, stack4);
        builder.addMove(JarSourceCode.moveType(value1.type), stack3, stack0);
        builder.addMove(JarSourceCode.moveType(value2.type), stack4, stack1);
    }

    private void dupTwoBelowTwo(JarState.Slot value4, JarState.Slot value3, JarState.Slot value2, JarState.Slot value1, IRBuilder builder) {
        int stack5 = this.state.push(value2.type);
        int stack4 = this.state.push(value1.type);
        int stack3 = this.state.push(value4.type);
        int stack2 = this.state.push(value3.type);
        int stack1 = this.state.push(value2.type);
        int stack0 = this.state.push(value1.type);
        assert (value4.register == stack5);
        assert (value3.register == stack4);
        assert (value2.register == stack3);
        assert (value1.register == stack2);
        builder.addMove(JarSourceCode.moveType(value1.type), stack0, stack2);
        builder.addMove(JarSourceCode.moveType(value2.type), stack1, stack3);
        builder.addMove(JarSourceCode.moveType(value3.type), stack2, stack4);
        builder.addMove(JarSourceCode.moveType(value3.type), stack3, stack5);
        builder.addMove(JarSourceCode.moveType(value1.type), stack4, stack0);
        builder.addMove(JarSourceCode.moveType(value2.type), stack5, stack1);
    }

    private void buildConversion(Type from, Type to, IRBuilder builder) {
        int source = this.state.pop((Type)from).register;
        int dest = this.state.push(to);
        builder.addConversion(JarSourceCode.numericType(to), JarSourceCode.numericType(from), dest, source);
    }

    private void build(IntInsnNode insn, IRBuilder builder) {
        switch (insn.getOpcode()) {
            case 16: 
            case 17: {
                int dest = this.state.push(Type.INT_TYPE);
                builder.addIntConst(dest, insn.operand);
                break;
            }
            case 188: {
                String desc = JarSourceCode.arrayTypeDesc(insn.operand);
                Type type = Type.getType((String)desc);
                DexType dexType = this.application.getTypeFromDescriptor(desc);
                int count = this.state.pop((Type)Type.INT_TYPE).register;
                int array = this.state.push(type);
                builder.addNewArrayEmpty(array, count, dexType);
                break;
            }
            default: {
                throw new Unreachable("Unexpected IntInsn opcode: " + insn.getOpcode());
            }
        }
    }

    private void build(VarInsnNode insn, IRBuilder builder) {
        Type expectedType;
        int opcode = insn.getOpcode();
        switch (opcode) {
            case 21: 
            case 54: {
                expectedType = Type.INT_TYPE;
                break;
            }
            case 23: 
            case 56: {
                expectedType = Type.FLOAT_TYPE;
                break;
            }
            case 22: 
            case 55: {
                expectedType = Type.LONG_TYPE;
                break;
            }
            case 24: 
            case 57: {
                expectedType = Type.DOUBLE_TYPE;
                break;
            }
            case 25: 
            case 58: {
                expectedType = JarState.REFERENCE_TYPE;
                break;
            }
            case 169: {
                throw new Unreachable("RET should be handled by the ASM jsr inliner");
            }
            default: {
                throw new Unreachable("Unexpected VarInsn opcode: " + insn.getOpcode());
            }
        }
        if (21 <= opcode && opcode <= 25) {
            JarState.Slot src = this.state.readLocal(insn.var, expectedType);
            int dest = this.state.push(src.type);
            builder.addMove(JarSourceCode.moveType(src.type), dest, src.register);
        } else {
            assert (54 <= opcode && opcode <= 58);
            JarState.Slot src = this.state.pop(expectedType);
            int dest = this.state.writeLocal(insn.var, src.type);
            builder.addMove(JarSourceCode.moveType(src.type), dest, src.register);
        }
    }

    private void build(TypeInsnNode insn, IRBuilder builder) {
        Type type = Type.getObjectType((String)insn.desc);
        switch (insn.getOpcode()) {
            case 187: {
                DexType dexType = this.application.getTypeFromName(insn.desc);
                int dest = this.state.push(type);
                builder.addNewInstance(dest, dexType);
                break;
            }
            case 189: {
                Type arrayType = JarSourceCode.makeArrayType(type);
                DexType dexArrayType = this.application.getTypeFromDescriptor(arrayType.getDescriptor());
                int count = this.state.pop((Type)Type.INT_TYPE).register;
                int dest = this.state.push(arrayType);
                builder.addNewArrayEmpty(dest, count, dexArrayType);
                break;
            }
            case 192: {
                DexType dexType = this.application.getTypeFromDescriptor(type.getDescriptor());
                this.state.pop(type);
                int object = this.state.push(type);
                builder.addCheckCast(object, dexType);
                break;
            }
            case 193: {
                int obj = this.state.pop((Type)JarState.REFERENCE_TYPE).register;
                int dest = this.state.push(Type.INT_TYPE);
                DexType dexType = this.application.getTypeFromDescriptor(type.getDescriptor());
                builder.addInstanceOf(dest, obj, dexType);
                break;
            }
            default: {
                throw new Unreachable("Unexpected TypeInsn opcode: " + insn.getOpcode());
            }
        }
    }

    private void build(FieldInsnNode insn, IRBuilder builder) {
        DexField field = this.application.getField(insn.owner, insn.name, insn.desc);
        Type type = Type.getType((String)insn.desc);
        MemberType fieldType = JarSourceCode.memberType(insn.desc);
        switch (insn.getOpcode()) {
            case 178: {
                builder.addStaticGet(fieldType, this.state.push(type), field);
                break;
            }
            case 179: {
                builder.addStaticPut(fieldType, this.state.pop((Type)type).register, field);
                break;
            }
            case 180: {
                JarState.Slot object = this.state.pop(JarState.OBJECT_TYPE);
                int dest = this.state.push(type);
                builder.addInstanceGet(fieldType, dest, object.register, field);
                break;
            }
            case 181: {
                JarState.Slot value = this.state.pop(type);
                JarState.Slot object = this.state.pop(JarState.OBJECT_TYPE);
                builder.addInstancePut(fieldType, value.register, object.register, field);
                break;
            }
            default: {
                throw new Unreachable("Unexpected FieldInsn opcode: " + insn.getOpcode());
            }
        }
    }

    private void build(MethodInsnNode insn, IRBuilder builder) {
        DexMethod method = this.application.getMethod(insn.owner, insn.name, insn.desc);
        this.buildInvoke(insn.desc, Type.getObjectType((String)insn.owner), insn.getOpcode() != 184, builder, (types, registers) -> {
            Invoke.Type invokeType = this.invokeType(insn);
            DexProto callSiteProto = null;
            DexMethod targetMethod = method;
            if (invokeType == Invoke.Type.POLYMORPHIC) {
                targetMethod = this.application.getMethod(insn.owner, insn.name, METHODHANDLE_INVOKE_OR_INVOKEEXACT_DESC);
                callSiteProto = this.application.getProto(insn.desc);
            }
            builder.addInvoke(invokeType, targetMethod, callSiteProto, (List<MoveType>)types, (List<Integer>)registers);
        });
    }

    private void buildInvoke(String methodDesc, Type methodOwner, boolean addImplicitReceiver, IRBuilder builder, BiConsumer<List<MoveType>, List<Integer>> creator) {
        Type[] parameterTypes = Type.getArgumentTypes((String)methodDesc);
        JarState.Slot[] parameterRegisters = this.state.popReverse(parameterTypes.length);
        ArrayList<MoveType> types = new ArrayList<MoveType>(parameterTypes.length + 1);
        ArrayList<Integer> registers = new ArrayList<Integer>(parameterTypes.length + 1);
        if (addImplicitReceiver) {
            JarSourceCode.addArgument(types, registers, methodOwner, this.state.pop());
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            JarSourceCode.addArgument(types, registers, parameterTypes[i], parameterRegisters[i]);
        }
        creator.accept(types, registers);
        Type returnType = Type.getReturnType((String)methodDesc);
        if (returnType != Type.VOID_TYPE) {
            builder.addMoveResult(JarSourceCode.moveType(returnType), this.state.push(returnType));
        }
    }

    private static void addArgument(List<MoveType> types, List<Integer> registers, Type type, JarState.Slot slot) {
        assert (slot.isCompatibleWith(type));
        types.add(JarSourceCode.moveType(type));
        registers.add(slot.register);
    }

    private void build(InvokeDynamicInsnNode insn, IRBuilder builder) {
        Handle bsmHandle = insn.bsm;
        if (bsmHandle.getTag() != 6 && bsmHandle.getTag() != 8) {
            throw new Unreachable("Bootstrap handle is not yet supported: tag == " + bsmHandle.getTag());
        }
        DexMethodHandle bootstrapMethod = this.getMethodHandle(this.application, bsmHandle);
        ArrayList<DexValue> bootstrapArgs = new ArrayList<DexValue>();
        for (Object arg : insn.bsmArgs) {
            bootstrapArgs.add(this.decodeBootstrapArgument(arg));
        }
        DexCallSite callSite = this.application.getCallSite(insn.name, insn.desc, bootstrapMethod, bootstrapArgs);
        this.buildInvoke(insn.desc, null, false, builder, (types, registers) -> builder.addInvokeCustom(callSite, (List<MoveType>)types, (List<Integer>)registers));
    }

    private DexValue decodeBootstrapArgument(Object value) {
        if (value instanceof Integer) {
            return DexValue.DexValueInt.create((Integer)value);
        }
        if (value instanceof Long) {
            return DexValue.DexValueLong.create((Long)value);
        }
        if (value instanceof Float) {
            return DexValue.DexValueFloat.create(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return DexValue.DexValueDouble.create((Double)value);
        }
        if (value instanceof String) {
            return new DexValue.DexValueString(this.application.getString((String)value));
        }
        if (value instanceof Type) {
            Type type = (Type)value;
            switch (type.getSort()) {
                case 10: {
                    return new DexValue.DexValueType(this.application.getTypeFromDescriptor(((Type)value).getDescriptor()));
                }
                case 11: {
                    return new DexValue.DexValueMethodType(this.application.getProto(((Type)value).getDescriptor()));
                }
            }
            throw new Unreachable("Type sort is not supported: " + type.getSort());
        }
        if (value instanceof Handle) {
            return new DexValue.DexValueMethodHandle(this.getMethodHandle(this.application, (Handle)value));
        }
        throw new Unreachable("Unsupported bootstrap static argument of type " + value.getClass().getSimpleName());
    }

    private DexMethodHandle getMethodHandle(JarApplicationReader application, Handle handle) {
        DexMethodHandle.MethodHandleType methodHandleType = this.getMethodHandleType(handle);
        Descriptor descriptor = methodHandleType.isFieldType() ? application.getField(handle.getOwner(), handle.getName(), handle.getDesc()) : application.getMethod(handle.getOwner(), handle.getName(), handle.getDesc());
        return application.getMethodHandle(methodHandleType, descriptor);
    }

    private DexMethodHandle.MethodHandleType getMethodHandleType(Handle handle) {
        switch (handle.getTag()) {
            case 1: {
                return DexMethodHandle.MethodHandleType.INSTANCE_GET;
            }
            case 2: {
                return DexMethodHandle.MethodHandleType.STATIC_GET;
            }
            case 3: {
                return DexMethodHandle.MethodHandleType.INSTANCE_PUT;
            }
            case 4: {
                return DexMethodHandle.MethodHandleType.STATIC_PUT;
            }
            case 7: {
                DexType owner = this.application.getTypeFromName(handle.getOwner());
                if (owner == this.clazz || handle.getName().equals("<init>")) {
                    return DexMethodHandle.MethodHandleType.INVOKE_INSTANCE;
                }
                return DexMethodHandle.MethodHandleType.INVOKE_SUPER;
            }
            case 5: {
                return DexMethodHandle.MethodHandleType.INVOKE_INSTANCE;
            }
            case 9: {
                return DexMethodHandle.MethodHandleType.INVOKE_INTERFACE;
            }
            case 6: {
                return DexMethodHandle.MethodHandleType.INVOKE_STATIC;
            }
            case 8: {
                return DexMethodHandle.MethodHandleType.INVOKE_CONSTRUCTOR;
            }
        }
        throw new Unreachable("MethodHandle tag is not supported: " + handle.getTag());
    }

    private void build(JumpInsnNode insn, IRBuilder builder) {
        this.processLocalVariablesAtControlEdge((AbstractInsnNode)insn, builder);
        int[] targets = this.getTargets((AbstractInsnNode)insn);
        int opcode = insn.getOpcode();
        if (153 <= opcode && opcode <= 166) {
            assert (targets.length == 2);
            if (opcode <= 158) {
                JarState.Slot value = this.state.pop(Type.INT_TYPE);
                builder.addIfZero(JarSourceCode.ifType(opcode), value.register, targets[0], targets[1]);
            } else {
                Type expectedType = opcode < 165 ? Type.INT_TYPE : JarState.REFERENCE_TYPE;
                JarState.Slot value2 = this.state.pop(expectedType);
                JarState.Slot value1 = this.state.pop(expectedType);
                builder.addIf(JarSourceCode.ifType(opcode), value1.register, value2.register, targets[0], targets[1]);
            }
        } else {
            switch (opcode) {
                case 167: {
                    assert (targets.length == 1);
                    builder.addGoto(targets[0]);
                    break;
                }
                case 198: 
                case 199: {
                    JarState.Slot value = this.state.pop(JarState.REFERENCE_TYPE);
                    If.Type type = opcode == 198 ? If.Type.EQ : If.Type.NE;
                    builder.addIfZero(type, value.register, targets[0], targets[1]);
                    break;
                }
                case 168: {
                    throw new Unreachable("JSR should be handled by the ASM jsr inliner");
                }
                default: {
                    throw new Unreachable("Unexpected JumpInsn opcode: " + insn.getOpcode());
                }
            }
        }
    }

    private void build(LabelNode insn, IRBuilder builder) {
        if (insn != this.initialLabel) {
            for (JarState.Local local : this.state.openLocals(insn)) {
                builder.addDebugLocalStart(local.slot.register, local.info);
            }
        }
    }

    private void build(LdcInsnNode insn, IRBuilder builder) {
        if (insn.cst instanceof Type) {
            Type type = (Type)insn.cst;
            int dest = this.state.push(type);
            builder.addConstClass(dest, this.application.getTypeFromDescriptor(type.getDescriptor()));
        } else if (insn.cst instanceof String) {
            int dest = this.state.push(STRING_TYPE);
            builder.addConstString(dest, this.application.getString((String)insn.cst));
        } else if (insn.cst instanceof Long) {
            int dest = this.state.push(Type.LONG_TYPE);
            builder.addLongConst(dest, (Long)insn.cst);
        } else if (insn.cst instanceof Double) {
            int dest = this.state.push(Type.DOUBLE_TYPE);
            builder.addDoubleConst(dest, Double.doubleToRawLongBits((Double)insn.cst));
        } else if (insn.cst instanceof Integer) {
            int dest = this.state.push(Type.INT_TYPE);
            builder.addIntConst(dest, ((Integer)insn.cst).intValue());
        } else {
            assert (insn.cst instanceof Float);
            int dest = this.state.push(Type.FLOAT_TYPE);
            builder.addFloatConst(dest, Float.floatToRawIntBits(((Float)insn.cst).floatValue()));
        }
    }

    private void build(IincInsnNode insn, IRBuilder builder) {
        int local = this.state.readLocal((int)insn.var, (Type)Type.INT_TYPE).register;
        builder.addAddLiteral(NumericType.INT, local, local, insn.incr);
    }

    private void build(TableSwitchInsnNode insn, IRBuilder builder) {
        this.processLocalVariablesAtControlEdge((AbstractInsnNode)insn, builder);
        this.buildSwitch(insn.dflt, insn.labels, new int[]{insn.min}, builder);
    }

    private void build(LookupSwitchInsnNode insn, IRBuilder builder) {
        this.processLocalVariablesAtControlEdge((AbstractInsnNode)insn, builder);
        int[] keys = new int[insn.keys.size()];
        for (int i = 0; i < insn.keys.size(); ++i) {
            keys[i] = (Integer)insn.keys.get(i);
        }
        this.buildSwitch(insn.dflt, insn.labels, keys, builder);
    }

    private void buildSwitch(LabelNode dflt, List labels, int[] keys, IRBuilder builder) {
        int index = this.state.pop((Type)Type.INT_TYPE).register;
        int fallthroughOffset = this.getOffset((AbstractInsnNode)dflt);
        int[] labelOffsets = new int[labels.size()];
        for (int i = 0; i < labels.size(); ++i) {
            int offset;
            labelOffsets[i] = offset = this.getOffset((AbstractInsnNode)((LabelNode)labels.get(i)));
        }
        builder.addSwitch(index, keys, fallthroughOffset, labelOffsets);
    }

    private void build(MultiANewArrayInsnNode insn, IRBuilder builder) {
        Type arrayType = Type.getObjectType((String)insn.desc);
        DexType dexArrayType = this.application.getType(arrayType);
        DexType memberType = this.application.getTypeFromDescriptor(insn.desc.substring(insn.dims));
        DexType dimArrayType = this.application.getTypeFromDescriptor(INT_ARRAY_DESC);
        JarState.Slot[] slots = this.state.popReverse(insn.dims, Type.INT_TYPE);
        int[] dimensions = new int[insn.dims];
        for (int i = 0; i < insn.dims; ++i) {
            dimensions[i] = slots[i].register;
        }
        builder.addInvokeNewArray(dimArrayType, insn.dims, dimensions);
        int dimensionsDestTemp = this.state.push(INT_ARRAY_TYPE);
        builder.addMoveResult(MoveType.OBJECT, dimensionsDestTemp);
        int classDestTemp = this.state.push(CLASS_TYPE);
        builder.ensureBlockForThrowingInstruction();
        builder.addConstClass(classDestTemp, memberType);
        DexType reflectArrayClass = this.application.getTypeFromDescriptor(REFLECT_ARRAY_DESC);
        DexMethod newInstance = this.application.getMethod(reflectArrayClass, REFLECT_ARRAY_NEW_INSTANCE_NAME, REFLECT_ARRAY_NEW_INSTANCE_DESC);
        List<MoveType> argumentTypes = Arrays.asList(JarSourceCode.moveType(CLASS_TYPE), JarSourceCode.moveType(INT_ARRAY_TYPE));
        List<Integer> argumentRegisters = Arrays.asList(classDestTemp, dimensionsDestTemp);
        builder.ensureBlockForThrowingInstruction();
        builder.addInvoke(Invoke.Type.STATIC, newInstance, null, argumentTypes, argumentRegisters);
        this.state.pop();
        this.state.pop();
        int result = this.state.push(arrayType);
        builder.addMoveResult(JarSourceCode.moveType(arrayType), result);
        builder.ensureBlockForThrowingInstruction();
        builder.addCheckCast(result, dexArrayType);
    }

    private void build(LineNumberNode insn, IRBuilder builder) {
        builder.updateCurrentDebugPosition(insn.line, null);
    }

    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append("node.name = [").append(this.node.name).append("]");
        builder.append("\n");
        builder.append("node.desc = ").append(this.node.desc);
        builder.append("\n");
        builder.append("node.maxStack = ").append(this.node.maxStack);
        builder.append("\n");
        builder.append("node.maxLocals = ").append(this.node.maxLocals);
        builder.append("\n");
        builder.append("node.locals.size = ").append(this.node.localVariables.size());
        builder.append("\n");
        builder.append("node.insns.size = ").append(this.node.instructions.size());
        builder.append("\n");
        for (i = 0; i < this.parameterTypes.size(); ++i) {
            builder.append("arg ").append(i).append(", type: ").append(this.parameterTypes.get(i)).append("\n");
        }
        for (i = 0; i < this.node.localVariables.size(); ++i) {
            LocalVariableNode local = (LocalVariableNode)this.node.localVariables.get(i);
            builder.append("local ").append(i).append(", name: ").append(local.name).append(", desc: ").append(local.desc).append(", index: ").append(local.index).append(", [").append(this.getOffset((AbstractInsnNode)local.start)).append("..").append(this.getOffset((AbstractInsnNode)local.end)).append("[\n");
        }
        for (i = 0; i < this.node.tryCatchBlocks.size(); ++i) {
            TryCatchBlockNode tryCatchBlockNode = (TryCatchBlockNode)this.node.tryCatchBlocks.get(i);
            builder.append("[").append(this.getOffset((AbstractInsnNode)tryCatchBlockNode.start)).append("..").append(this.getOffset((AbstractInsnNode)tryCatchBlockNode.end)).append("[ ").append(tryCatchBlockNode.type).append(" -> ").append(this.getOffset((AbstractInsnNode)tryCatchBlockNode.handler)).append("\n");
        }
        for (i = 0; i < this.node.instructions.size(); ++i) {
            AbstractInsnNode insn = this.node.instructions.get(i);
            builder.append(String.format("%4d: ", i)).append(this.instructionToString(insn));
        }
        return builder.toString();
    }

    private String instructionToString(AbstractInsnNode insn) {
        if (this.printVisitor == null) {
            this.printVisitor = new TraceMethodVisitor((Printer)new Textifier());
        }
        insn.accept((MethodVisitor)this.printVisitor);
        StringWriter writer = new StringWriter();
        this.printVisitor.p.print(new PrintWriter(writer));
        this.printVisitor.p.getText().clear();
        return writer.toString();
    }

    private boolean isCallToPolymorphicSignatureMethod(MethodInsnNode method) {
        return method.owner.equals("java/lang/invoke/MethodHandle") && (method.name.equals("invoke") || method.name.equals("invokeExact"));
    }

    private static class JarStateWorklistItem {
        IRBuilder.BlockInfo blockInfo;
        int instructionIndex;

        public JarStateWorklistItem(IRBuilder.BlockInfo blockInfo, int instructionIndex) {
            this.blockInfo = blockInfo;
            this.instructionIndex = instructionIndex;
        }
    }

    private static class TryCatchBlock {
        private final int handler;
        private final int start;
        private final int end;
        private final String type;

        public TryCatchBlock(TryCatchBlockNode node, JarSourceCode code) {
            this(code.getOffset((AbstractInsnNode)node.handler), code.getOffset((AbstractInsnNode)node.start), code.getOffset((AbstractInsnNode)node.end), node.type);
        }

        private TryCatchBlock(int handler, int start, int end, String type) {
            assert (start < end);
            this.handler = handler;
            this.start = start;
            this.end = end;
            this.type = type;
        }

        int getStart() {
            return this.start;
        }

        int getEnd() {
            return this.end;
        }

        int getHandler() {
            return this.handler;
        }

        String getType() {
            return this.type;
        }
    }
}

