/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.regalloc;

import com.android.tools.r8.ir.code.MoveType;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.regalloc.LinearScanRegisterAllocator;
import com.android.tools.r8.ir.regalloc.LiveIntervalsUse;
import com.android.tools.r8.ir.regalloc.LiveRange;
import com.android.tools.r8.utils.CfgPrinter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class LiveIntervals {
    private final Value value;
    private LiveIntervals nextConsecutive;
    private LiveIntervals previousConsecutive;
    private LiveIntervals splitParent;
    private List<LiveIntervals> splitChildren = new ArrayList<LiveIntervals>();
    private List<LiveRange> ranges = new ArrayList<LiveRange>();
    private TreeSet<LiveIntervalsUse> uses = new TreeSet();
    private int numberOfConsecutiveRegisters = -1;
    private int register = Integer.MIN_VALUE;
    private LiveIntervals hint;
    private boolean spilled = false;
    private int registerLimit = 65535;
    private int maxNonSpilledRegister = Integer.MIN_VALUE;

    LiveIntervals(Value value) {
        this.value = value;
        this.splitParent = this;
        value.setLiveIntervals(this);
    }

    LiveIntervals(LiveIntervals splitParent) {
        this.splitParent = splitParent;
        this.value = splitParent.value;
    }

    private int toInstructionPosition(int position) {
        return position % 2 == 0 ? position : position + 1;
    }

    private int toGapPosition(int position) {
        return position % 2 == 1 ? position : position - 1;
    }

    public MoveType getType() {
        return this.value.outType();
    }

    public Value getValue() {
        return this.value;
    }

    public int requiredRegisters() {
        return this.getType() == MoveType.WIDE ? 2 : 1;
    }

    public void setHint(LiveIntervals intervals) {
        this.hint = intervals;
    }

    public LiveIntervals getHint() {
        return this.hint;
    }

    public void setSpilled(boolean value) {
        this.spilled = value;
    }

    public boolean isSpilled() {
        return this.spilled;
    }

    public boolean isRematerializable(LinearScanRegisterAllocator registerAllocator) {
        if (!this.value.isConstant()) {
            return false;
        }
        int max = registerAllocator.unadjustedRealRegisterFromAllocated(this.getMaxNonSpilledRegister());
        return max < 255;
    }

    public boolean isSpilledAndRematerializable(LinearScanRegisterAllocator allocator) {
        return this.isSpilled() && this.isRematerializable(allocator);
    }

    public void link(LiveIntervals next) {
        assert (this.numberOfConsecutiveRegisters == -1);
        this.nextConsecutive = next;
        next.previousConsecutive = this;
    }

    public boolean isLinked() {
        return this.splitParent.previousConsecutive != null || this.splitParent.nextConsecutive != null;
    }

    public boolean isArgumentInterval() {
        LiveIntervals current = this.splitParent;
        while (current.previousConsecutive != null) {
            current = current.previousConsecutive;
        }
        return current.ranges.get(0).isInfinite();
    }

    public LiveIntervals getStartOfConsecutive() {
        LiveIntervals current = this;
        while (current.previousConsecutive != null) {
            current = current.previousConsecutive;
        }
        return current;
    }

    public LiveIntervals getNextConsecutive() {
        return this.nextConsecutive;
    }

    public LiveIntervals getPreviousConsecutive() {
        return this.previousConsecutive;
    }

    public int numberOfConsecutiveRegisters() {
        LiveIntervals start = this.getStartOfConsecutive();
        if (start.numberOfConsecutiveRegisters != -1) {
            assert (start.numberOfConsecutiveRegisters == this.computeNumberOfConsecutiveRegisters());
            return start.numberOfConsecutiveRegisters;
        }
        return this.computeNumberOfConsecutiveRegisters();
    }

    private int computeNumberOfConsecutiveRegisters() {
        LiveIntervals start = this.getStartOfConsecutive();
        int result = 0;
        LiveIntervals current = start;
        while (current != null) {
            result += current.requiredRegisters();
            current = current.nextConsecutive;
        }
        start.numberOfConsecutiveRegisters = result;
        return result;
    }

    public boolean hasSplits() {
        return this.splitChildren.size() != 0;
    }

    public List<LiveIntervals> getSplitChildren() {
        return this.splitChildren;
    }

    public LiveIntervals getSplitParent() {
        return this.splitParent;
    }

    public void addRange(LiveRange range) {
        boolean added = this.tryAddRange(range);
        assert (added);
    }

    private boolean tryAddRange(LiveRange range) {
        if (this.ranges.size() > 0) {
            LiveRange lastRange = this.ranges.get(this.ranges.size() - 1);
            if (lastRange.isInfinite()) {
                return false;
            }
            int rangeStartInstructionPosition = this.toInstructionPosition(range.start);
            int lastRangeEndInstructionPosition = this.toInstructionPosition(lastRange.end);
            if (lastRangeEndInstructionPosition > rangeStartInstructionPosition) {
                return false;
            }
            if (lastRangeEndInstructionPosition == rangeStartInstructionPosition) {
                lastRange.end = range.end;
                return true;
            }
        }
        this.ranges.add(range);
        return true;
    }

    public void addUse(LiveIntervalsUse use) {
        this.uses.add(use);
        this.updateRegisterConstraint(use.getLimit());
    }

    public void updateRegisterConstraint(int constraint) {
        this.registerLimit = Math.min(this.registerLimit, constraint);
    }

    public TreeSet<LiveIntervalsUse> getUses() {
        return this.uses;
    }

    public List<LiveRange> getRanges() {
        return this.ranges;
    }

    public int getStart() {
        assert (!this.ranges.isEmpty());
        return this.ranges.get((int)0).start;
    }

    public int getEnd() {
        assert (!this.ranges.isEmpty());
        return this.ranges.get((int)(this.ranges.size() - 1)).end;
    }

    public int getRegister() {
        return this.register;
    }

    public int getRegisterLimit() {
        return this.registerLimit;
    }

    public void setRegister(int n) {
        assert (this.register == Integer.MIN_VALUE || this.register == n);
        this.register = n;
    }

    private int computeMaxNonSpilledRegister() {
        assert (this.splitParent == this);
        assert (this.maxNonSpilledRegister == Integer.MIN_VALUE);
        if (!this.isSpilled()) {
            this.maxNonSpilledRegister = this.getRegister();
        }
        for (LiveIntervals child : this.splitChildren) {
            if (child.isSpilled()) continue;
            this.maxNonSpilledRegister = Math.max(this.maxNonSpilledRegister, child.getRegister());
        }
        return this.maxNonSpilledRegister;
    }

    public void setMaxNonSpilledRegister(int i) {
        assert (i >= this.splitParent.maxNonSpilledRegister);
        this.splitParent.maxNonSpilledRegister = i;
    }

    public int getMaxNonSpilledRegister() {
        if (this.splitParent.maxNonSpilledRegister != Integer.MIN_VALUE) {
            return this.splitParent.maxNonSpilledRegister;
        }
        return this.splitParent.computeMaxNonSpilledRegister();
    }

    public boolean usesRegister(int n) {
        return this.register == n || this.getType() == MoveType.WIDE && this.register + 1 == n;
    }

    public void clearRegisterAssignment() {
        this.register = Integer.MIN_VALUE;
        this.hint = null;
    }

    public boolean overlapsPosition(int position) {
        for (LiveRange range : this.ranges) {
            if (range.start > position) {
                return false;
            }
            if (position >= range.end) continue;
            return true;
        }
        return false;
    }

    public boolean overlaps(LiveIntervals other) {
        return this.nextOverlap(other) != -1;
    }

    public int nextOverlap(LiveIntervals other) {
        Iterator<LiveRange> it = other.ranges.iterator();
        LiveRange otherRange = it.next();
        for (LiveRange range : this.ranges) {
            while (otherRange.end <= range.start) {
                if (!it.hasNext()) {
                    return -1;
                }
                otherRange = it.next();
            }
            if (otherRange.start >= range.end) continue;
            return otherRange.start;
        }
        return -1;
    }

    public int firstUseAfter(int unhandledStart) {
        for (LiveIntervalsUse use : this.uses) {
            if (use.getPosition() < unhandledStart) continue;
            return use.getPosition();
        }
        return Integer.MAX_VALUE;
    }

    public int getFirstUse() {
        return this.uses.first().getPosition();
    }

    public LiveIntervalsUse firstUseWithConstraint() {
        for (LiveIntervalsUse use : this.uses) {
            if (!use.hasConstraint()) continue;
            return use;
        }
        return null;
    }

    public LiveIntervals splitBefore(int start) {
        if (this.toInstructionPosition(start) == this.toInstructionPosition(this.getStart())) {
            assert (this.uses.size() == 0 || this.getFirstUse() != start);
            this.register = Integer.MIN_VALUE;
            return this;
        }
        start = this.toGapPosition(start);
        LiveIntervals splitChild = new LiveIntervals(this.splitParent);
        this.splitParent.splitChildren.add(splitChild);
        List<Object> beforeSplit = new ArrayList();
        ArrayList<LiveRange> afterSplit = new ArrayList<LiveRange>();
        if (start == this.getEnd()) {
            beforeSplit = this.ranges;
            afterSplit.add(new LiveRange(start, start));
        } else {
            int rangeToSplitIndex;
            for (rangeToSplitIndex = 0; rangeToSplitIndex < this.ranges.size(); ++rangeToSplitIndex) {
                LiveRange range = this.ranges.get(rangeToSplitIndex);
                if (range.start <= start && range.end > start || range.start > start) break;
            }
            LiveRange rangeToSplit = this.ranges.get(rangeToSplitIndex);
            beforeSplit.addAll(this.ranges.subList(0, rangeToSplitIndex));
            if (rangeToSplit.start < start) {
                beforeSplit.add(new LiveRange(rangeToSplit.start, start));
                afterSplit.add(new LiveRange(start, rangeToSplit.end));
            } else {
                afterSplit.add(rangeToSplit);
            }
            afterSplit.addAll(this.ranges.subList(rangeToSplitIndex + 1, this.ranges.size()));
        }
        splitChild.ranges = afterSplit;
        this.ranges = beforeSplit;
        while (!this.uses.isEmpty() && this.uses.last().getPosition() >= start) {
            splitChild.addUse(this.uses.pollLast());
        }
        this.recomputeLimit();
        assert (!this.ranges.isEmpty());
        assert (!splitChild.ranges.isEmpty());
        return splitChild;
    }

    private void recomputeLimit() {
        this.registerLimit = 65535;
        for (LiveIntervalsUse use : this.uses) {
            this.updateRegisterConstraint(use.getLimit());
        }
    }

    public LiveIntervals getSplitCovering(int instructionNumber) {
        assert (this.getSplitParent() == this);
        if (this.getStart() <= instructionNumber && this.getEnd() > instructionNumber) {
            return this;
        }
        LiveIntervals matchingEnd = this.getEnd() == instructionNumber ? this : null;
        for (LiveIntervals splitChild : this.splitChildren) {
            if (splitChild.getStart() <= instructionNumber && splitChild.getEnd() > instructionNumber) {
                return splitChild;
            }
            if (splitChild.getEnd() != instructionNumber) continue;
            matchingEnd = splitChild;
        }
        if (matchingEnd != null) {
            return matchingEnd;
        }
        assert (false) : "Couldn't find split covering instruction position.";
        return null;
    }

    public boolean isConstantNumberInterval() {
        return this.value.definition != null && this.value.isConstant();
    }

    public int numberOfUsesWithConstraint() {
        int count = 0;
        for (LiveIntervalsUse use : this.getUses()) {
            if (!use.hasConstraint()) continue;
            ++count;
        }
        return count;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(cons ");
        builder.append(this.numberOfConsecutiveRegisters);
        builder.append("): ");
        for (LiveRange range : this.getRanges()) {
            builder.append(range);
            builder.append(" ");
        }
        builder.append("\n");
        return builder.toString();
    }

    public String toAscciArtString() {
        StringBuilder builder = new StringBuilder();
        int current = 0;
        for (LiveRange range : this.getRanges()) {
            if (range.isInfinite()) {
                builder.append("--- infinite ---...");
                break;
            }
            while (current < range.start) {
                builder.append(" ");
                ++current;
            }
            while (current < range.end) {
                builder.append("-");
                ++current;
            }
        }
        return builder.toString();
    }

    public void print(CfgPrinter printer, int number, int parentNumber) {
        printer.append(number * 10000 + this.register).sp().append("object").sp().append(parentNumber * 10000 + this.getSplitParent().getRegister()).sp().append(-1);
        for (LiveRange range : this.getRanges()) {
            printer.sp().append(range.toString());
        }
        for (LiveIntervalsUse use : this.getUses()) {
            printer.sp().append(use.getPosition()).sp().append("M");
        }
        printer.append(" \"\"").ln();
        int delta = 0;
        for (LiveIntervals splitChild : this.splitChildren) {
            splitChild.print(printer, number + (delta += 10000), number);
        }
    }
}

