/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;

public class DictionaryReader
implements AutoCloseable {
    private BufferedReader reader;

    public DictionaryReader(Path path) throws IOException {
        this.reader = Files.newBufferedReader(path);
    }

    public String readName() throws IOException {
        int readCharAsInt;
        assert (this.reader != null);
        StringBuilder name = new StringBuilder();
        while ((readCharAsInt = this.reader.read()) != -1) {
            char readChar = (char)readCharAsInt;
            if (name.length() != 0 && Character.isJavaIdentifierPart(readChar) || name.length() == 0 && Character.isJavaIdentifierStart(readChar)) {
                name.append(readChar);
                continue;
            }
            if (readChar == '#') {
                this.reader.readLine();
            }
            if (name.length() == 0) continue;
            return name.toString();
        }
        return name.toString();
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public static List<String> readAllNames(Path path) {
        if (path != null) {
            ImmutableList.Builder namesBuilder = new ImmutableList.Builder();
            try (DictionaryReader reader = new DictionaryReader(path);){
                String name = reader.readName();
                while (!name.isEmpty()) {
                    namesBuilder.add((Object)name);
                    name = reader.readName();
                }
            }
            catch (IOException e) {
                System.err.println("Unable to create dictionary from file " + path.toString());
            }
            return namesBuilder.build();
        }
        return ImmutableList.of();
    }
}

