/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.ide.common.process.JavaProcessInfo;
import com.android.ide.common.process.ProcessEnvBuilder;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

public final class DesugarProcessBuilder
extends ProcessEnvBuilder<DesugarProcessBuilder> {
    public static final int MIN_SUPPORTED_API_TRY_WITH_RESOURCES = 19;
    private static final String DESUGAR_MAIN = "com.google.devtools.build.android.desugar.Desugar";
    private final Path java8LangSupportJar;
    private final boolean verbose;
    private final Map<Path, Path> inputsToOutputs;
    private final List<Path> classpath;
    private final List<Path> bootClasspath;
    private final int minSdkVersion;

    public DesugarProcessBuilder(Path java8LangSupportJar, boolean verbose, Map<Path, Path> inputsToOutputs, List<Path> classpath, List<Path> bootClasspath, int minSdkVersion) {
        this.java8LangSupportJar = java8LangSupportJar;
        this.verbose = verbose;
        this.inputsToOutputs = ImmutableMap.copyOf(inputsToOutputs);
        this.classpath = classpath;
        this.bootClasspath = bootClasspath;
        this.minSdkVersion = minSdkVersion;
    }

    public JavaProcessInfo build() throws ProcessException, IOException {
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.addEnvironments(this.mEnvironment);
        builder.setClasspath(this.java8LangSupportJar.toString());
        builder.setMain(DESUGAR_MAIN);
        builder.addJvmArg("-Xmx64M");
        if (this.verbose) {
            builder.addArgs("--verbose");
        }
        this.inputsToOutputs.forEach((in, out) -> {
            builder.addArgs("--input", in.toString());
            builder.addArgs("--output", out.toString());
        });
        this.classpath.forEach(c -> builder.addArgs("--classpath_entry", c.toString()));
        this.bootClasspath.forEach(b -> builder.addArgs("--bootclasspath_entry", b.toString()));
        builder.addArgs("--min_sdk_version", Integer.toString(this.minSdkVersion));
        builder.addArgs("--desugar_try_with_resources_if_needed");
        builder.addArgs("--desugar_try_with_resources_omit_runtime_classes");
        return builder.createJavaProcess();
    }
}

