/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.IOException;
import java.nio.file.Path;

public interface ClassFileEntry {
    public String name();

    public long getSize() throws IOException;

    public Path getRelativePath();

    public byte[] readAllBytes() throws IOException;

    public int readAllBytes(byte[] var1) throws IOException;

    public static Path withDexExtension(Path classFilePath) {
        String fileName = classFilePath.getFileName().toString();
        Preconditions.checkState((boolean)fileName.endsWith(".class"), (Object)"Dex archives: setting .DEX extension only for .CLASS files");
        return classFilePath.resolveSibling(Files.getNameWithoutExtension((String)fileName) + ".dex");
    }
}

