/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.ClassNameMinifier;
import com.android.tools.r8.naming.FieldNameMinifier;
import com.android.tools.r8.naming.MethodNameMinifier;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Timing;
import com.google.common.collect.Iterables;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;

public class Minifier {
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final RootSetBuilder.RootSet rootSet;
    private final InternalOptions options;

    public Minifier(Enqueuer.AppInfoWithLiveness appInfo, RootSetBuilder.RootSet rootSet, InternalOptions options) {
        this.appInfo = appInfo;
        this.rootSet = rootSet;
        this.options = options;
    }

    public NamingLens run(Timing timing) {
        assert (!this.options.skipMinification);
        if (!this.options.allowAccessModification) {
            throw new CompilationError("Minification requires allowaccessmodification.");
        }
        timing.begin("MinifyClasses");
        Map<DexType, DexString> classRenaming = new ClassNameMinifier(this.appInfo, this.rootSet, this.options.packagePrefix, this.options.classObfuscationDictionary, this.options.attributeRemoval.signature).computeRenaming();
        timing.end();
        timing.begin("MinifyMethods");
        Map<DexMethod, DexString> methodRenaming = new MethodNameMinifier(this.appInfo, this.rootSet, this.options.obfuscationDictionary).computeRenaming(timing);
        timing.end();
        timing.begin("MinifyFields");
        Map<DexField, DexString> fieldRenaming = new FieldNameMinifier(this.appInfo, this.rootSet, this.options.obfuscationDictionary).computeRenaming();
        timing.end();
        return new MinifiedRenaming(classRenaming, methodRenaming, fieldRenaming, this.appInfo);
    }

    private static class MinifiedRenaming
    extends NamingLens {
        private final AppInfo appInfo;
        private final Map<DexItem, DexString> renaming = new IdentityHashMap<DexItem, DexString>();

        private MinifiedRenaming(Map<DexType, DexString> classRenaming, Map<DexMethod, DexString> methodRenaming, Map<DexField, DexString> fieldRenaming, AppInfo appInfo) {
            this.appInfo = appInfo;
            this.renaming.putAll(classRenaming);
            this.renaming.putAll(methodRenaming);
            this.renaming.putAll(fieldRenaming);
        }

        @Override
        public DexString lookupDescriptor(DexType type) {
            return this.renaming.getOrDefault(type, type.descriptor);
        }

        @Override
        public DexString lookupName(DexMethod method) {
            return this.renaming.getOrDefault(method, method.name);
        }

        @Override
        public DexString lookupName(DexField field) {
            return this.renaming.getOrDefault(field, field.name);
        }

        @Override
        void forAllRenamedTypes(Consumer<DexType> consumer) {
            Iterables.filter(this.renaming.keySet(), DexType.class).forEach(consumer);
        }

        @Override
        public boolean checkTargetCanBeTranslated(DexMethod item) {
            if (item.holder.isArrayType()) {
                return true;
            }
            DexClass holder = this.appInfo.definitionFor(item.holder);
            if (holder == null || holder.isLibraryClass()) {
                return true;
            }
            DexEncodedMethod staticTarget = this.appInfo.lookupStaticTarget(item);
            DexEncodedMethod directTarget = this.appInfo.lookupDirectTarget(item);
            DexEncodedMethod virtualTarget = this.appInfo.lookupVirtualTarget(item.holder, item);
            DexClass staticTargetHolder = staticTarget != null ? this.appInfo.definitionFor(staticTarget.method.getHolder()) : null;
            DexClass directTargetHolder = directTarget != null ? this.appInfo.definitionFor(directTarget.method.getHolder()) : null;
            DexClass virtualTargetHolder = virtualTarget != null ? this.appInfo.definitionFor(virtualTarget.method.getHolder()) : null;
            return directTarget == null && staticTarget == null && virtualTarget == null || virtualTarget != null && virtualTarget.method == item || directTarget != null && directTarget.method == item || staticTarget != null && staticTarget.method == item || directTargetHolder != null && directTargetHolder.isLibraryClass() || virtualTargetHolder != null && virtualTargetHolder.isLibraryClass() || staticTargetHolder != null && staticTargetHolder.isLibraryClass();
        }
    }
}

