/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.IntIterator;

public class DebugLocalInfo {
    public final DexString name;
    public final DexType type;
    public final DexString signature;

    public DebugLocalInfo(DexString name, DexType type, DexString signature) {
        this.name = name;
        this.type = type;
        this.signature = signature;
    }

    public static boolean localsInfoMapsEqual(Int2ReferenceMap<DebugLocalInfo> set0, Int2ReferenceMap<DebugLocalInfo> set1) {
        if (set0 == null) {
            return set1 == null;
        }
        if (set1 == null) {
            return false;
        }
        if (set0.keySet().size() != set1.keySet().size()) {
            return false;
        }
        IntIterator intIterator = set0.keySet().iterator();
        while (intIterator.hasNext()) {
            int i = (Integer)intIterator.next();
            if (((DebugLocalInfo)set0.get(i)).equals(set1.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DebugLocalInfo)) {
            return false;
        }
        DebugLocalInfo o = (DebugLocalInfo)other;
        return this.name == o.name && this.type == o.type && this.signature == o.signature;
    }

    public int hashCode() {
        int hash = 7 * this.name.hashCode() + 13 * this.type.hashCode();
        if (this.signature != null) {
            hash += 31 * this.signature.hashCode();
        }
        return hash;
    }

    public String toString() {
        return this.name + ":" + this.type + (this.signature == null ? "" : this.signature);
    }
}

