/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.errors.InvalidDebugInfoException;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.JarApplicationReader;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.ValueNumberGenerator;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.JarSourceCode;
import com.android.tools.r8.jar.JarRegisterEffectsVisitor;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.InternalOptions;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.IdentityHashMap;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.JSRInlinerAdapter;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

public class JarCode
extends Code {
    private final DexType clazz;
    private MethodNode node;
    private ReparseContext context;
    private final JarApplicationReader application;

    public JarCode(DexMethod method, ReparseContext context, JarApplicationReader application) {
        this.clazz = method.getHolder();
        this.context = context;
        this.application = application;
        context.lookupMap.put(method, this);
    }

    @Override
    public boolean isJarCode() {
        return true;
    }

    @Override
    public JarCode asJarCode() {
        return this;
    }

    @Override
    protected int computeHashCode() {
        this.triggerDelayedParsingIfNeccessary();
        return this.node.hashCode();
    }

    @Override
    protected boolean computeEquals(Object other) {
        this.triggerDelayedParsingIfNeccessary();
        if (this == other) {
            return true;
        }
        if (other instanceof JarCode) {
            JarCode o = (JarCode)other;
            o.triggerDelayedParsingIfNeccessary();
            return this.node.equals(o.node);
        }
        return false;
    }

    @Override
    public IRCode buildIR(DexEncodedMethod encodedMethod, InternalOptions options) {
        this.triggerDelayedParsingIfNeccessary();
        return options.debug ? this.internalBuildWithLocals(encodedMethod, null, options) : this.internalBuild(encodedMethod, null, options);
    }

    public IRCode buildIR(DexEncodedMethod encodedMethod, ValueNumberGenerator generator, InternalOptions options) {
        assert (generator != null);
        this.triggerDelayedParsingIfNeccessary();
        return options.debug ? this.internalBuildWithLocals(encodedMethod, generator, options) : this.internalBuild(encodedMethod, generator, options);
    }

    private IRCode internalBuildWithLocals(DexEncodedMethod encodedMethod, ValueNumberGenerator generator, InternalOptions options) {
        try {
            return this.internalBuild(encodedMethod, generator, options);
        }
        catch (InvalidDebugInfoException e) {
            options.warningInvalidDebugInfo(encodedMethod, e);
            this.node.localVariables.clear();
            return this.internalBuild(encodedMethod, generator, options);
        }
    }

    private IRCode internalBuild(DexEncodedMethod encodedMethod, ValueNumberGenerator generator, InternalOptions options) {
        if (!options.debug) {
            this.node.localVariables.clear();
        }
        JarSourceCode source = new JarSourceCode(this.clazz, this.node, this.application);
        IRBuilder builder = generator == null ? new IRBuilder(encodedMethod, source, options) : new IRBuilder(encodedMethod, source, generator, options);
        return builder.build();
    }

    @Override
    public void registerReachableDefinitions(UseRegistry registry) {
        this.triggerDelayedParsingIfNeccessary();
        this.node.instructions.accept((MethodVisitor)new JarRegisterEffectsVisitor(this.clazz, registry, this.application));
    }

    @Override
    public String toString() {
        this.triggerDelayedParsingIfNeccessary();
        TraceMethodVisitor visitor = new TraceMethodVisitor((Printer)new Textifier());
        this.node.accept((MethodVisitor)visitor);
        StringWriter writer = new StringWriter();
        visitor.p.print(new PrintWriter(writer));
        return writer.toString();
    }

    @Override
    public String toString(DexEncodedMethod method, ClassNameMapper naming) {
        return this.toString();
    }

    private void triggerDelayedParsingIfNeccessary() {
        if (this.context != null) {
            DexProgramClass owner = this.context.owner;
            new ClassReader(this.context.classCache).accept((ClassVisitor)new SecondVisitor(this.context, this.application), 4);
            assert (JarCode.verifyNoReparseContext(owner));
        }
    }

    private static boolean verifyNoReparseContext(DexProgramClass owner) {
        Code code;
        for (DexEncodedMethod method : owner.virtualMethods()) {
            code = method.getCode();
            if (code == null || !code.isJarCode() || code.asJarCode().context == null) continue;
            return false;
        }
        for (DexEncodedMethod method : owner.directMethods()) {
            code = method.getCode();
            if (code == null || !code.isJarCode() || code.asJarCode().context == null) continue;
            return false;
        }
        return true;
    }

    private static class SecondVisitor
    extends ClassVisitor {
        private final ReparseContext context;
        private final JarApplicationReader application;

        public SecondVisitor(ReparseContext context, JarApplicationReader application) {
            super(327680);
            this.context = context;
            this.application = application;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            JSRInlinerAdapter node = new JSRInlinerAdapter(null, access, name, desc, signature, exceptions);
            JarCode code = (JarCode)this.context.lookupMap.get(this.application.getMethod(this.context.owner.type, name, desc));
            if (code != null) {
                code.context = null;
                code.node = (MethodNode)node;
                return node;
            }
            return null;
        }
    }

    public static class ReparseContext {
        public byte[] classCache;
        public DexProgramClass owner;
        private IdentityHashMap<DexMethod, JarCode> lookupMap = new IdentityHashMap();
    }
}

