/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.Resource;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.InvokeSuper;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.desugar.ClassProcessor;
import com.android.tools.r8.ir.desugar.InterfaceProcessor;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public final class InterfaceMethodRewriter {
    private static final String COMPANION_CLASS_NAME_SUFFIX = "-CC";
    private static final String DEFAULT_METHOD_PREFIX = "$default$";
    private final IRConverter converter;
    final DexItemFactory factory;
    private final Set<DexEncodedMethod> forwardingMethods = Sets.newIdentityHashSet();

    public InterfaceMethodRewriter(IRConverter converter) {
        assert (converter != null);
        this.converter = converter;
        this.factory = converter.application.dexItemFactory;
    }

    public void rewriteMethodReferences(DexEncodedMethod encodedMethod, IRCode code) {
        if (this.forwardingMethods.contains(encodedMethod)) {
            return;
        }
        ListIterator<BasicBlock> blocks = code.listIterator();
        while (blocks.hasNext()) {
            BasicBlock block = blocks.next();
            InstructionListIterator instructions = block.listIterator();
            while (instructions.hasNext()) {
                DexMethod method;
                Instruction instruction = (Instruction)instructions.next();
                if (instruction.isInvokeCustom()) {
                    DexCallSite callSite = instruction.asInvokeCustom().getCallSite();
                    this.reportStaticInterfaceMethodHandle(callSite.bootstrapMethod);
                    for (DexValue arg : callSite.bootstrapArgs) {
                        if (!(arg instanceof DexValue.DexValueMethodHandle)) continue;
                        this.reportStaticInterfaceMethodHandle((DexMethodHandle)((DexValue.DexValueMethodHandle)arg).value);
                    }
                    continue;
                }
                if (instruction.isInvokeStatic()) {
                    InvokeStatic invokeStatic = instruction.asInvokeStatic();
                    method = invokeStatic.getInvokedMethod();
                    if (!this.isInterfaceClass(method.holder)) continue;
                    instructions.replaceCurrentInstruction(new InvokeStatic(this.staticAsMethodOfCompanionClass(method), invokeStatic.outValue(), invokeStatic.arguments()));
                    continue;
                }
                if (!instruction.isInvokeSuper()) continue;
                InvokeSuper invokeSuper = instruction.asInvokeSuper();
                method = invokeSuper.getInvokedMethod();
                if (!this.isInterfaceClass(method.holder)) continue;
                instructions.replaceCurrentInstruction(new InvokeStatic(this.defaultAsMethodOfCompanionClass(method), invokeSuper.outValue(), invokeSuper.arguments()));
            }
        }
    }

    private void reportStaticInterfaceMethodHandle(DexMethodHandle handle) {
        if (handle.type.isInvokeStatic() && this.isInterfaceClass(handle.asMethod().holder)) {
            throw new Unimplemented("Desugaring of static interface method handle in is not yet supported.");
        }
    }

    private boolean isInterfaceClass(DexType type) {
        return this.findRequiredClass(type).isInterface();
    }

    final DexClass findRequiredClass(DexType type) {
        DexClass clazz = this.converter.appInfo.definitionFor(type);
        if (clazz != null) {
            return clazz;
        }
        throw new CompilationError("Type '" + type.toSourceString() + "' required for default and static interface methods desugaring not found.");
    }

    final DexType getCompanionClassType(DexType type) {
        assert (type.isClassType());
        String descriptor = type.descriptor.toString();
        String ccTypeDescriptor = descriptor.substring(0, descriptor.length() - 1) + COMPANION_CLASS_NAME_SUFFIX + ";";
        return this.factory.createType(ccTypeDescriptor);
    }

    private boolean isInMainDexList(DexType iface) {
        ImmutableSet<DexType> list = this.converter.application.mainDexList;
        return list.contains((Object)iface);
    }

    final DexMethod staticAsMethodOfCompanionClass(DexMethod method) {
        return this.factory.createMethod(this.getCompanionClassType(method.holder), method.proto, method.name);
    }

    final DexMethod defaultAsMethodOfCompanionClass(DexMethod method) {
        DexType[] params = method.proto.parameters.values;
        DexType[] newParams = new DexType[params.length + 1];
        newParams[0] = method.holder;
        System.arraycopy(params, 0, newParams, 1, params.length);
        return this.factory.createMethod(this.getCompanionClassType(method.holder), this.factory.createProto(method.proto.returnType, newParams), this.factory.createString(DEFAULT_METHOD_PREFIX + method.name.toString()));
    }

    public void desugarInterfaceMethods(DexApplication.Builder builder, Flavor flavour) {
        this.forwardingMethods.addAll(this.processClasses(builder, flavour));
        Map<DexProgramClass, DexProgramClass> companionClasses = this.processInterfaces(builder, flavour);
        for (Map.Entry<DexProgramClass, DexProgramClass> entry : companionClasses.entrySet()) {
            builder.addSynthesizedClass(entry.getValue(), this.isInMainDexList(entry.getKey().type));
        }
        for (DexEncodedMethod method : this.forwardingMethods) {
            this.converter.optimizeSynthesizedMethod(method);
        }
    }

    private static boolean shouldProcess(DexProgramClass clazz, Flavor flavour, boolean mustBeInterface) {
        return (clazz.getOrigin() != Resource.Kind.DEX || flavour == Flavor.IncludeAllResources) && clazz.isInterface() == mustBeInterface;
    }

    private Map<DexProgramClass, DexProgramClass> processInterfaces(DexApplication.Builder builder, Flavor flavour) {
        InterfaceProcessor processor = new InterfaceProcessor(this);
        for (DexProgramClass clazz : builder.getProgramClasses()) {
            if (!InterfaceMethodRewriter.shouldProcess(clazz, flavour, true)) continue;
            processor.process(clazz.asProgramClass());
        }
        return processor.companionClasses;
    }

    private Set<DexEncodedMethod> processClasses(DexApplication.Builder builder, Flavor flavour) {
        ClassProcessor processor = new ClassProcessor(this);
        for (DexProgramClass clazz : builder.getProgramClasses()) {
            if (!InterfaceMethodRewriter.shouldProcess(clazz, flavour, false)) continue;
            processor.process(clazz);
        }
        return processor.getForwardMethods();
    }

    final boolean isDefaultMethod(DexEncodedMethod method) {
        assert (!method.accessFlags.isConstructor());
        assert (!method.accessFlags.isStatic());
        if (method.accessFlags.isAbstract()) {
            return false;
        }
        if (method.accessFlags.isNative()) {
            throw new Unimplemented("Native default interface methods are not yet supported.");
        }
        if (!method.accessFlags.isPublic()) {
            throw new Unimplemented("Non public default interface methods are not yet supported.");
        }
        return true;
    }

    public static enum Flavor {
        IncludeAllResources,
        ExcludeDexResources;

    }
}

