/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.graph.DexAccessFlags;
import com.android.tools.r8.shaking.ProguardClassType;
import com.android.tools.r8.shaking.ProguardMemberRule;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import com.android.tools.r8.utils.StringUtils;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public abstract class ProguardClassSpecification {
    private final ProguardTypeMatcher classAnnotation;
    private final DexAccessFlags classAccessFlags;
    private final DexAccessFlags negatedClassAccessFlags;
    private final boolean classTypeNegated;
    private final ProguardClassType classType;
    private final List<ProguardTypeMatcher> classNames;
    private final ProguardTypeMatcher inheritanceAnnotation;
    private final ProguardTypeMatcher inheritanceClassName;
    private final boolean inheritanceIsExtends;
    private final Set<ProguardMemberRule> memberRules;

    protected ProguardClassSpecification(ProguardTypeMatcher classAnnotation, DexAccessFlags classAccessFlags, DexAccessFlags negatedClassAccessFlags, boolean classTypeNegated, ProguardClassType classType, List<ProguardTypeMatcher> classNames, ProguardTypeMatcher inheritanceAnnotation, ProguardTypeMatcher inheritanceClassName, boolean inheritanceIsExtends, Set<ProguardMemberRule> memberRules) {
        this.classAnnotation = classAnnotation;
        this.classAccessFlags = classAccessFlags;
        this.negatedClassAccessFlags = negatedClassAccessFlags;
        this.classTypeNegated = classTypeNegated;
        this.classType = classType;
        this.classNames = classNames;
        this.inheritanceAnnotation = inheritanceAnnotation;
        this.inheritanceClassName = inheritanceClassName;
        this.inheritanceIsExtends = inheritanceIsExtends;
        this.memberRules = memberRules;
    }

    public Set<ProguardMemberRule> getMemberRules() {
        return this.memberRules;
    }

    public boolean getInheritanceIsExtends() {
        return this.inheritanceIsExtends;
    }

    public boolean hasInheritanceClassName() {
        return this.inheritanceClassName != null;
    }

    public ProguardTypeMatcher getInheritanceClassName() {
        return this.inheritanceClassName;
    }

    public ProguardTypeMatcher getInheritanceAnnotation() {
        return this.inheritanceAnnotation;
    }

    public List<ProguardTypeMatcher> getClassNames() {
        return this.classNames;
    }

    public ProguardClassType getClassType() {
        return this.classType;
    }

    public boolean getClassTypeNegated() {
        return this.classTypeNegated;
    }

    public DexAccessFlags getClassAccessFlags() {
        return this.classAccessFlags;
    }

    public DexAccessFlags getNegatedClassAccessFlags() {
        return this.negatedClassAccessFlags;
    }

    public ProguardTypeMatcher getClassAnnotation() {
        return this.classAnnotation;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ProguardClassSpecification)) {
            return false;
        }
        ProguardClassSpecification that = (ProguardClassSpecification)o;
        if (this.classTypeNegated != that.classTypeNegated) {
            return false;
        }
        if (this.inheritanceIsExtends != that.inheritanceIsExtends) {
            return false;
        }
        if (!Objects.equals(this.classAnnotation, that.classAnnotation)) {
            return false;
        }
        if (!this.classAccessFlags.equals(that.classAccessFlags)) {
            return false;
        }
        if (!this.negatedClassAccessFlags.equals(that.negatedClassAccessFlags)) {
            return false;
        }
        if (this.classType != that.classType) {
            return false;
        }
        if (!this.classNames.equals(that.classNames)) {
            return false;
        }
        if (!Objects.equals(this.inheritanceAnnotation, that.inheritanceAnnotation)) {
            return false;
        }
        if (!Objects.equals(this.inheritanceClassName, that.inheritanceClassName)) {
            return false;
        }
        return this.memberRules.equals(that.memberRules);
    }

    public int hashCode() {
        int result = this.classAnnotation != null ? this.classAnnotation.hashCode() : 0;
        result = 3 * result + this.classAccessFlags.hashCode();
        result = 3 * result + this.negatedClassAccessFlags.hashCode();
        result = 3 * result + (this.classTypeNegated ? 1 : 0);
        result = 3 * result + (this.classType != null ? this.classType.hashCode() : 0);
        result = 3 * result + this.classNames.hashCode();
        result = 3 * result + (this.inheritanceAnnotation != null ? this.inheritanceAnnotation.hashCode() : 0);
        result = 3 * result + (this.inheritanceClassName != null ? this.inheritanceClassName.hashCode() : 0);
        result = 3 * result + (this.inheritanceIsExtends ? 1 : 0);
        result = 3 * result + this.memberRules.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        StringUtils.appendNonEmpty(builder, " @", this.classAnnotation, null);
        StringUtils.appendNonEmpty(builder, " ", this.classAccessFlags, null);
        StringUtils.appendNonEmpty(builder, " !", this.negatedClassAccessFlags.toString().replace(" ", " !"), null);
        if (builder.length() > 0) {
            builder.append(' ');
        }
        builder.append((Object)this.classType);
        builder.append(' ');
        boolean first = true;
        for (ProguardTypeMatcher className : this.classNames) {
            builder.append(className);
            if (!first) {
                builder.append(',');
            }
            first = false;
        }
        if (this.hasInheritanceClassName()) {
            builder.append(this.inheritanceIsExtends ? " extends" : " implements");
            StringUtils.appendNonEmpty(builder, " @", this.inheritanceAnnotation, null);
            builder.append(' ');
            builder.append(this.inheritanceClassName);
        }
        builder.append(" {\n");
        this.memberRules.forEach(memberRule -> {
            builder.append("  ");
            builder.append(memberRule);
            builder.append(";\n");
        });
        builder.append("}");
        return builder.toString();
    }

    public static class Builder {
        protected ProguardTypeMatcher classAnnotation;
        protected DexAccessFlags classAccessFlags = new DexAccessFlags(0);
        protected DexAccessFlags negatedClassAccessFlags = new DexAccessFlags(0);
        protected boolean classTypeNegated = false;
        protected ProguardClassType classType;
        protected List<ProguardTypeMatcher> classNames;
        protected ProguardTypeMatcher inheritanceAnnotation;
        protected ProguardTypeMatcher inheritanceClassName;
        protected boolean inheritanceIsExtends = false;
        protected Set<ProguardMemberRule> memberRules = new LinkedHashSet<ProguardMemberRule>();

        protected Builder() {
        }

        public Set<ProguardMemberRule> getMemberRules() {
            return this.memberRules;
        }

        public void setMemberRules(Set<ProguardMemberRule> memberRules) {
            this.memberRules = memberRules;
        }

        public boolean getInheritanceIsExtends() {
            return this.inheritanceIsExtends;
        }

        public void setInheritanceIsExtends(boolean inheritanceIsExtends) {
            this.inheritanceIsExtends = inheritanceIsExtends;
        }

        public boolean hasInheritanceClassName() {
            return this.inheritanceClassName != null;
        }

        public ProguardTypeMatcher getInheritanceClassName() {
            return this.inheritanceClassName;
        }

        public void setInheritanceClassName(ProguardTypeMatcher inheritanceClassName) {
            this.inheritanceClassName = inheritanceClassName;
        }

        public ProguardTypeMatcher getInheritanceAnnotation() {
            return this.inheritanceAnnotation;
        }

        public void setInheritanceAnnotation(ProguardTypeMatcher inheritanceAnnotation) {
            this.inheritanceAnnotation = inheritanceAnnotation;
        }

        public List<ProguardTypeMatcher> getClassNames() {
            return this.classNames;
        }

        public void setClassNames(List<ProguardTypeMatcher> classNames) {
            this.classNames = classNames;
        }

        public ProguardClassType getClassType() {
            return this.classType;
        }

        public void setClassType(ProguardClassType classType) {
            this.classType = classType;
        }

        public boolean getClassTypeNegated() {
            return this.classTypeNegated;
        }

        public void setClassTypeNegated(boolean classTypeNegated) {
            this.classTypeNegated = classTypeNegated;
        }

        public DexAccessFlags getClassAccessFlags() {
            return this.classAccessFlags;
        }

        public void setClassAccessFlags(DexAccessFlags flags) {
            this.classAccessFlags = flags;
        }

        public DexAccessFlags getNegatedClassAccessFlags() {
            return this.negatedClassAccessFlags;
        }

        public void setNegatedClassAccessFlags(DexAccessFlags flags) {
            this.negatedClassAccessFlags = flags;
        }

        public ProguardTypeMatcher getClassAnnotation() {
            return this.classAnnotation;
        }

        public void setClassAnnotation(ProguardTypeMatcher classAnnotation) {
            this.classAnnotation = classAnnotation;
        }

        protected void matchAllSpecification() {
            this.setClassNames(Collections.singletonList(ProguardTypeMatcher.defaultAllMatcher()));
            this.setMemberRules(Collections.singleton(ProguardMemberRule.defaultKeepAllRule()));
        }
    }
}

