/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.Resource;
import com.android.tools.r8.utils.DescriptorUtils;
import com.google.common.collect.Sets;
import java.io.File;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;

public final class DirectoryClassFileProvider
implements ClassFileResourceProvider {
    private final Path root;

    private DirectoryClassFileProvider(Path root) {
        this.root = root;
    }

    @Override
    public Set<String> getClassDescriptors() {
        HashSet result = Sets.newHashSet();
        this.collectClassDescriptors(this.root, result);
        return result;
    }

    private void collectClassDescriptors(Path dir, Set<String> result) {
        File[] files;
        File file = dir.toFile();
        if (file.exists() && (files = file.listFiles()) != null) {
            for (File child : files) {
                if (child.isDirectory()) {
                    this.collectClassDescriptors(child.toPath(), result);
                    continue;
                }
                String relative = this.root.relativize(child.toPath()).toString();
                if (!relative.endsWith(".class")) continue;
                result.add("L" + relative.substring(0, relative.length() - ".class".length()) + ";");
            }
        }
    }

    @Override
    public Resource getResource(String descriptor) {
        assert (DescriptorUtils.isClassDescriptor(descriptor));
        String classBinaryName = DescriptorUtils.getClassBinaryNameFromDescriptor(descriptor);
        Path filePath = this.root.resolve(classBinaryName + ".class");
        File file = filePath.toFile();
        return file.exists() && !file.isDirectory() ? Resource.fromFile(Resource.Kind.CLASSFILE, filePath) : null;
    }

    public static ClassFileResourceProvider fromDirectory(Path dir) {
        return new DirectoryClassFileProvider(dir.toAbsolutePath());
    }

    public Path getRoot() {
        return this.root;
    }

    public String toString() {
        return "directory(" + this.root + ")";
    }
}

