/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.conversion.CallGraph;
import com.android.tools.r8.ir.conversion.LensCodeRewriter;
import com.android.tools.r8.ir.conversion.OptimizationFeedback;
import com.android.tools.r8.ir.conversion.OptimizationFeedbackDirect;
import com.android.tools.r8.ir.conversion.OptimizationFeedbackIgnore;
import com.android.tools.r8.ir.desugar.InterfaceMethodRewriter;
import com.android.tools.r8.ir.desugar.LambdaRewriter;
import com.android.tools.r8.ir.optimize.CodeRewriter;
import com.android.tools.r8.ir.optimize.DeadCodeRemover;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.MemberValuePropagation;
import com.android.tools.r8.ir.optimize.Outliner;
import com.android.tools.r8.ir.optimize.PeepholeOptimizer;
import com.android.tools.r8.ir.regalloc.LinearScanRegisterAllocator;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import com.android.tools.r8.shaking.protolite.ProtoLitePruner;
import com.android.tools.r8.utils.CfgPrinter;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiConsumer;

public class IRConverter {
    private static final int PEEPHOLE_OPTIMIZATION_PASSES = 2;
    private final Timing timing;
    public final DexApplication application;
    public final AppInfo appInfo;
    private final Outliner outliner;
    private final LambdaRewriter lambdaRewriter;
    private final InterfaceMethodRewriter interfaceMethodRewriter;
    private final InternalOptions options;
    private final CfgPrinter printer;
    private final GraphLense graphLense;
    private final CodeRewriter codeRewriter;
    private final MemberValuePropagation memberValuePropagation;
    private final LensCodeRewriter lensCodeRewriter;
    private final Inliner inliner;
    private final ProtoLitePruner protoLiteRewriter;
    private CallGraph callGraph;
    private OptimizationFeedback ignoreOptimizationFeedback = new OptimizationFeedbackIgnore();
    private DexString highestSortingString;

    private IRConverter(Timing timing, DexApplication application, AppInfo appInfo, GraphLense graphLense, InternalOptions options, CfgPrinter printer, boolean enableDesugaring, boolean enableWholeProgramOptimizations) {
        assert (application != null);
        assert (appInfo != null);
        assert (options != null);
        this.timing = timing != null ? timing : new Timing("internal");
        this.application = application;
        this.appInfo = appInfo;
        this.graphLense = graphLense != null ? graphLense : GraphLense.getIdentityLense();
        this.options = options;
        this.printer = printer;
        this.codeRewriter = new CodeRewriter(appInfo, this.libraryMethodsReturningReceiver());
        this.lambdaRewriter = enableDesugaring ? new LambdaRewriter(this) : null;
        InterfaceMethodRewriter interfaceMethodRewriter = this.interfaceMethodRewriter = enableDesugaring && this.enableInterfaceMethodDesugaring() ? new InterfaceMethodRewriter(this) : null;
        if (enableWholeProgramOptimizations) {
            assert (appInfo.hasSubtyping());
            this.inliner = new Inliner(appInfo.withSubtyping(), graphLense, options);
            this.outliner = new Outliner(appInfo, options);
            this.memberValuePropagation = new MemberValuePropagation(appInfo);
            this.lensCodeRewriter = new LensCodeRewriter(graphLense, appInfo.withSubtyping());
            this.protoLiteRewriter = appInfo.hasLiveness() ? new ProtoLitePruner(appInfo.withLiveness()) : null;
        } else {
            this.inliner = null;
            this.outliner = null;
            this.memberValuePropagation = null;
            this.lensCodeRewriter = null;
            this.protoLiteRewriter = null;
        }
    }

    public IRConverter(DexApplication application, AppInfo appInfo, InternalOptions options) {
        this(null, application, appInfo, null, options, null, true, false);
    }

    public IRConverter(DexApplication application, AppInfo appInfo, InternalOptions options, boolean enableDesugaring) {
        this(null, application, appInfo, null, options, null, enableDesugaring, false);
    }

    public IRConverter(Timing timing, DexApplication application, AppInfo appInfo, InternalOptions options, CfgPrinter printer) {
        this(timing, application, appInfo, null, options, printer, true, false);
    }

    public IRConverter(Timing timing, DexApplication application, AppInfoWithSubtyping appInfo, InternalOptions options, CfgPrinter printer, GraphLense graphLense) {
        this(timing, application, appInfo, graphLense, options, printer, true, true);
    }

    private boolean enableInterfaceMethodDesugaring() {
        switch (this.options.interfaceMethodDesugaring) {
            case Off: {
                return false;
            }
            case Auto: {
                return !this.options.canUseDefaultAndStaticInterfaceMethods();
            }
        }
        throw new Unreachable();
    }

    private boolean enableTryWithResourcesDesugaring() {
        switch (this.options.tryWithResourcesDesugaring) {
            case Off: {
                return false;
            }
            case Auto: {
                return !this.options.canUseSuppressedExceptions();
            }
        }
        throw new Unreachable();
    }

    private Set<DexMethod> libraryMethodsReturningReceiver() {
        HashSet<DexMethod> methods = new HashSet<DexMethod>();
        DexItemFactory dexItemFactory = this.appInfo.dexItemFactory;
        dexItemFactory.stringBufferMethods.forEachAppendMethod(methods::add);
        dexItemFactory.stringBuilderMethods.forEachAppendMethod(methods::add);
        return methods;
    }

    private void removeLambdaDeserializationMethods() {
        if (this.lambdaRewriter != null) {
            this.lambdaRewriter.removeLambdaDeserializationMethods(this.application.classes());
        }
    }

    private void synthesizeLambdaClasses(DexApplication.Builder builder) {
        if (this.lambdaRewriter != null) {
            this.lambdaRewriter.adjustAccessibility();
            this.lambdaRewriter.synthesizeLambdaClasses(builder);
        }
    }

    private void desugarInterfaceMethods(DexApplication.Builder builder, InterfaceMethodRewriter.Flavor includeAllResources) {
        if (this.interfaceMethodRewriter != null) {
            this.interfaceMethodRewriter.desugarInterfaceMethods(builder, includeAllResources);
        }
    }

    public DexApplication convertToDex(ExecutorService executor) throws ExecutionException {
        this.removeLambdaDeserializationMethods();
        this.convertClassesToDex(this.application.classes(), executor);
        DexApplication.Builder builder = new DexApplication.Builder(this.application);
        builder.setHighestSortingString(this.highestSortingString);
        this.synthesizeLambdaClasses(builder);
        this.desugarInterfaceMethods(builder, InterfaceMethodRewriter.Flavor.ExcludeDexResources);
        return builder.build();
    }

    private void convertClassesToDex(Iterable<DexProgramClass> classes, ExecutorService executor) throws ExecutionException {
        ArrayList futures = new ArrayList();
        for (DexProgramClass clazz : classes) {
            futures.add(executor.submit(() -> clazz.forEachMethod(this::convertMethodToDex)));
        }
        ThreadUtils.awaitFutures(futures);
        this.removeEmptyClassInitializers();
    }

    private void convertMethodToDex(DexEncodedMethod method) {
        boolean matchesMethodFilter;
        if (method.getCode() != null && (matchesMethodFilter = this.options.methodMatchesFilter(method))) {
            if (method.getCode().isJarCode()) {
                this.rewriteCode(method, this.ignoreOptimizationFeedback, Outliner::noProcessing);
            }
            this.updateHighestSortingStrings(method);
        }
    }

    public DexApplication optimize() throws ExecutionException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            DexApplication dexApplication = this.optimize(executor);
            return dexApplication;
        }
        finally {
            executor.shutdown();
        }
    }

    public DexApplication optimize(ExecutorService executorService) throws ExecutionException {
        this.removeLambdaDeserializationMethods();
        this.timing.begin("Build call graph");
        this.callGraph = CallGraph.build(this.application, this.appInfo.withSubtyping(), this.graphLense, this.options);
        this.timing.end();
        this.timing.begin("IR conversion phase 1");
        OptimizationFeedbackDirect directFeedback = new OptimizationFeedbackDirect();
        this.callGraph.forEachMethod(method -> this.processMethod((DexEncodedMethod)method, directFeedback, this.outliner == null ? Outliner::noProcessing : this.outliner::identifyCandidates), executorService);
        this.timing.end();
        this.removeEmptyClassInitializers();
        DexApplication.Builder builder = new DexApplication.Builder(this.application);
        builder.setHighestSortingString(this.highestSortingString);
        if (this.inliner != null) {
            this.inliner.processDoubleInlineCallers(this, this.ignoreOptimizationFeedback);
        }
        this.synthesizeLambdaClasses(builder);
        this.desugarInterfaceMethods(builder, InterfaceMethodRewriter.Flavor.IncludeAllResources);
        if (this.outliner != null) {
            this.timing.begin("IR conversion phase 2");
            DexProgramClass outlineClass = this.prepareOutlining();
            if (outlineClass != null) {
                this.callGraph = CallGraph.build(this.application, this.appInfo.withSubtyping(), GraphLense.getIdentityLense(), this.options);
                Set<DexEncodedMethod> outlineMethods = this.outliner.getMethodsSelectedForOutlining();
                this.callGraph.forEachMethod(method -> {
                    if (!outlineMethods.contains(method)) {
                        return;
                    }
                    assert (!method.getCode().isOutlineCode());
                    this.processMethod((DexEncodedMethod)method, this.ignoreOptimizationFeedback, this.outliner::applyOutliningCandidate);
                    assert (method.isProcessed());
                }, executorService);
                builder.addSynthesizedClass(outlineClass, true);
                this.clearDexMethodCompilationState(outlineClass);
            }
            this.timing.end();
        }
        this.clearDexMethodCompilationState();
        return builder.build();
    }

    private void removeEmptyClassInitializers() {
        this.application.classes().forEach(this::removeEmptyClassInitializer);
    }

    private void removeEmptyClassInitializer(DexProgramClass clazz) {
        if (clazz.hasTrivialClassInitializer()) {
            clazz.removeStaticMethod(clazz.getClassInitializer());
        }
    }

    private void clearDexMethodCompilationState() {
        this.application.classes().forEach(this::clearDexMethodCompilationState);
    }

    private void clearDexMethodCompilationState(DexProgramClass clazz) {
        clazz.forEachMethod(DexEncodedMethod::markNotProcessed);
    }

    public void replaceCodeForTesting(DexEncodedMethod method, IRCode code) {
        assert (code.isConsistentSSA());
        RegisterAllocator registerAllocator = this.performRegisterAllocation(code, method);
        method.setCode(code, registerAllocator, this.appInfo.dexItemFactory);
    }

    private DexType computeOutlineClassType() {
        String name;
        DexType result;
        int count = 0;
        do {
            InternalOptions.OutlineOptions cfr_ignored_0 = this.options.outline;
            name = "r8.GeneratedOutlineSupport" + (count == 0 ? "" : Integer.toString(count));
            ++count;
        } while (this.application.definitionFor(result = this.application.dexItemFactory.createType(DescriptorUtils.javaTypeToDescriptor(name))) != null);
        this.appInfo.registerNewType(result, this.appInfo.dexItemFactory.objectType);
        return result;
    }

    private DexProgramClass prepareOutlining() {
        if (!this.outliner.selectMethodsForOutlining()) {
            return null;
        }
        DexProgramClass outlineClass = this.outliner.buildOutlinerClass(this.computeOutlineClassType());
        this.optimizeSynthesizedClass(outlineClass);
        return outlineClass;
    }

    public void optimizeSynthesizedClass(DexProgramClass clazz) {
        clazz.forEachMethod(this::optimizeSynthesizedMethod);
    }

    public void optimizeSynthesizedMethod(DexEncodedMethod method) {
        this.processMethod(method, this.ignoreOptimizationFeedback, Outliner::noProcessing);
    }

    private String logCode(InternalOptions options, DexEncodedMethod method) {
        return options.useSmaliSyntax ? method.toSmaliString(null) : method.codeToString();
    }

    public void processMethod(DexEncodedMethod method, OptimizationFeedback feedback, BiConsumer<IRCode, DexEncodedMethod> outlineHandler) {
        Code code = method.getCode();
        boolean matchesMethodFilter = this.options.methodMatchesFilter(method);
        if (code != null && matchesMethodFilter) {
            this.rewriteCode(method, feedback, outlineHandler);
        } else {
            method.markProcessed(Inliner.Constraint.NEVER);
        }
    }

    private void rewriteCode(DexEncodedMethod method, OptimizationFeedback feedback, BiConsumer<IRCode, DexEncodedMethod> outlineHandler) {
        IRCode code;
        if (this.options.verbose) {
            System.out.println("Processing: " + method.toSourceString());
        }
        if ((code = method.buildIR(this.options)) == null) {
            feedback.markProcessed(method, Inliner.Constraint.NEVER);
            return;
        }
        this.printC1VisualizerHeader(method);
        this.printMethod(code, "Initial IR (SSA)");
        if (!method.isProcessed()) {
            if (this.protoLiteRewriter != null && this.protoLiteRewriter.appliesTo(method)) {
                this.protoLiteRewriter.rewriteProtoLiteSpecialMethod(code, method);
            }
            if (this.lensCodeRewriter != null) {
                this.lensCodeRewriter.rewrite(code, method);
            } else assert (this.graphLense.isIdentityLense());
        }
        if (this.memberValuePropagation != null) {
            this.memberValuePropagation.rewriteWithConstantValues(code);
        }
        if (this.options.removeSwitchMaps && this.appInfo.hasLiveness()) {
            assert (!this.options.debug);
            this.codeRewriter.removeSwitchMaps(code);
        }
        if (this.options.disableAssertions) {
            this.codeRewriter.disableAssertions(code);
        }
        if (this.options.inlineAccessors && this.inliner != null) {
            assert (!this.options.debug);
            this.inliner.performInlining(method, code, this.callGraph);
        }
        this.codeRewriter.removeCastChains(code);
        this.codeRewriter.rewriteLongCompareAndRequireNonNull(code, this.options);
        this.codeRewriter.commonSubexpressionElimination(code);
        this.codeRewriter.simplifyArrayConstruction(code);
        this.codeRewriter.rewriteMoveResult(code);
        this.codeRewriter.splitRangeInvokeConstants(code);
        this.codeRewriter.foldConstants(code);
        this.codeRewriter.rewriteSwitch(code);
        this.codeRewriter.simplifyIf(code);
        this.codeRewriter.collectClassInitializerDefaults(method, code);
        DeadCodeRemover.removeDeadCode(code, this.codeRewriter, this.options);
        assert (code.isConsistentSSA());
        if (this.enableTryWithResourcesDesugaring()) {
            this.codeRewriter.rewriteThrowableAddAndGetSuppressed(code);
        }
        if (this.lambdaRewriter != null) {
            this.lambdaRewriter.desugarLambdas(method, code);
            assert (code.isConsistentSSA());
        }
        if (this.interfaceMethodRewriter != null) {
            this.interfaceMethodRewriter.rewriteMethodReferences(method, code);
            assert (code.isConsistentSSA());
        }
        if (this.options.outline.enabled) {
            outlineHandler.accept(code, method);
            assert (code.isConsistentSSA());
        }
        this.codeRewriter.shortenLiveRanges(code);
        this.codeRewriter.identifyReturnsArgument(method, code, feedback);
        if (this.options.methodMatchesLogArgumentsFilter(method)) {
            this.codeRewriter.logArgumentTypes(method, code);
        }
        this.printMethod(code, "Optimized IR (SSA)");
        RegisterAllocator registerAllocator = this.performRegisterAllocation(code, method);
        method.setCode(code, registerAllocator, this.appInfo.dexItemFactory);
        this.updateHighestSortingStrings(method);
        this.printMethod(code, "Final IR (non-SSA)");
        Inliner.Constraint state = !this.options.inlineAccessors || this.inliner == null ? Inliner.Constraint.NEVER : this.inliner.computeInliningConstraint(code, method);
        feedback.markProcessed(method, state);
    }

    private synchronized void updateHighestSortingStrings(DexEncodedMethod method) {
        DexString highestSortingReferencedString = method.getCode().asDexCode().highestSortingString;
        if (highestSortingReferencedString != null && (this.highestSortingString == null || highestSortingReferencedString.slowCompareTo(this.highestSortingString) > 0)) {
            this.highestSortingString = highestSortingReferencedString;
        }
    }

    private RegisterAllocator performRegisterAllocation(IRCode code, DexEncodedMethod method) {
        DeadCodeRemover.removeDeadCode(code, this.codeRewriter, this.options);
        LinearScanRegisterAllocator registerAllocator = new LinearScanRegisterAllocator(code, this.options);
        registerAllocator.allocateRegisters(this.options.debug);
        this.printMethod(code, "After register allocation (non-SSA)");
        this.printLiveRanges(registerAllocator, "Final live ranges.");
        if (!this.options.debug) {
            CodeRewriter.removedUnneededDebugPositions(code);
        }
        for (int i = 0; i < 2; ++i) {
            CodeRewriter.collapsTrivialGotos(method, code);
            PeepholeOptimizer.optimize(code, registerAllocator);
        }
        CodeRewriter.collapsTrivialGotos(method, code);
        return registerAllocator;
    }

    private void printC1VisualizerHeader(DexEncodedMethod method) {
        if (this.printer != null) {
            this.printer.begin("compilation");
            this.printer.print("name \"").append(method.toSourceString()).append("\"").ln();
            this.printer.print("method \"").append(method.toSourceString()).append("\"").ln();
            this.printer.print("date 0").ln();
            this.printer.end("compilation");
        }
    }

    private void printMethod(IRCode code, String title) {
        if (this.printer != null) {
            this.printer.resetUnusedValue();
            this.printer.begin("cfg");
            this.printer.print("name \"").append(title).append("\"\n");
            code.print(this.printer);
            this.printer.end("cfg");
        }
    }

    private void printLiveRanges(LinearScanRegisterAllocator allocator, String title) {
        if (this.printer != null) {
            allocator.print(this.printer, title);
        }
    }
}

