/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt;

import com.android.builder.internal.aapt.AaptQueueThreadContext;
import com.android.builder.png.AaptProcess;
import com.android.builder.tasks.Job;
import com.android.builder.tasks.WorkQueue;
import com.android.ide.common.internal.ResourceProcessor;
import com.android.utils.ILogger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class QueuedResourceProcessor
implements ResourceProcessor {
    protected static final int DEFAULT_NUMBER_DAEMON_PROCESSES = Integer.max(5, Runtime.getRuntime().availableProcessors());
    protected final String aaptLocation;
    protected final ILogger logger;
    protected final WorkQueue<AaptProcess> processingRequests;
    protected final Map<Integer, ConcurrentLinkedQueue<Job<AaptProcess>>> outstandingJobs = new ConcurrentHashMap<Integer, ConcurrentLinkedQueue<Job<AaptProcess>>>();
    protected final Map<Integer, ConcurrentLinkedQueue<Job<AaptProcess>>> doneJobs = new ConcurrentHashMap<Integer, ConcurrentLinkedQueue<Job<AaptProcess>>>();
    protected final AtomicInteger refCount = new AtomicInteger(0);
    protected final AtomicInteger keyProvider = new AtomicInteger(0);

    protected QueuedResourceProcessor(String aaptLocation, ILogger iLogger, int processesNumber) {
        this.aaptLocation = aaptLocation;
        this.logger = iLogger;
        AaptQueueThreadContext queueThreadContext = new AaptQueueThreadContext(this.logger, aaptLocation, this.outstandingJobs, this.doneJobs);
        int processToUse = processesNumber > 0 ? processesNumber : DEFAULT_NUMBER_DAEMON_PROCESSES;
        this.processingRequests = new WorkQueue<AaptProcess>(this.logger, queueThreadContext, "queued-resource-processor", processToUse, 0.0f);
    }

    protected void waitForAll(int key) throws InterruptedException {
        Job<AaptProcess> aaptProcessJob;
        boolean hasExceptions = false;
        while ((aaptProcessJob = this.outstandingJobs.get(key).poll()) != null) {
            this.logger.verbose("Thread(%1$s) : wait for {%2$s)", new Object[]{Thread.currentThread().getName(), aaptProcessJob.toString()});
            try {
                aaptProcessJob.awaitRethrowExceptions();
            }
            catch (ExecutionException e) {
                this.logger.verbose("Exception while processing job : " + aaptProcessJob.toString() + " : " + e.getCause(), new Object[0]);
                hasExceptions = true;
            }
        }
        while ((aaptProcessJob = this.doneJobs.get(key).poll()) != null) {
            try {
                aaptProcessJob.awaitRethrowExceptions();
            }
            catch (ExecutionException e) {
                this.logger.verbose("Exception while processing job : " + aaptProcessJob.toString() + " : " + e.getCause(), new Object[0]);
                hasExceptions = true;
            }
        }
        if (hasExceptions) {
            throw new RuntimeException("Some file processing failed, see logs for details");
        }
    }

    public synchronized int start() {
        this.refCount.incrementAndGet();
        int key = this.keyProvider.incrementAndGet();
        this.outstandingJobs.put(key, new ConcurrentLinkedQueue());
        this.doneJobs.put(key, new ConcurrentLinkedQueue());
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void end(int key) throws InterruptedException {
        block7: {
            long startTime = System.currentTimeMillis();
            try {
                this.waitForAll(key);
                this.outstandingJobs.get(key).clear();
                if (this.refCount.decrementAndGet() != 0) break block7;
            }
            catch (Throwable throwable) {
                if (this.refCount.decrementAndGet() == 0) {
                    try {
                        this.processingRequests.shutdown();
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        this.logger.warning("Error while shutting down queued resource proecssor queue : %s", new Object[]{e.getMessage()});
                    }
                    this.logger.verbose("Shutdown finished in %1$dms", new Object[]{System.currentTimeMillis() - startTime});
                }
                throw throwable;
            }
            try {
                this.processingRequests.shutdown();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                this.logger.warning("Error while shutting down queued resource proecssor queue : %s", new Object[]{e.getMessage()});
            }
            this.logger.verbose("Shutdown finished in %1$dms", new Object[]{System.currentTimeMillis() - startTime});
        }
    }
}

