/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.CompilationException;
import com.android.tools.r8.CompilationResult;
import com.android.tools.r8.Disassemble;
import com.android.tools.r8.R8Command;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.dex.ApplicationWriter;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.MainDexError;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.ClassAndMemberPublicizer;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.optimize.EnumOrdinalMapCollector;
import com.android.tools.r8.ir.optimize.SwitchMapCollector;
import com.android.tools.r8.naming.Minifier;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.optimize.BridgeMethodAnalysis;
import com.android.tools.r8.optimize.DebugStripper;
import com.android.tools.r8.optimize.MemberRebindingAnalysis;
import com.android.tools.r8.optimize.VisibilityBridgeRemover;
import com.android.tools.r8.shaking.AbstractMethodRemover;
import com.android.tools.r8.shaking.AnnotationRemover;
import com.android.tools.r8.shaking.DiscardedChecker;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.MainDexListBuilder;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.shaking.ProguardRuleParserException;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import com.android.tools.r8.shaking.ReasonPrinter;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.shaking.SimpleClassMerger;
import com.android.tools.r8.shaking.TreePruner;
import com.android.tools.r8.shaking.protolite.ProtoLiteExtension;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.CfgPrinter;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.PackageDistribution;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class R8 {
    private static final String VERSION = "v0.1.10";
    private final Timing timing = new Timing("R8");
    private final InternalOptions options;

    private R8(InternalOptions options) {
        this.options = options;
        options.itemFactory.resetSortedIndices();
    }

    private static Marker getMarker(InternalOptions options) {
        if (options.hasMarker()) {
            return options.getMarker();
        }
        return new Marker(Marker.Tool.R8).put("version", VERSION).put("min-api", options.minApiLevel);
    }

    public static AndroidApp writeApplication(ExecutorService executorService, DexApplication application, AppInfo appInfo, byte[] deadCode, NamingLens namingLens, byte[] proguardSeedsData, PackageDistribution packageDistribution, InternalOptions options) throws ExecutionException {
        try {
            Marker marker = R8.getMarker(options);
            return new ApplicationWriter(application, appInfo, options, marker, deadCode, namingLens, proguardSeedsData).write(packageDistribution, executorService);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write dex application", e);
        }
    }

    static DexApplication optimize(DexApplication application, AppInfoWithSubtyping appInfo, InternalOptions options) throws ProguardRuleParserException, ExecutionException, IOException {
        return new R8(options).optimize(application, appInfo);
    }

    private DexApplication optimize(DexApplication application, AppInfoWithSubtyping appInfo) throws IOException, ProguardRuleParserException, ExecutionException {
        return this.optimize(application, appInfo, GraphLense.getIdentityLense(), Executors.newSingleThreadExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DexApplication optimize(DexApplication application, AppInfoWithSubtyping appInfo, GraphLense graphLense, ExecutorService executorService) throws IOException, ProguardRuleParserException, ExecutionException {
        CfgPrinter printer = this.options.printCfg ? new CfgPrinter() : null;
        this.timing.begin("Create IR");
        try {
            IRConverter converter = new IRConverter(this.timing, application, appInfo, this.options, printer, graphLense);
            application = converter.optimize(executorService);
        }
        finally {
            this.timing.end();
        }
        if (!this.options.skipDebugInfoOpt && application.getProguardMap() != null) {
            try {
                this.timing.begin("DebugStripper");
                DebugStripper stripper = new DebugStripper(application.getProguardMap(), this.options, appInfo.dexItemFactory);
                application.classes().forEach(stripper::processClass);
            }
            finally {
                this.timing.end();
            }
        }
        if (this.options.printCfg) {
            if (this.options.printCfgFile == null || this.options.printCfgFile.isEmpty()) {
                System.out.print(printer.toString());
            } else {
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.options.printCfgFile), StandardCharsets.UTF_8);){
                    writer.write(printer.toString());
                }
            }
        }
        return application;
    }

    private Set<DexType> filterMissingClasses(Set<DexType> missingClasses, Set<ProguardTypeMatcher> dontWarnPatterns) {
        HashSet<DexType> result = new HashSet<DexType>(missingClasses);
        for (ProguardTypeMatcher matcher : dontWarnPatterns) {
            if (matcher instanceof ProguardTypeMatcher.MatchSpecificType) {
                result.remove(((ProguardTypeMatcher.MatchSpecificType)matcher).type);
                continue;
            }
            result.removeIf(matcher::matches);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disassemble(Disassemble.DisassembleCommand command) throws IOException, ExecutionException {
        block17: {
            Path output = command.getOutputPath();
            AndroidApp app = command.getInputApp();
            InternalOptions options = command.getInternalOptions();
            ExecutorService executor = ThreadUtils.getExecutorService(options);
            Timing timing = new Timing("disassemble");
            try {
                DexApplication application = new ApplicationReader(app, options, timing).read(executor);
                if (options.useSmaliSyntax) {
                    if (output != null) {
                        Files.createDirectories(output, new FileAttribute[0]);
                        try (PrintStream ps = new PrintStream(Files.newOutputStream(output.resolve("classes.smali"), new OpenOption[0]));){
                            application.smali(options, ps);
                            break block17;
                        }
                    }
                    application.smali(options, System.out);
                    break block17;
                }
                application.disassemble(output, options);
            }
            finally {
                executor.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CompilationResult runForTesting(AndroidApp app, InternalOptions options) throws ProguardRuleParserException, IOException {
        ExecutorService executor = ThreadUtils.getExecutorService(options);
        try {
            CompilationResult compilationResult = R8.runForTesting(app, options, executor);
            return compilationResult;
        }
        finally {
            executor.shutdown();
        }
    }

    private static CompilationResult runForTesting(AndroidApp app, InternalOptions options, ExecutorService executor) throws ProguardRuleParserException, IOException {
        return new R8(options).run(app, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompilationResult run(AndroidApp inputApp, ExecutorService executorService) throws IOException, ProguardRuleParserException {
        if (this.options.quiet) {
            System.setOut(new PrintStream(ByteStreams.nullOutputStream()));
        }
        try {
            Object object;
            ReasonPrinter reasonPrinter;
            Enqueuer enqueuer;
            RootSetBuilder.RootSet rootSet;
            if (this.options.minApiLevel >= 26 && !this.options.mainDexKeepRules.isEmpty()) {
                throw new CompilationError("Automatic main dex list is not supported when compiling for android O and later (--min-api 26)");
            }
            DexApplication application = new ApplicationReader(inputApp, this.options, this.timing).read(executorService);
            AppInfoWithSubtyping appInfo = new AppInfoWithSubtyping(application);
            byte[] proguardSeedsData = null;
            this.timing.begin("Strip unused code");
            try {
                Set<DexType> missingClasses = appInfo.getMissingClasses();
                missingClasses = this.filterMissingClasses(missingClasses, (Set<ProguardTypeMatcher>)this.options.proguardConfiguration.getDontWarnPatterns());
                if (!missingClasses.isEmpty()) {
                    System.err.println();
                    System.err.println("WARNING, some classes are missing:");
                    missingClasses.forEach(clazz -> System.err.println(" - " + clazz.toSourceString()));
                    if (!this.options.ignoreMissingClasses) {
                        throw new CompilationError("Shrinking can't be performed because some library classes are missing.");
                    }
                }
                rootSet = new RootSetBuilder(application, appInfo, (List<ProguardConfigurationRule>)this.options.proguardConfiguration.getRules()).run(executorService);
                enqueuer = new Enqueuer(appInfo);
                enqueuer.addExtension(new ProtoLiteExtension(appInfo));
                appInfo = enqueuer.traceApplication(rootSet, this.timing);
                if (this.options.proguardConfiguration.isPrintSeeds()) {
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                    PrintStream out = new PrintStream(bytes);
                    RootSetBuilder.writeSeeds(appInfo.withLiveness().pinnedItems, out);
                    out.flush();
                    proguardSeedsData = bytes.toByteArray();
                }
                if (this.options.useTreeShaking) {
                    application = new TreePruner(application, appInfo.withLiveness(), this.options).run();
                    appInfo = appInfo.withLiveness().prunedCopyFrom(application);
                    new AbstractMethodRemover(appInfo).run();
                    new AnnotationRemover(appInfo.withLiveness(), this.options).run();
                }
            }
            finally {
                this.timing.end();
            }
            if (this.options.proguardConfiguration.isAccessModificationAllowed()) {
                ClassAndMemberPublicizer.run(application);
                application = new VisibilityBridgeRemover(appInfo, application).run();
            }
            GraphLense graphLense = GraphLense.getIdentityLense();
            if (appInfo.hasLiveness()) {
                graphLense = new MemberRebindingAnalysis(appInfo.withLiveness(), graphLense).run();
                if (!this.options.skipClassMerging && this.options.inlineAccessors) {
                    this.timing.begin("ClassMerger");
                    graphLense = new SimpleClassMerger(application, appInfo.withLiveness(), graphLense, this.timing).run();
                    this.timing.end();
                }
                appInfo = appInfo.withLiveness().prunedCopyFrom(application);
                appInfo = appInfo.withLiveness().rewrittenWithLense(graphLense);
                new SwitchMapCollector(appInfo.withLiveness(), this.options).run();
                new EnumOrdinalMapCollector(appInfo.withLiveness(), this.options).run();
            }
            graphLense = new BridgeMethodAnalysis(graphLense, appInfo.withSubtyping()).run();
            application = this.optimize(application, appInfo, graphLense, executorService);
            if (!this.options.mainDexKeepRules.isEmpty()) {
                appInfo = new AppInfoWithSubtyping(application);
                enqueuer = new Enqueuer(appInfo);
                RootSetBuilder.RootSet mainDexRootSet = new RootSetBuilder(application, appInfo, (List<ProguardConfigurationRule>)this.options.mainDexKeepRules).run(executorService);
                Set<DexType> mainDexBaseClasses = enqueuer.traceMainDex(mainDexRootSet, this.timing);
                application = new DexApplication.Builder(application).addToMainDexList(new MainDexListBuilder(mainDexBaseClasses, application).run()).build();
            }
            appInfo = new AppInfoWithSubtyping(application);
            if (this.options.useTreeShaking || !this.options.skipMinification) {
                this.timing.begin("Post optimization code stripping");
                try {
                    enqueuer = new Enqueuer(appInfo);
                    appInfo = enqueuer.traceApplication(rootSet, this.timing);
                    if (this.options.useTreeShaking) {
                        application = new TreePruner(application, appInfo.withLiveness(), this.options).run();
                        appInfo = appInfo.withLiveness().prunedCopyFrom(application);
                        reasonPrinter = enqueuer.getReasonPrinter(rootSet.reasonAsked);
                        reasonPrinter.run(application);
                    }
                }
                finally {
                    this.timing.end();
                }
            }
            if (this.options.useTreeShaking && !rootSet.checkDiscarded.isEmpty()) {
                new DiscardedChecker(rootSet, application).run();
            }
            this.timing.begin("Minification");
            NamingLens namingLens = this.options.skipMinification ? NamingLens.getIdentityLens() : new Minifier(appInfo.withLiveness(), rootSet, this.options).run(this.timing);
            this.timing.end();
            if (this.options.hasMethodsFilter()) {
                System.out.println("Finished compilation with method filter: ");
                this.options.methodsFilter.forEach(m -> System.out.println("  - " + m));
                reasonPrinter = null;
                return reasonPrinter;
            }
            PackageDistribution packageDistribution = null;
            if (inputApp.hasPackageDistribution()) {
                Closer closer = Closer.create();
                object = null;
                try {
                    packageDistribution = PackageDistribution.load(inputApp.getPackageDistribution(closer));
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (closer != null) {
                        if (object != null) {
                            try {
                                closer.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            closer.close();
                        }
                    }
                }
            }
            AndroidApp androidApp = R8.writeApplication(executorService, application, appInfo, application.deadCode, namingLens, proguardSeedsData, packageDistribution, this.options);
            this.options.printWarnings();
            object = new CompilationResult(androidApp, application, appInfo);
            return object;
        }
        catch (MainDexError mainDexError) {
            throw new CompilationError(mainDexError.getMessageForR8());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CompilationError) {
                throw (CompilationError)e.getCause();
            }
            throw new RuntimeException(e.getMessage(), e.getCause());
        }
        finally {
            if (this.options.printTimes) {
                this.timing.report();
            }
        }
    }

    public static AndroidApp run(R8Command command) throws IOException, CompilationException, ProguardRuleParserException {
        ExecutorService executorService = ThreadUtils.getExecutorService(command.getInternalOptions());
        try {
            AndroidApp androidApp = R8.run(command, executorService);
            return androidApp;
        }
        finally {
            executorService.shutdown();
        }
    }

    static void writeOutputs(R8Command command, InternalOptions options, AndroidApp outputApp) throws IOException {
        Throwable throwable;
        Closer closer;
        if (command.getOutputPath() != null) {
            outputApp.write(command.getOutputPath(), options.outputMode);
        }
        if (options.proguardConfiguration.isPrintMapping() && !options.skipMinification) {
            assert (outputApp.hasProguardMap());
            closer = Closer.create();
            throwable = null;
            try {
                OutputStream mapOut = FileUtils.openPathWithDefault(closer, options.proguardConfiguration.getPrintMappingFile(), System.out, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                outputApp.writeProguardMap(mapOut);
            }
            catch (Throwable mapOut) {
                throwable = mapOut;
                throw mapOut;
            }
            finally {
                if (closer != null) {
                    if (throwable != null) {
                        try {
                            closer.close();
                        }
                        catch (Throwable mapOut) {
                            throwable.addSuppressed(mapOut);
                        }
                    } else {
                        closer.close();
                    }
                }
            }
        }
        if (options.proguardConfiguration.isPrintSeeds()) {
            assert (outputApp.hasProguardSeeds());
            closer = Closer.create();
            throwable = null;
            try {
                OutputStream seedsOut = FileUtils.openPathWithDefault(closer, options.proguardConfiguration.getSeedFile(), System.out, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                outputApp.writeProguardSeeds(closer, seedsOut);
            }
            catch (Throwable seedsOut) {
                throwable = seedsOut;
                throw seedsOut;
            }
            finally {
                if (closer != null) {
                    if (throwable != null) {
                        try {
                            closer.close();
                        }
                        catch (Throwable seedsOut) {
                            throwable.addSuppressed(seedsOut);
                        }
                    } else {
                        closer.close();
                    }
                }
            }
        }
        if (outputApp.hasMainDexListOutput()) {
            closer = Closer.create();
            throwable = null;
            try {
                OutputStream mainDexOut = FileUtils.openPathWithDefault(closer, options.printMainDexListFile, System.out, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                outputApp.writeMainDexList(closer, mainDexOut);
            }
            catch (Throwable mainDexOut) {
                throwable = mainDexOut;
                throw mainDexOut;
            }
            finally {
                if (closer != null) {
                    if (throwable != null) {
                        try {
                            closer.close();
                        }
                        catch (Throwable mainDexOut) {
                            throwable.addSuppressed(mainDexOut);
                        }
                    } else {
                        closer.close();
                    }
                }
            }
        }
        if (options.proguardConfiguration.isPrintUsage() && outputApp.hasDeadCode()) {
            closer = Closer.create();
            throwable = null;
            try {
                OutputStream deadCodeOut = FileUtils.openPathWithDefault(closer, options.proguardConfiguration.getPrintUsageFile(), System.out, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                outputApp.writeDeadCode(closer, deadCodeOut);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (closer != null) {
                    if (throwable != null) {
                        try {
                            closer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        closer.close();
                    }
                }
            }
        }
    }

    public static AndroidApp run(R8Command command, ExecutorService executor) throws IOException, CompilationException, ProguardRuleParserException {
        InternalOptions options = command.getInternalOptions();
        AndroidApp outputApp = R8.runForTesting((AndroidApp)command.getInputApp(), (InternalOptions)options, (ExecutorService)executor).androidApp;
        R8.writeOutputs(command, options, outputApp);
        return outputApp;
    }

    private static void run(String[] args) throws IOException, ProguardRuleParserException, CompilationException {
        R8Command command;
        R8Command.Builder builder = R8Command.parse(args);
        if (builder.getOutputPath() == null) {
            builder.setOutputPath(Paths.get(".", new String[0]));
        }
        if ((command = builder.build()).isPrintHelp()) {
            System.out.println(R8Command.USAGE_MESSAGE);
            return;
        }
        if (command.isPrintVersion()) {
            System.out.println("R8 v0.1.10");
            return;
        }
        R8.run(command);
    }

    public static void main(String[] args) {
        try {
            R8.run(args);
        }
        catch (NoSuchFileException e) {
            System.err.println("File not found: " + e.getFile());
            System.exit(1);
        }
        catch (FileAlreadyExistsException e) {
            System.err.println("File already exists: " + e.getFile());
        }
        catch (IOException e) {
            System.err.println("Failed to read or write Android app: " + e.getMessage());
            System.exit(1);
        }
        catch (ProguardRuleParserException e) {
            System.err.println("Failed parsing proguard keep rules: " + e.getMessage());
            System.exit(1);
        }
        catch (RuntimeException e) {
            System.err.println("Compilation failed with an internal error.");
            Throwable cause = e.getCause() == null ? e : e.getCause();
            cause.printStackTrace();
            System.exit(1);
        }
        catch (CompilationException e) {
            System.err.println("Compilation failed: " + e.getMessage());
            System.err.println(R8Command.USAGE_MESSAGE);
            System.exit(1);
        }
    }
}

