/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.dex.Constants;
import com.android.tools.r8.dex.DebugBytecodeWriter;
import com.android.tools.r8.dex.DexOutputBuffer;
import com.android.tools.r8.dex.JumboStringRewriter;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.Descriptor;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationDirectory;
import com.android.tools.r8.graph.DexAnnotationElement;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexAnnotationSetRefList;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexDebugInfo;
import com.android.tools.r8.graph.DexEncodedAnnotation;
import com.android.tools.r8.graph.DexEncodedArray;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.graph.KeyedDexItem;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.PresortedComparable;
import com.android.tools.r8.graph.ProgramClassVisitor;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.LebUtils;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.zip.Adler32;

public class FileWriter {
    private final ObjectToOffsetMapping mapping;
    private final DexApplication application;
    private final AppInfo appInfo;
    private final InternalOptions options;
    private final NamingLens namingLens;
    private final DexOutputBuffer dest = new DexOutputBuffer();
    private final MixedSectionOffsets mixedSectionOffsets;

    public FileWriter(ObjectToOffsetMapping mapping, DexApplication application, AppInfo appinfo, InternalOptions options, NamingLens namingLens) {
        this.mapping = mapping;
        this.application = application;
        this.appInfo = appinfo;
        this.options = options;
        this.namingLens = namingLens;
        this.mixedSectionOffsets = new MixedSectionOffsets();
    }

    public static void writeEncodedAnnotation(DexEncodedAnnotation annotation, DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
        dest.putUleb128(mapping.getOffsetFor(annotation.type));
        dest.putUleb128(annotation.elements.length);
        assert (FileWriter.isSorted(annotation.elements, element -> element.name));
        for (DexAnnotationElement element2 : annotation.elements) {
            dest.putUleb128(mapping.getOffsetFor(element2.name));
            element2.value.writeTo(dest, mapping);
        }
    }

    private static <T extends PresortedComparable<T>> boolean isSorted(KeyedDexItem<T>[] items) {
        return FileWriter.isSorted(items, KeyedDexItem::getKey);
    }

    private static <S, T extends Comparable<T>> boolean isSorted(S[] items, Function<S, T> getter) {
        Comparable current = null;
        for (S item : items) {
            Comparable next = (Comparable)getter.apply(item);
            if (current != null && current.compareTo(next) >= 0) {
                return false;
            }
            current = next;
        }
        return true;
    }

    public FileWriter collect() {
        new ProgramClassDependencyCollector(this.application, this.mapping.getClasses()).run(this.mapping.getClasses());
        this.sortClassData(this.mixedSectionOffsets.getClassesWithData());
        this.mixedSectionOffsets.getClassesWithData().forEach(this::addStaticFieldValues);
        assert (this.mixedSectionOffsets.stringData.size() == 0);
        for (DexString dexString : this.mapping.getStrings()) {
            this.mixedSectionOffsets.add(dexString);
        }
        for (IndexedDexItem indexedDexItem : this.mapping.getProtos()) {
            this.mixedSectionOffsets.add(((DexProto)indexedDexItem).parameters);
        }
        DexItem.collectAll((MixedSectionCollection)this.mixedSectionOffsets, (DexItem[])this.mapping.getCallSites());
        DexItem.collectAll((MixedSectionCollection)this.mixedSectionOffsets, (DexItem[])this.mapping.getClasses());
        return this;
    }

    private void rewriteCodeWithJumboStrings(DexEncodedMethod method) {
        if (method.getCode() == null) {
            return;
        }
        DexCode code = method.getCode().asDexCode();
        if (code.highestSortingString != null && this.mapping.getOffsetFor(code.highestSortingString) > 65535) {
            JumboStringRewriter rewriter = new JumboStringRewriter(method, this.mapping.getFirstJumboString(), this.options.itemFactory);
            rewriter.rewrite();
        }
    }

    public FileWriter rewriteCodeWithJumboStrings(List<DexProgramClass> classes) {
        if (!this.mapping.hasJumboStrings()) {
            return this;
        }
        if (this.application.highestSortingString != null && this.application.highestSortingString.slowCompareTo(this.mapping.getFirstJumboString()) < 0) {
            return this;
        }
        for (DexProgramClass clazz : classes) {
            clazz.forEachMethod(method -> this.rewriteCodeWithJumboStrings((DexEncodedMethod)method));
        }
        return this;
    }

    public byte[] generate() {
        this.checkInterfaceMethods();
        Layout layout = Layout.from(this.mapping);
        layout.setCodesOffset(layout.dataSectionOffset);
        List<DexCode> codes = this.sortDexCodesByClassName(this.mixedSectionOffsets.getCodes(), this.application);
        this.dest.moveTo(layout.getCodesOffset() + this.sizeOfCodeItems(codes));
        this.writeItems(this.mixedSectionOffsets.getDebugInfos(), layout::setDebugInfosOffset, this::writeDebugItem);
        layout.setTypeListsOffset(this.dest.align(4));
        this.dest.moveTo(layout.getCodesOffset());
        assert (this.dest.isAligned(4));
        this.writeItems(codes, layout::alreadySetOffset, this::writeCodeItem, 4);
        assert (layout.getDebugInfosOffset() == 0 || this.dest.position() == layout.getDebugInfosOffset());
        this.dest.moveTo(layout.getTypeListsOffset());
        this.writeItems(this.mixedSectionOffsets.getTypeLists(), layout::alreadySetOffset, this::writeTypeList);
        this.writeItems(this.mixedSectionOffsets.getStringData(), layout::setStringDataOffsets, this::writeStringData);
        this.writeItems(this.mixedSectionOffsets.getAnnotations(), layout::setAnnotationsOffset, this::writeAnnotation);
        this.writeItems(this.mixedSectionOffsets.getClassesWithData(), layout::setClassDataOffset, this::writeClassData);
        this.writeItems(this.mixedSectionOffsets.getEncodedArrays(), layout::setEncodedArrarysOffset, this::writeEncodedArray);
        this.writeItems(this.mixedSectionOffsets.getAnnotationSets(), layout::setAnnotationSetsOffset, this::writeAnnotationSet, 4);
        this.writeItems(this.mixedSectionOffsets.getAnnotationSetRefLists(), layout::setAnnotationSetRefListsOffset, this::writeAnnotationSetRefList, 4);
        this.writeItems(this.mixedSectionOffsets.getAnnotationDirectories(), layout::setAnnotationDirectoriesOffset, this::writeAnnotationDirectory, 4);
        layout.setMapOffset(this.dest.align(4));
        this.writeMap(layout);
        layout.setEndOfFile(this.dest.position());
        this.dest.moveTo(112);
        this.writeFixedSectionItems(this.mapping.getStrings(), layout.stringIdsOffset, this::writeStringItem);
        this.writeFixedSectionItems(this.mapping.getTypes(), layout.typeIdsOffset, this::writeTypeItem);
        this.writeFixedSectionItems(this.mapping.getProtos(), layout.protoIdsOffset, this::writeProtoItem);
        this.writeFixedSectionItems(this.mapping.getFields(), layout.fieldIdsOffset, this::writeFieldItem);
        this.writeFixedSectionItems(this.mapping.getMethods(), layout.methodIdsOffset, this::writeMethodItem);
        this.writeFixedSectionItems(this.mapping.getClasses(), layout.classDefsOffset, this::writeClassDefItem);
        this.writeFixedSectionItems(this.mapping.getCallSites(), layout.callSiteIdsOffset, this::writeCallSite);
        this.writeFixedSectionItems(this.mapping.getMethodHandles(), layout.methodHandleIdsOffset, this::writeMethodHandle);
        this.writeHeader(layout);
        this.writeSignature(layout);
        this.writeChecksum(layout);
        return Arrays.copyOf(this.dest.asArray(), layout.getEndOfFile());
    }

    private void sortClassData(Collection<DexProgramClass> classesWithData) {
        for (DexProgramClass clazz : classesWithData) {
            this.sortEncodedFields(clazz.instanceFields());
            this.sortEncodedFields(clazz.staticFields());
            this.sortEncodedMethods(clazz.directMethods());
            this.sortEncodedMethods(clazz.virtualMethods());
        }
    }

    private void sortEncodedFields(DexEncodedField[] fields) {
        Arrays.sort(fields, (a, b) -> a.field.compareTo(b.field));
    }

    private void sortEncodedMethods(DexEncodedMethod[] methods) {
        Arrays.sort(methods, (a, b) -> a.method.compareTo(b.method));
    }

    private void checkInterfaceMethods() {
        for (DexProgramClass clazz : this.mapping.getClasses()) {
            if (!clazz.isInterface()) continue;
            clazz.forEachMethod(this::checkInterfaceMethod);
        }
    }

    private void checkInterfaceMethod(DexEncodedMethod method) {
        if (this.application.dexItemFactory.isClassConstructor(method.method)) {
            return;
        }
        if (method.accessFlags.isStatic()) {
            if (!this.options.canUseDefaultAndStaticInterfaceMethods()) {
                throw new CompilationError("Static interface methods are only supported starting with Android N (--min-api 24): " + method.method.toSourceString());
            }
        } else {
            if (method.isInstanceInitializer()) {
                throw new CompilationError("Interface must not have constructors: " + method.method.toSourceString());
            }
            if (!(method.accessFlags.isAbstract() || method.accessFlags.isPrivate() || this.options.canUseDefaultAndStaticInterfaceMethods())) {
                throw new CompilationError("Default interface methods are only supported starting with Android N (--min-api 24): " + method.method.toSourceString());
            }
        }
        if (method.accessFlags.isPrivate()) {
            if (this.options.canUsePrivateInterfaceMethods()) {
                return;
            }
            throw new CompilationError("Private interface methods are only supported starting with Android N (--min-api 24): " + method.method.toSourceString());
        }
        if (!method.accessFlags.isPublic()) {
            throw new CompilationError("Interface methods must not be protected or package private: " + method.method.toSourceString());
        }
    }

    private List<DexCode> sortDexCodesByClassName(Collection<DexCode> codes, DexApplication application) {
        IdentityHashMap codeToSignatureMap = new IdentityHashMap();
        for (DexProgramClass clazz : this.mapping.getClasses()) {
            clazz.forEachMethod(method -> FileWriter.addSignaturesFromMethod(method, codeToSignatureMap, application.getProguardMap()));
        }
        DexCode[] codesArray = codes.toArray(new DexCode[codes.size()]);
        Arrays.sort(codesArray, Comparator.comparing(codeToSignatureMap::get));
        return Arrays.asList(codesArray);
    }

    private static void addSignaturesFromMethod(DexEncodedMethod method, Map<DexCode, String> codeToSignatureMap, ClassNameMapper proguardMap) {
        if (method.getCode() == null) {
            assert (method.accessFlags.isAbstract() || method.accessFlags.isNative());
        } else {
            String originalClassName;
            MemberNaming.Signature signature;
            if (proguardMap != null) {
                signature = proguardMap.originalSignatureOf(method.method);
                originalClassName = proguardMap.originalNameOf(method.method.holder);
            } else {
                signature = MemberNaming.MethodSignature.fromDexMethod(method.method);
                originalClassName = method.method.holder.toSourceString();
            }
            codeToSignatureMap.put(method.getCode().asDexCode(), originalClassName + signature);
        }
    }

    private <T extends DexItem> void writeFixedSectionItems(T[] items, int offset, Consumer<T> writer) {
        assert (this.dest.position() == offset);
        for (T item : items) {
            writer.accept(item);
        }
    }

    private <T extends DexItem> void writeItems(Collection<T> items, Consumer<Integer> offsetSetter, Consumer<T> writer) {
        this.writeItems(items, offsetSetter, writer, 1);
    }

    private <T extends DexItem> void writeItems(Collection<T> items, Consumer<Integer> offsetSetter, Consumer<T> writer, int alignment) {
        if (items.isEmpty()) {
            offsetSetter.accept(0);
        } else {
            offsetSetter.accept(this.dest.align(alignment));
            items.forEach(writer);
        }
    }

    private int sizeOfCodeItems(Iterable<DexCode> codes) {
        int size = 0;
        for (DexCode code : codes) {
            size = this.alignSize(4, size);
            size += this.sizeOfCodeItem(code);
        }
        return size;
    }

    private int sizeOfCodeItem(DexCode code) {
        int result = 16;
        int insnSize = 0;
        for (Instruction insn : code.instructions) {
            insnSize += insn.getSize();
        }
        result += insnSize * 2;
        result += code.tries.length * 8;
        if (code.handlers != null && code.handlers.length > 0) {
            result = this.alignSize(4, result);
            result += LebUtils.sizeAsUleb128(code.handlers.length);
            for (DexCode.TryHandler handler : code.handlers) {
                boolean hasCatchAll = handler.catchAllAddr != -1;
                result += LebUtils.sizeAsSleb128(hasCatchAll ? -handler.pairs.length : handler.pairs.length);
                for (DexCode.TryHandler.TypeAddrPair pair : handler.pairs) {
                    result += LebUtils.sizeAsUleb128(this.mapping.getOffsetFor(pair.type));
                    result += LebUtils.sizeAsUleb128(pair.addr);
                }
                if (!hasCatchAll) continue;
                result += LebUtils.sizeAsUleb128(handler.catchAllAddr);
            }
        }
        return result;
    }

    private void writeStringItem(DexString string) {
        this.dest.putInt(this.mixedSectionOffsets.getOffsetFor(string));
    }

    private void writeTypeItem(DexType type) {
        DexString descriptor = this.namingLens.lookupDescriptor(type);
        this.dest.putInt(this.mapping.getOffsetFor(descriptor));
    }

    private void writeProtoItem(DexProto proto) {
        this.dest.putInt(this.mapping.getOffsetFor(proto.shorty));
        this.dest.putInt(this.mapping.getOffsetFor(proto.returnType));
        this.dest.putInt(this.mixedSectionOffsets.getOffsetFor(proto.parameters));
    }

    private void writeFieldItem(DexField field) {
        int classIdx = this.mapping.getOffsetFor(field.clazz);
        assert ((short)classIdx == classIdx);
        this.dest.putShort((short)classIdx);
        int typeIdx = this.mapping.getOffsetFor(field.type);
        assert ((short)typeIdx == typeIdx);
        this.dest.putShort((short)typeIdx);
        DexString name = this.namingLens.lookupName(field);
        this.dest.putInt(this.mapping.getOffsetFor(name));
    }

    private void writeMethodItem(DexMethod method) {
        int classIdx = this.mapping.getOffsetFor(method.holder);
        assert ((short)classIdx == classIdx);
        this.dest.putShort((short)classIdx);
        int protoIdx = this.mapping.getOffsetFor(method.proto);
        assert ((short)protoIdx == protoIdx);
        this.dest.putShort((short)protoIdx);
        DexString name = this.namingLens.lookupName(method);
        this.dest.putInt(this.mapping.getOffsetFor(name));
    }

    private void writeClassDefItem(DexProgramClass clazz) {
        this.dest.putInt(this.mapping.getOffsetFor(clazz.type));
        this.dest.putInt(clazz.accessFlags.get());
        this.dest.putInt(clazz.superType == null ? -1 : this.mapping.getOffsetFor(clazz.superType));
        this.dest.putInt(this.mixedSectionOffsets.getOffsetFor(clazz.interfaces));
        this.dest.putInt(clazz.sourceFile == null ? -1 : this.mapping.getOffsetFor(clazz.sourceFile));
        this.dest.putInt(this.mixedSectionOffsets.getOffsetForAnnotationsDirectory(clazz));
        this.dest.putInt(clazz.hasMethodsOrFields() ? this.mixedSectionOffsets.getOffsetFor(clazz) : 0);
        this.dest.putInt(this.mixedSectionOffsets.getOffsetFor(clazz.getStaticValues()));
    }

    private void writeDebugItem(DexDebugInfo debugInfo) {
        this.mixedSectionOffsets.setOffsetFor(debugInfo, this.dest.position());
        this.dest.putBytes(new DebugBytecodeWriter(debugInfo, this.mapping).generate());
    }

    private void writeCodeItem(DexCode code) {
        this.mixedSectionOffsets.setOffsetFor(code, this.dest.align(4));
        this.dest.putShort((short)code.registerSize);
        this.dest.putShort((short)code.incomingRegisterSize);
        this.dest.putShort((short)code.outgoingRegisterSize);
        this.dest.putShort((short)code.tries.length);
        this.dest.putInt(this.mixedSectionOffsets.getOffsetFor(code.getDebugInfo()));
        int insnSizeOffset = this.dest.position();
        this.dest.forward(4);
        this.dest.putInstructions(code.instructions, this.mapping);
        int insnSize = this.dest.position() - insnSizeOffset - 4;
        this.dest.rewind(insnSize + 4);
        this.dest.putInt(insnSize / 2);
        this.dest.forward(insnSize);
        if (code.tries.length > 0) {
            int beginOfTriesOffset = this.dest.align(4);
            this.dest.forward(code.tries.length * 8);
            int beginOfHandlersOffset = this.dest.position();
            this.dest.putUleb128(code.handlers.length);
            short[] offsets = new short[code.handlers.length];
            int i = 0;
            for (DexCode.TryHandler handler : code.handlers) {
                offsets[i++] = (short)(this.dest.position() - beginOfHandlersOffset);
                boolean hasCatchAll = handler.catchAllAddr != -1;
                this.dest.putSleb128(hasCatchAll ? -handler.pairs.length : handler.pairs.length);
                for (DexCode.TryHandler.TypeAddrPair pair : handler.pairs) {
                    this.dest.putUleb128(this.mapping.getOffsetFor(pair.type));
                    this.dest.putUleb128(pair.addr);
                }
                if (!hasCatchAll) continue;
                this.dest.putUleb128(handler.catchAllAddr);
            }
            int endOfCodeOffset = this.dest.position();
            this.dest.moveTo(beginOfTriesOffset);
            for (DexCode.Try aTry : code.tries) {
                this.dest.putInt(aTry.startAddress);
                this.dest.putShort((short)aTry.instructionCount);
                this.dest.putShort(offsets[aTry.handlerIndex]);
            }
            this.dest.moveTo(endOfCodeOffset);
        }
    }

    private void writeTypeList(DexTypeList list) {
        assert (!list.isEmpty());
        this.mixedSectionOffsets.setOffsetFor(list, this.dest.align(4));
        DexType[] values = list.values;
        this.dest.putInt(values.length);
        for (DexType type : values) {
            this.dest.putShort((short)this.mapping.getOffsetFor(type));
        }
    }

    private void writeStringData(DexString string) {
        this.mixedSectionOffsets.setOffsetFor(string, this.dest.position());
        this.dest.putUleb128(string.size);
        this.dest.putBytes(string.content);
    }

    private void writeAnnotation(DexAnnotation annotation) {
        this.mixedSectionOffsets.setOffsetFor(annotation, this.dest.position());
        this.dest.putByte((byte)annotation.visibility);
        FileWriter.writeEncodedAnnotation(annotation.annotation, this.dest, this.mapping);
    }

    private void writeAnnotationSet(DexAnnotationSet set) {
        assert (!set.isEmpty());
        assert (FileWriter.isSorted(set.annotations, item -> item.annotation.type));
        this.mixedSectionOffsets.setOffsetFor(set, this.dest.align(4));
        this.dest.putInt(set.annotations.length);
        for (DexAnnotation annotation : set.annotations) {
            this.dest.putInt(this.mixedSectionOffsets.getOffsetFor(annotation));
        }
    }

    private void writeAnnotationSetRefList(DexAnnotationSetRefList setRefList) {
        assert (!setRefList.isEmpty());
        this.mixedSectionOffsets.setOffsetFor(setRefList, this.dest.align(4));
        this.dest.putInt(setRefList.values.length);
        for (DexAnnotationSet set : setRefList.values) {
            this.dest.putInt(this.mixedSectionOffsets.getOffsetFor(set));
        }
    }

    private <S extends Descriptor<T, S>, T extends KeyedDexItem<S>> void writeMemberAnnotations(List<T> items, ToIntFunction<T> getter) {
        for (KeyedDexItem item : items) {
            this.dest.putInt(((Descriptor)item.getKey()).getOffset(this.mapping));
            this.dest.putInt(getter.applyAsInt(item));
        }
    }

    private void writeAnnotationDirectory(DexAnnotationDirectory annotationDirectory) {
        this.mixedSectionOffsets.setOffsetForAnnotationsDirectory(annotationDirectory, this.dest.align(4));
        this.dest.putInt(this.mixedSectionOffsets.getOffsetFor(annotationDirectory.getClazzAnnotations()));
        List<DexEncodedMethod> methodAnnotations = annotationDirectory.getMethodAnnotations();
        List<DexEncodedMethod> parameterAnnotations = annotationDirectory.getParameterAnnotations();
        List<DexEncodedField> fieldAnnotations = annotationDirectory.getFieldAnnotations();
        this.dest.putInt(fieldAnnotations.size());
        this.dest.putInt(methodAnnotations.size());
        this.dest.putInt(parameterAnnotations.size());
        this.writeMemberAnnotations(fieldAnnotations, item -> this.mixedSectionOffsets.getOffsetFor(item.annotations));
        this.writeMemberAnnotations(methodAnnotations, item -> this.mixedSectionOffsets.getOffsetFor(item.annotations));
        this.writeMemberAnnotations(parameterAnnotations, item -> this.mixedSectionOffsets.getOffsetFor(item.parameterAnnotations));
    }

    private void writeEncodedFields(DexEncodedField[] fields) {
        assert (FileWriter.isSorted(fields));
        int currentOffset = 0;
        for (DexEncodedField field : fields) {
            int nextOffset = this.mapping.getOffsetFor(field.field);
            assert (nextOffset - currentOffset >= 0);
            this.dest.putUleb128(nextOffset - currentOffset);
            currentOffset = nextOffset;
            this.dest.putUleb128(field.accessFlags.get());
        }
    }

    private void writeEncodedMethods(DexEncodedMethod[] methods) {
        assert (FileWriter.isSorted(methods));
        int currentOffset = 0;
        for (DexEncodedMethod method : methods) {
            int nextOffset = this.mapping.getOffsetFor(method.method);
            assert (nextOffset - currentOffset >= 0);
            this.dest.putUleb128(nextOffset - currentOffset);
            currentOffset = nextOffset;
            this.dest.putUleb128(method.accessFlags.get());
            if (method.getCode() == null) {
                assert (method.accessFlags.isAbstract() || method.accessFlags.isNative());
                this.dest.putUleb128(0);
                continue;
            }
            this.dest.putUleb128(this.mixedSectionOffsets.getOffsetFor(method.getCode().asDexCode()));
            method.removeCode();
        }
    }

    private void writeClassData(DexProgramClass clazz) {
        assert (clazz.hasMethodsOrFields());
        this.mixedSectionOffsets.setOffsetFor(clazz, this.dest.position());
        this.dest.putUleb128(clazz.staticFields().length);
        this.dest.putUleb128(clazz.instanceFields().length);
        this.dest.putUleb128(clazz.directMethods().length);
        this.dest.putUleb128(clazz.virtualMethods().length);
        this.writeEncodedFields(clazz.staticFields());
        this.writeEncodedFields(clazz.instanceFields());
        this.writeEncodedMethods(clazz.directMethods());
        this.writeEncodedMethods(clazz.virtualMethods());
    }

    private void addStaticFieldValues(DexProgramClass clazz) {
        DexEncodedField[] fields = clazz.staticFields();
        int length = 0;
        ArrayList<DexValue> values = new ArrayList<DexValue>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            DexEncodedField field = fields[i];
            assert (field.staticValue != null);
            values.add(field.staticValue);
            if (field.staticValue.isDefault(field.field.type, this.application.dexItemFactory)) continue;
            length = i + 1;
        }
        if (length > 0) {
            DexEncodedArray staticValues = new DexEncodedArray(values.subList(0, length).toArray(new DexValue[length]));
            clazz.setStaticValues(staticValues);
            this.mixedSectionOffsets.add(staticValues);
        }
    }

    private void writeMethodHandle(DexMethodHandle methodHandle) {
        int fieldOrMethodIdx;
        DexMethodHandle.MethodHandleType methodHandleDexType;
        this.checkThatInvokeCustomIsAllowed();
        switch (methodHandle.type) {
            case INVOKE_CONSTRUCTOR: {
                throw new CompilationError("Constructor method handle type is not yet supported.");
            }
            case INVOKE_INTERFACE: 
            case INVOKE_SUPER: {
                methodHandleDexType = DexMethodHandle.MethodHandleType.INVOKE_INSTANCE;
                break;
            }
            default: {
                methodHandleDexType = methodHandle.type;
            }
        }
        assert (this.dest.isAligned(4));
        this.dest.putShort(methodHandleDexType.getValue());
        this.dest.putShort((short)0);
        if (methodHandle.isMethodHandle()) {
            fieldOrMethodIdx = this.mapping.getOffsetFor(methodHandle.asMethod());
        } else {
            assert (methodHandle.isFieldHandle());
            fieldOrMethodIdx = this.mapping.getOffsetFor(methodHandle.asField());
        }
        assert ((short)fieldOrMethodIdx == fieldOrMethodIdx);
        this.dest.putShort((short)fieldOrMethodIdx);
        this.dest.putShort((short)0);
    }

    private void writeCallSite(DexCallSite callSite) {
        this.checkThatInvokeCustomIsAllowed();
        assert (this.dest.isAligned(4));
        this.dest.putInt(this.mixedSectionOffsets.getOffsetFor(callSite.getEncodedArray()));
    }

    private void writeEncodedArray(DexEncodedArray array) {
        this.mixedSectionOffsets.setOffsetFor(array, this.dest.position());
        this.dest.putUleb128(array.values.length);
        for (DexValue value : array.values) {
            value.writeTo(this.dest, this.mapping);
        }
    }

    private int writeMapItem(int type, int offset, int length) {
        if (length == 0) {
            return 0;
        }
        this.dest.putShort((short)type);
        this.dest.putShort((short)0);
        this.dest.putInt(length);
        this.dest.putInt(offset);
        return 1;
    }

    private void writeMap(Layout layout) {
        int startOfMap = this.dest.align(4);
        this.dest.forward(4);
        int size = 0;
        size += this.writeMapItem(0, 0, 1);
        size += this.writeMapItem(1, layout.stringIdsOffset, this.mapping.getStrings().length);
        size += this.writeMapItem(2, layout.typeIdsOffset, this.mapping.getTypes().length);
        size += this.writeMapItem(3, layout.protoIdsOffset, this.mapping.getProtos().length);
        size += this.writeMapItem(4, layout.fieldIdsOffset, this.mapping.getFields().length);
        size += this.writeMapItem(5, layout.methodIdsOffset, this.mapping.getMethods().length);
        size += this.writeMapItem(6, layout.classDefsOffset, this.mapping.getClasses().length);
        size += this.writeMapItem(7, layout.callSiteIdsOffset, this.mapping.getCallSites().length);
        size += this.writeMapItem(8, layout.methodHandleIdsOffset, this.mapping.getMethodHandles().length);
        size += this.writeMapItem(8193, layout.getCodesOffset(), this.mixedSectionOffsets.getCodes().size());
        size += this.writeMapItem(8195, layout.getDebugInfosOffset(), this.mixedSectionOffsets.getDebugInfos().size());
        size += this.writeMapItem(4097, layout.getTypeListsOffset(), this.mixedSectionOffsets.getTypeLists().size());
        size += this.writeMapItem(8194, layout.getStringDataOffsets(), this.mixedSectionOffsets.getStringData().size());
        size += this.writeMapItem(8196, layout.getAnnotationsOffset(), this.mixedSectionOffsets.getAnnotations().size());
        size += this.writeMapItem(8192, layout.getClassDataOffset(), this.mixedSectionOffsets.getClassesWithData().size());
        size += this.writeMapItem(8197, layout.getEncodedArrarysOffset(), this.mixedSectionOffsets.getEncodedArrays().size());
        size += this.writeMapItem(4099, layout.getAnnotationSetsOffset(), this.mixedSectionOffsets.getAnnotationSets().size());
        size += this.writeMapItem(4098, layout.getAnnotationSetRefListsOffset(), this.mixedSectionOffsets.getAnnotationSetRefLists().size());
        size += this.writeMapItem(8198, layout.getAnnotationDirectoriesOffset(), this.mixedSectionOffsets.getAnnotationDirectories().size());
        this.dest.moveTo(startOfMap);
        this.dest.putInt(size += this.writeMapItem(4096, layout.getMapOffset(), 1));
        this.dest.forward(size * 12);
    }

    private static byte[] convertApiLevelToDexVersion(int apiLevel) {
        if (apiLevel >= 26) {
            return Constants.ANDROID_O_DEX_VERSION_BYTES;
        }
        if (apiLevel >= 24) {
            return Constants.ANDROID_N_DEX_VERSION_BYTES;
        }
        return Constants.ANDROID_PRE_N_DEX_VERSION_BYTES;
    }

    private void writeHeader(Layout layout) {
        this.dest.moveTo(0);
        this.dest.putBytes(Constants.DEX_FILE_MAGIC_PREFIX);
        this.dest.putBytes(FileWriter.convertApiLevelToDexVersion(this.options.minApiLevel));
        this.dest.putByte((byte)0);
        this.dest.moveTo(32);
        this.dest.putInt(layout.getEndOfFile());
        this.dest.putInt(112);
        this.dest.putInt(305419896);
        this.dest.putInt(0);
        this.dest.putInt(0);
        this.dest.putInt(layout.getMapOffset());
        int numberOfStrings = this.mapping.getStrings().length;
        this.dest.putInt(numberOfStrings);
        this.dest.putInt(numberOfStrings == 0 ? 0 : layout.stringIdsOffset);
        int numberOfTypes = this.mapping.getTypes().length;
        this.dest.putInt(numberOfTypes);
        this.dest.putInt(numberOfTypes == 0 ? 0 : layout.typeIdsOffset);
        int numberOfProtos = this.mapping.getProtos().length;
        this.dest.putInt(numberOfProtos);
        this.dest.putInt(numberOfProtos == 0 ? 0 : layout.protoIdsOffset);
        int numberOfFields = this.mapping.getFields().length;
        this.dest.putInt(numberOfFields);
        this.dest.putInt(numberOfFields == 0 ? 0 : layout.fieldIdsOffset);
        int numberOfMethods = this.mapping.getMethods().length;
        this.dest.putInt(numberOfMethods);
        this.dest.putInt(numberOfMethods == 0 ? 0 : layout.methodIdsOffset);
        int numberOfClasses = this.mapping.getClasses().length;
        this.dest.putInt(numberOfClasses);
        this.dest.putInt(numberOfClasses == 0 ? 0 : layout.classDefsOffset);
        this.dest.putInt(layout.getDataSectionSize());
        this.dest.putInt(layout.dataSectionOffset);
        assert (this.dest.position() == layout.stringIdsOffset);
    }

    private void writeSignature(Layout layout) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(this.dest.asArray(), 32, layout.getEndOfFile() - 84);
            md.digest(this.dest.asArray(), 12, 20);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeChecksum(Layout layout) {
        Adler32 adler = new Adler32();
        adler.update(this.dest.asArray(), 12, layout.getEndOfFile() - 12);
        this.dest.moveTo(8);
        this.dest.putInt((int)adler.getValue());
    }

    private int alignSize(int bytes, int value) {
        int mask = bytes - 1;
        return value + mask & ~mask;
    }

    private void checkThatInvokeCustomIsAllowed() {
        if (!this.options.canUseInvokeCustom()) {
            throw new CompilationError("Invoke-custom is unsupported before Android O (--min-api 26)");
        }
    }

    private class ProgramClassDependencyCollector
    extends ProgramClassVisitor {
        private final Set<DexClass> includedClasses;

        ProgramClassDependencyCollector(DexApplication application, DexProgramClass[] includedClasses) {
            super(application);
            this.includedClasses = Sets.newIdentityHashSet();
            Collections.addAll(this.includedClasses, includedClasses);
        }

        @Override
        public void visit(DexType type) {
        }

        @Override
        public void visit(DexClass clazz) {
            if (!this.includedClasses.contains(clazz)) {
                return;
            }
            clazz.addDependencies(FileWriter.this.mixedSectionOffsets);
        }
    }

    private static class MixedSectionOffsets
    extends MixedSectionCollection {
        private static final int NOT_SET = -1;
        private static final int NOT_KNOWN = -2;
        private final Reference2IntMap<DexCode> codes = MixedSectionOffsets.createReference2IntMap();
        private final Object2IntMap<DexDebugInfo> debugInfos = MixedSectionOffsets.createObject2IntMap();
        private final Object2IntMap<DexTypeList> typeLists = MixedSectionOffsets.createObject2IntMap();
        private final Reference2IntMap<DexString> stringData = MixedSectionOffsets.createReference2IntMap();
        private final Object2IntMap<DexAnnotation> annotations = MixedSectionOffsets.createObject2IntMap();
        private final Object2IntMap<DexAnnotationSet> annotationSets = MixedSectionOffsets.createObject2IntMap();
        private final Object2IntMap<DexAnnotationSetRefList> annotationSetRefLists = MixedSectionOffsets.createObject2IntMap();
        private final Object2IntMap<DexAnnotationDirectory> annotationDirectories = MixedSectionOffsets.createObject2IntMap();
        private final Object2IntMap<DexProgramClass> classesWithData = MixedSectionOffsets.createObject2IntMap();
        private final Object2IntMap<DexEncodedArray> encodedArrays = MixedSectionOffsets.createObject2IntMap();
        private final Hashtable<DexProgramClass, DexAnnotationDirectory> clazzToAnnotationDirectory = new Hashtable();

        private MixedSectionOffsets() {
        }

        private static <T> Object2IntMap<T> createObject2IntMap() {
            Object2IntLinkedOpenHashMap result = new Object2IntLinkedOpenHashMap();
            result.defaultReturnValue(-2);
            return result;
        }

        private static <T> Reference2IntMap<T> createReference2IntMap() {
            Reference2IntLinkedOpenHashMap result = new Reference2IntLinkedOpenHashMap();
            result.defaultReturnValue(-2);
            return result;
        }

        private <T> boolean add(Object2IntMap<T> map, T item) {
            if (!map.containsKey(item)) {
                map.put(item, -1);
                return true;
            }
            return false;
        }

        private <T> boolean add(Reference2IntMap<T> map, T item) {
            if (!map.containsKey(item)) {
                map.put(item, -1);
                return true;
            }
            return false;
        }

        @Override
        public boolean add(DexProgramClass aClassWithData) {
            return this.add(this.classesWithData, aClassWithData);
        }

        @Override
        public boolean add(DexEncodedArray encodedArray) {
            return this.add(this.encodedArrays, encodedArray);
        }

        @Override
        public boolean add(DexAnnotationSet annotationSet) {
            if (annotationSet.isEmpty()) {
                return false;
            }
            return this.add(this.annotationSets, annotationSet);
        }

        @Override
        public boolean add(DexCode code) {
            return this.add(this.codes, code);
        }

        @Override
        public boolean add(DexDebugInfo debugInfo) {
            return this.add(this.debugInfos, debugInfo);
        }

        @Override
        public boolean add(DexTypeList typeList) {
            if (typeList.isEmpty()) {
                return false;
            }
            return this.add(this.typeLists, typeList);
        }

        @Override
        public boolean add(DexAnnotationSetRefList annotationSetRefList) {
            if (annotationSetRefList.isEmpty()) {
                return false;
            }
            return this.add(this.annotationSetRefLists, annotationSetRefList);
        }

        @Override
        public boolean add(DexAnnotation annotation) {
            return this.add(this.annotations, annotation);
        }

        @Override
        public boolean setAnnotationsDirectoryForClass(DexProgramClass clazz, DexAnnotationDirectory annotationDirectory) {
            DexAnnotationDirectory previous = this.clazzToAnnotationDirectory.put(clazz, annotationDirectory);
            assert (previous == null);
            return this.add(this.annotationDirectories, annotationDirectory);
        }

        public boolean add(DexString string) {
            return this.add(this.stringData, string);
        }

        public Collection<DexCode> getCodes() {
            return this.codes.keySet();
        }

        public Collection<DexDebugInfo> getDebugInfos() {
            return this.debugInfos.keySet();
        }

        public Collection<DexTypeList> getTypeLists() {
            return this.typeLists.keySet();
        }

        public Collection<DexString> getStringData() {
            return this.stringData.keySet();
        }

        public Collection<DexAnnotation> getAnnotations() {
            return this.annotations.keySet();
        }

        public Collection<DexAnnotationSet> getAnnotationSets() {
            return this.annotationSets.keySet();
        }

        public Collection<DexAnnotationSetRefList> getAnnotationSetRefLists() {
            return this.annotationSetRefLists.keySet();
        }

        public Collection<DexProgramClass> getClassesWithData() {
            return this.classesWithData.keySet();
        }

        public Collection<DexAnnotationDirectory> getAnnotationDirectories() {
            return this.annotationDirectories.keySet();
        }

        public Collection<DexEncodedArray> getEncodedArrays() {
            return this.encodedArrays.keySet();
        }

        private <T> int lookup(T item, Object2IntMap<T> table) {
            if (item == null) {
                return 0;
            }
            int offset = table.getInt(item);
            assert (offset != -1 && offset != -2);
            return offset;
        }

        private <T> int lookup(T item, Reference2IntMap<T> table) {
            if (item == null) {
                return 0;
            }
            int offset = table.getInt(item);
            assert (offset != -1 && offset != -2);
            return offset;
        }

        public int getOffsetFor(DexString item) {
            return this.lookup(item, this.stringData);
        }

        public int getOffsetFor(DexTypeList parameters) {
            if (parameters.isEmpty()) {
                return 0;
            }
            return this.lookup(parameters, this.typeLists);
        }

        public int getOffsetFor(DexProgramClass aClassWithData) {
            return this.lookup(aClassWithData, this.classesWithData);
        }

        public int getOffsetFor(DexEncodedArray encodedArray) {
            return this.lookup(encodedArray, this.encodedArrays);
        }

        public int getOffsetFor(DexDebugInfo debugInfo) {
            return this.lookup(debugInfo, this.debugInfos);
        }

        public int getOffsetForAnnotationsDirectory(DexProgramClass clazz) {
            if (!clazz.hasAnnotations()) {
                return 0;
            }
            int offset = this.annotationDirectories.getInt((Object)this.clazzToAnnotationDirectory.get(clazz));
            assert (offset != -2);
            return offset;
        }

        public int getOffsetFor(DexAnnotation annotation) {
            return this.lookup(annotation, this.annotations);
        }

        public int getOffsetFor(DexAnnotationSet annotationSet) {
            if (annotationSet.isEmpty()) {
                return 0;
            }
            return this.lookup(annotationSet, this.annotationSets);
        }

        public int getOffsetFor(DexAnnotationSetRefList annotationSetRefList) {
            if (annotationSetRefList.isEmpty()) {
                return 0;
            }
            return this.lookup(annotationSetRefList, this.annotationSetRefLists);
        }

        public int getOffsetFor(DexCode code) {
            return this.lookup(code, this.codes);
        }

        private <T> void setOffsetFor(T item, int offset, Map<T, Integer> table) {
            Integer old = table.put(item, offset);
            assert (old != null);
            assert (old <= -1);
        }

        void setOffsetFor(DexDebugInfo debugInfo, int offset) {
            this.setOffsetFor((Object)debugInfo, offset, (Map)this.debugInfos);
        }

        void setOffsetFor(DexCode code, int offset) {
            this.setOffsetFor((Object)code, offset, (Map)this.codes);
        }

        void setOffsetFor(DexTypeList typeList, int offset) {
            assert (offset != 0 && !this.typeLists.isEmpty());
            this.setOffsetFor((Object)typeList, offset, (Map)this.typeLists);
        }

        void setOffsetFor(DexString string, int offset) {
            this.setOffsetFor((Object)string, offset, (Map)this.stringData);
        }

        void setOffsetFor(DexAnnotation annotation, int offset) {
            this.setOffsetFor((Object)annotation, offset, (Map)this.annotations);
        }

        void setOffsetFor(DexAnnotationSet annotationSet, int offset) {
            this.setOffsetFor((Object)annotationSet, offset, (Map)this.annotationSets);
        }

        void setOffsetForAnnotationsDirectory(DexAnnotationDirectory annotationDirectory, int offset) {
            this.setOffsetFor((Object)annotationDirectory, offset, (Map)this.annotationDirectories);
        }

        void setOffsetFor(DexProgramClass aClassWithData, int offset) {
            this.setOffsetFor((Object)aClassWithData, offset, (Map)this.classesWithData);
        }

        void setOffsetFor(DexEncodedArray encodedArray, int offset) {
            this.setOffsetFor((Object)encodedArray, offset, (Map)this.encodedArrays);
        }

        void setOffsetFor(DexAnnotationSetRefList annotationSetRefList, int offset) {
            assert (offset != 0 && !annotationSetRefList.isEmpty());
            this.setOffsetFor((Object)annotationSetRefList, offset, (Map)this.annotationSetRefLists);
        }
    }

    private static class Layout {
        private static final int NOT_SET = -1;
        final int stringIdsOffset;
        final int typeIdsOffset;
        final int protoIdsOffset;
        final int fieldIdsOffset;
        final int methodIdsOffset;
        final int classDefsOffset;
        final int callSiteIdsOffset;
        final int methodHandleIdsOffset;
        final int dataSectionOffset;
        private int codesOffset = -1;
        private int debugInfosOffset = -1;
        private int typeListsOffset = -1;
        private int stringDataOffsets = -1;
        private int annotationsOffset = -1;
        private int annotationSetsOffset = -1;
        private int annotationSetRefListsOffset = -1;
        private int annotationDirectoriesOffset = -1;
        private int classDataOffset = -1;
        private int encodedArrarysOffset = -1;
        private int mapOffset = -1;
        private int endOfFile = -1;

        private Layout(int stringIdsOffset, int typeIdsOffset, int protoIdsOffset, int fieldIdsOffset, int methodIdsOffset, int classDefsOffset, int callSiteIdsOffset, int methodHandleIdsOffset, int dataSectionOffset) {
            this.stringIdsOffset = stringIdsOffset;
            this.typeIdsOffset = typeIdsOffset;
            this.protoIdsOffset = protoIdsOffset;
            this.fieldIdsOffset = fieldIdsOffset;
            this.methodIdsOffset = methodIdsOffset;
            this.classDefsOffset = classDefsOffset;
            this.callSiteIdsOffset = callSiteIdsOffset;
            this.methodHandleIdsOffset = methodHandleIdsOffset;
            this.dataSectionOffset = dataSectionOffset;
            assert (stringIdsOffset <= typeIdsOffset);
            assert (typeIdsOffset <= protoIdsOffset);
            assert (protoIdsOffset <= fieldIdsOffset);
            assert (fieldIdsOffset <= methodIdsOffset);
            assert (methodIdsOffset <= classDefsOffset);
            assert (classDefsOffset <= dataSectionOffset);
            assert (callSiteIdsOffset <= dataSectionOffset);
            assert (methodHandleIdsOffset <= dataSectionOffset);
        }

        static Layout from(ObjectToOffsetMapping mapping) {
            int offset = 0;
            offset = 112;
            int n = offset + mapping.getStrings().length * 4;
            offset = n;
            int n2 = offset + mapping.getTypes().length * 4;
            offset = n2;
            int n3 = offset + mapping.getProtos().length * 12;
            offset = n3;
            int n4 = offset + mapping.getFields().length * 8;
            offset = n4;
            int n5 = offset + mapping.getMethods().length * 8;
            offset = n5;
            int n6 = offset + mapping.getClasses().length * 32;
            offset = n6;
            offset = offset + mapping.getCallSites().length * 4;
            return new Layout(112, n, n2, n3, n4, n5, n6, offset, offset += mapping.getMethodHandles().length * 8);
        }

        int getDataSectionSize() {
            int size = this.getEndOfFile() - this.dataSectionOffset;
            assert (size % 4 == 0);
            return size;
        }

        private boolean isValidOffset(int value, boolean isAligned) {
            return value != -1 && (!isAligned || value % 4 == 0);
        }

        public int getCodesOffset() {
            assert (this.isValidOffset(this.codesOffset, true));
            return this.codesOffset;
        }

        public void setCodesOffset(int codesOffset) {
            assert (this.codesOffset == -1);
            this.codesOffset = codesOffset;
        }

        public int getDebugInfosOffset() {
            assert (this.isValidOffset(this.debugInfosOffset, false));
            return this.debugInfosOffset;
        }

        public void setDebugInfosOffset(int debugInfosOffset) {
            assert (this.debugInfosOffset == -1);
            this.debugInfosOffset = debugInfosOffset;
        }

        public int getTypeListsOffset() {
            assert (this.isValidOffset(this.typeListsOffset, true));
            return this.typeListsOffset;
        }

        public void setTypeListsOffset(int typeListsOffset) {
            assert (this.typeListsOffset == -1);
            this.typeListsOffset = typeListsOffset;
        }

        public int getStringDataOffsets() {
            assert (this.isValidOffset(this.stringDataOffsets, false));
            return this.stringDataOffsets;
        }

        public void setStringDataOffsets(int stringDataOffsets) {
            assert (this.stringDataOffsets == -1);
            this.stringDataOffsets = stringDataOffsets;
        }

        public int getAnnotationsOffset() {
            assert (this.isValidOffset(this.annotationsOffset, false));
            return this.annotationsOffset;
        }

        public void setAnnotationsOffset(int annotationsOffset) {
            assert (this.annotationsOffset == -1);
            this.annotationsOffset = annotationsOffset;
        }

        public int getAnnotationSetsOffset() {
            assert (this.isValidOffset(this.annotationSetsOffset, true));
            return this.annotationSetsOffset;
        }

        public void alreadySetOffset(int ignored) {
        }

        public void setAnnotationSetsOffset(int annotationSetsOffset) {
            assert (this.annotationSetsOffset == -1);
            this.annotationSetsOffset = annotationSetsOffset;
        }

        public int getAnnotationSetRefListsOffset() {
            assert (this.isValidOffset(this.annotationSetRefListsOffset, true));
            return this.annotationSetRefListsOffset;
        }

        public void setAnnotationSetRefListsOffset(int annotationSetRefListsOffset) {
            assert (this.annotationSetRefListsOffset == -1);
            this.annotationSetRefListsOffset = annotationSetRefListsOffset;
        }

        public int getAnnotationDirectoriesOffset() {
            assert (this.isValidOffset(this.annotationDirectoriesOffset, true));
            return this.annotationDirectoriesOffset;
        }

        public void setAnnotationDirectoriesOffset(int annotationDirectoriesOffset) {
            assert (this.annotationDirectoriesOffset == -1);
            this.annotationDirectoriesOffset = annotationDirectoriesOffset;
        }

        public int getClassDataOffset() {
            assert (this.isValidOffset(this.classDataOffset, false));
            return this.classDataOffset;
        }

        public void setClassDataOffset(int classDataOffset) {
            assert (this.classDataOffset == -1);
            this.classDataOffset = classDataOffset;
        }

        public int getEncodedArrarysOffset() {
            assert (this.isValidOffset(this.encodedArrarysOffset, false));
            return this.encodedArrarysOffset;
        }

        public void setEncodedArrarysOffset(int encodedArrarysOffset) {
            assert (this.encodedArrarysOffset == -1);
            this.encodedArrarysOffset = encodedArrarysOffset;
        }

        public int getMapOffset() {
            return this.mapOffset;
        }

        public void setMapOffset(int mapOffset) {
            this.mapOffset = mapOffset;
        }

        public int getEndOfFile() {
            return this.endOfFile;
        }

        public void setEndOfFile(int endOfFile) {
            this.endOfFile = endOfFile;
        }
    }
}

