/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.graph.CachedHashValueDexItem;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.Presorted;
import java.util.Arrays;

public abstract class IndexedDexItem
extends CachedHashValueDexItem
implements Presorted {
    private static final int SORTED_INDEX_UNKNOWN = -1;
    private int sortedIndex = -1;
    private int[] virtualFileIndexes;
    public static final int UNASSOCIATED_VALUE = -2;
    public static final int ASSOCIATED_VALUE = -1;
    public static final int MIN_VALID_VALUE = 0;

    @Override
    public abstract void collectIndexedItems(IndexedItemCollection var1);

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        assert (false);
    }

    public abstract int getOffset(ObjectToOffsetMapping var1);

    public boolean hasVirtualFileData(int virtualFileId) {
        return this.getVirtualFileIndex(virtualFileId) != -2;
    }

    public boolean assignToVirtualFile(int virtualFileId) {
        if (this.hasVirtualFileData(virtualFileId)) {
            return false;
        }
        return this.updateVirtualFileData(virtualFileId);
    }

    private synchronized boolean updateVirtualFileData(int virtualFileId) {
        if (this.virtualFileIndexes == null) {
            int[] fileIndices = new int[virtualFileId + 1];
            Arrays.fill(fileIndices, -2);
            this.virtualFileIndexes = fileIndices;
        }
        if (virtualFileId >= this.virtualFileIndexes.length) {
            int oldLength = this.virtualFileIndexes.length;
            int[] fileIndices = Arrays.copyOf(this.virtualFileIndexes, virtualFileId + 1);
            Arrays.fill(fileIndices, oldLength, virtualFileId + 1, -2);
            this.virtualFileIndexes = fileIndices;
        }
        assert (virtualFileId < this.virtualFileIndexes.length);
        boolean wasAdded = this.virtualFileIndexes[virtualFileId] == -2;
        this.virtualFileIndexes[virtualFileId] = -1;
        return wasAdded;
    }

    public void assignVirtualFileIndex(int virtualFileId, int index) {
        assert (this.virtualFileIndexes != null);
        assert (this.virtualFileIndexes[virtualFileId] < 0);
        this.virtualFileIndexes[virtualFileId] = index;
    }

    public int getVirtualFileIndex(int virtualFileId) {
        if (this.virtualFileIndexes == null) {
            return -2;
        }
        return this.virtualFileIndexes.length > virtualFileId ? this.virtualFileIndexes[virtualFileId] : -2;
    }

    @Override
    public final void setSortedIndex(int sortedIndex) {
        assert (sortedIndex > -1);
        assert (this.sortedIndex == -1);
        this.sortedIndex = sortedIndex;
    }

    @Override
    public final int getSortedIndex() {
        return this.sortedIndex;
    }

    @Override
    public final int sortedCompareTo(int other) {
        assert (this.sortedIndex > -1);
        assert (other > -1);
        return Integer.compare(this.sortedIndex, other);
    }

    @Override
    public void flushCachedValues() {
        super.flushCachedValues();
        this.resetSortedIndex();
    }

    public void resetSortedIndex() {
        this.sortedIndex = -1;
    }
}

