/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.CompilationException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.shaking.FilteredClassPath;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ListUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

abstract class BaseCommand {
    private final boolean printHelp;
    private final boolean printVersion;
    private final AndroidApp app;

    BaseCommand(boolean printHelp, boolean printVersion) {
        this.printHelp = printHelp;
        this.printVersion = printVersion;
        this.app = null;
    }

    BaseCommand(AndroidApp app) {
        assert (app != null);
        this.app = app;
        this.printHelp = false;
        this.printVersion = false;
    }

    public boolean isPrintHelp() {
        return this.printHelp;
    }

    public boolean isPrintVersion() {
        return this.printVersion;
    }

    AndroidApp getInputApp() {
        return this.app;
    }

    abstract InternalOptions getInternalOptions();

    public static abstract class Builder<C extends BaseCommand, B extends Builder<C, B>> {
        private boolean printHelp = false;
        private boolean printVersion = false;
        private final AndroidApp.Builder app;
        protected List<Path> programFiles = new ArrayList<Path>();

        protected Builder() {
            this(AndroidApp.builder(), false);
        }

        protected Builder(boolean ignoreDexInArchive) {
            this(AndroidApp.builder(), ignoreDexInArchive);
        }

        Builder(AndroidApp app, CompilationMode mode) {
            this(AndroidApp.builder(app), false);
        }

        protected Builder(AndroidApp.Builder builder, boolean ignoreDexInArchive) {
            this.app = builder;
            this.app.setIgnoreDexInArchive(ignoreDexInArchive);
        }

        abstract B self();

        public abstract C build() throws CompilationException, IOException;

        AndroidApp.Builder getAppBuilder() {
            return this.app;
        }

        B setVdexAllowed() {
            this.getAppBuilder().setVdexAllowed();
            return this.self();
        }

        public B addProgramFiles(Path ... files) throws IOException {
            this.addProgramFiles(Arrays.asList(files));
            return this.self();
        }

        public B addProgramFiles(Collection<Path> files) throws IOException {
            this.app.addProgramFiles(ListUtils.map(files, FilteredClassPath::unfiltered));
            this.programFiles.addAll(files);
            return this.self();
        }

        public B addLibraryResourceProvider(ClassFileResourceProvider provider) {
            this.getAppBuilder().addLibraryResourceProvider(provider);
            return this.self();
        }

        public B addLibraryFiles(Path ... files) throws IOException {
            this.addLibraryFiles(Arrays.asList(files));
            return this.self();
        }

        public B addLibraryFiles(Collection<Path> files) throws IOException {
            this.app.addLibraryFiles(ListUtils.map(files, FilteredClassPath::unfiltered));
            return this.self();
        }

        public B addClassProgramData(byte[] ... data) {
            this.app.addClassProgramData(data);
            return this.self();
        }

        public B addClassProgramData(Collection<byte[]> data) {
            this.app.addClassProgramData(data);
            return this.self();
        }

        public B addDexProgramData(byte[] ... data) {
            this.app.addDexProgramData(data);
            return this.self();
        }

        public B addDexProgramData(Collection<byte[]> data) {
            this.app.addDexProgramData(data);
            return this.self();
        }

        public B addMainDexListFiles(Path ... files) throws IOException {
            this.app.addMainDexListFiles(files);
            return this.self();
        }

        public B addMainDexListFiles(Collection<Path> files) throws IOException {
            this.app.addMainDexListFiles(files);
            return this.self();
        }

        public B addMainDexClasses(String ... classes) {
            this.app.addMainDexClasses(classes);
            return this.self();
        }

        public B addMainDexClasses(Collection<String> classes) {
            this.app.addMainDexClasses(classes);
            return this.self();
        }

        public boolean isPrintHelp() {
            return this.printHelp;
        }

        public B setPrintHelp(boolean printHelp) {
            this.printHelp = printHelp;
            return this.self();
        }

        public boolean isPrintVersion() {
            return this.printVersion;
        }

        public B setPrintVersion(boolean printVersion) {
            this.printVersion = printVersion;
            return this.self();
        }

        protected void validate() throws CompilationException {
        }
    }
}

