/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCommand;
import com.android.tools.r8.CompilationException;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class ExtractMarker {
    public static void main(String[] args) throws IOException, CompilationException, ExecutionException {
        Command.Builder builder = Command.parse(args);
        Command command = builder.build();
        if (command.isPrintHelp()) {
            System.out.println(Command.USAGE_MESSAGE);
            return;
        }
        try {
            AndroidApp app = command.getInputApp();
            InternalOptions options = new InternalOptions();
            options.skipReadingDexCode = true;
            DexApplication dexApp = new ApplicationReader(app, options, new Timing("ExtractMarker")).read();
            Marker readMarker = dexApp.dexItemFactory.extractMarker();
            if (command.getVerbose()) {
                for (int i = 0; i < command.getProgramFiles().size(); ++i) {
                    if (i != 0) {
                        System.out.print(", ");
                    }
                    System.out.print(command.getProgramFiles().get(i));
                }
                System.out.print(": ");
            }
            if (readMarker == null) {
                System.out.println("D8/R8 marker not found.");
                System.exit(1);
            } else {
                System.out.println(readMarker.toString());
            }
        }
        catch (CompilationError e) {
            System.out.println("Failed to read dex file: '" + e.getMessage() + "'");
            System.exit(0);
        }
    }

    private static class Command
    extends BaseCommand {
        static final String USAGE_MESSAGE = String.join((CharSequence)"\n", ImmutableList.of("Usage: extractmarker [options] <input-files>", " where <input-files> are dex or vdex files", "  --version               # Print the version of r8.", "  --verbose               # More verbose output.", "  --help                  # Print this message."));
        private final List<Path> programFiles;
        private final boolean verbose;

        public static Builder builder() {
            return (Builder)new Builder().setVdexAllowed();
        }

        public static Builder parse(String[] args) throws CompilationException, IOException {
            Builder builder = Command.builder();
            Command.parse(args, builder);
            return builder;
        }

        private static void parse(String[] args, Builder builder) throws CompilationException, IOException {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i].trim();
                if (arg.length() == 0) continue;
                if (arg.equals("--verbose")) {
                    builder.setVerbose(true);
                    continue;
                }
                if (arg.equals("--help")) {
                    builder.setPrintHelp(true);
                    continue;
                }
                if (arg.startsWith("--")) {
                    throw new CompilationException("Unknown option: " + arg);
                }
                builder.addProgramFiles(Paths.get(arg, new String[0]));
            }
        }

        private Command(AndroidApp inputApp, boolean verbose, List<Path> programFiles) {
            super(inputApp);
            this.programFiles = programFiles;
            this.verbose = verbose;
        }

        private Command(boolean printHelp) {
            super(printHelp, false);
            this.verbose = false;
            this.programFiles = ImmutableList.of();
        }

        public List<Path> getProgramFiles() {
            return this.programFiles;
        }

        public boolean getVerbose() {
            return this.verbose;
        }

        @Override
        InternalOptions getInternalOptions() {
            return new InternalOptions();
        }

        public static class Builder
        extends BaseCommand.Builder<Command, Builder> {
            private boolean verbose;

            @Override
            Builder self() {
                return this;
            }

            public Builder setVerbose(boolean verbose) {
                this.verbose = verbose;
                return this.self();
            }

            @Override
            public Command build() throws CompilationException, IOException {
                if (this.isPrintHelp()) {
                    return new Command(this.isPrintHelp());
                }
                this.validate();
                return new Command(this.getAppBuilder().build(), this.verbose, this.programFiles);
            }
        }
    }
}

