/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.compatproguard;

import com.android.tools.r8.CompilationException;
import com.android.tools.r8.R8;
import com.android.tools.r8.R8Command;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.compatproguard.CompatProguardCommandBuilder;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;

public class CompatProguard {
    private static void run(String[] args) throws IOException, CompilationException {
        System.out.println("CompatProguard " + String.join((CharSequence)" ", args));
        CompatProguardOptions options = CompatProguardOptions.parse(args);
        CompatProguardCommandBuilder builder = new CompatProguardCommandBuilder(options.forceProguardCompatibility);
        ((R8Command.Builder)builder.setOutputPath(Paths.get(options.output, new String[0]))).addProguardConfiguration(options.proguardConfig).setMinApiLevel(options.minApi);
        R8.run(builder.build());
    }

    public static void main(String[] args) throws IOException {
        try {
            CompatProguard.run(args);
        }
        catch (CompilationException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    public static class CompatProguardOptions {
        public final String output;
        public final int minApi;
        public final boolean forceProguardCompatibility;
        public final List<String> proguardConfig;

        CompatProguardOptions(List<String> proguardConfig, String output, int minApi, boolean forceProguardCompatibility) {
            this.output = output;
            this.minApi = minApi;
            this.forceProguardCompatibility = forceProguardCompatibility;
            this.proguardConfig = proguardConfig;
        }

        public static CompatProguardOptions parse(String[] args) throws CompilationException {
            String output = null;
            int minApi = 1;
            boolean forceProguardCompatibility = false;
            ImmutableList.Builder builder = ImmutableList.builder();
            if (args.length > 0) {
                StringBuilder currentLine = new StringBuilder(args[0]);
                for (int i = 1; i < args.length; ++i) {
                    String arg = args[i];
                    if (arg.charAt(0) == '-') {
                        if (arg.equals("--min-api")) {
                            minApi = Integer.valueOf(args[++i]);
                            continue;
                        }
                        if (arg.equals("--force-proguard-compatibility")) {
                            forceProguardCompatibility = true;
                            continue;
                        }
                        if (arg.equals("--output")) {
                            output = args[++i];
                            continue;
                        }
                        if (arg.equals("-outjars")) {
                            throw new CompilationException("Proguard argument -outjar is not supported. Use R8 compatible --output flag");
                        }
                        builder.add(currentLine.toString());
                        currentLine = new StringBuilder(arg);
                        continue;
                    }
                    currentLine.append(' ').append(arg);
                }
                builder.add(currentLine.toString());
            }
            return new CompatProguardOptions((List<String>)((Object)builder.build()), output, minApi, forceProguardCompatibility);
        }
    }
}

