/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.LazyLoadedDexApplication;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.ProgramClassCollection;
import com.android.tools.r8.utils.Timing;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;

public class DirectMappedDexApplication
extends DexApplication {
    private final ImmutableMap<DexType, DexLibraryClass> libraryClasses;

    private DirectMappedDexApplication(ClassNameMapper proguardMap, ProgramClassCollection programClasses, ImmutableMap<DexType, DexLibraryClass> libraryClasses, ImmutableSet<DexType> mainDexList, byte[] deadCode, DexItemFactory dexItemFactory, DexString highestSortingString, Timing timing) {
        super(proguardMap, programClasses, mainDexList, deadCode, dexItemFactory, highestSortingString, timing);
        this.libraryClasses = libraryClasses;
    }

    public Collection<DexLibraryClass> libraryClasses() {
        return this.libraryClasses.values();
    }

    @Override
    public DexClass definitionFor(DexType type) {
        Object result = this.programClasses.get(type);
        if (result == null) {
            result = this.libraryClasses.get(type);
        }
        return result;
    }

    public Builder builder() {
        return new Builder(this);
    }

    @Override
    public DirectMappedDexApplication toDirect() {
        return this;
    }

    @Override
    public DirectMappedDexApplication asDirect() {
        return this;
    }

    @Override
    public String toString() {
        return "DexApplication (direct)";
    }

    public static class Builder
    extends DexApplication.Builder<Builder> {
        private Map<DexType, DexLibraryClass> libraryClasses = new IdentityHashMap<DexType, DexLibraryClass>();

        Builder(LazyLoadedDexApplication application) {
            super(application);
            Map<DexType, DexClass> allClasses = application.getFullClassMap();
            Iterables.filter(allClasses.values(), DexLibraryClass.class).forEach(k -> this.libraryClasses.put(k.type, (DexLibraryClass)k));
        }

        private Builder(DirectMappedDexApplication application) {
            super(application);
            this.libraryClasses.putAll(application.libraryClasses);
        }

        @Override
        Builder self() {
            return this;
        }

        @Override
        public DexApplication build() {
            return new DirectMappedDexApplication(this.proguardMap, ProgramClassCollection.create(this.programClasses), ImmutableMap.copyOf(this.libraryClasses), ImmutableSet.copyOf(this.mainDexList), this.deadCode, this.dexItemFactory, this.highestSortingString, this.timing);
        }
    }
}

