/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import java.util.HashSet;
import java.util.Set;

public abstract class ProgramClassVisitor {
    final DexApplication application;
    private final Set<DexItem> visited = new HashSet<DexItem>();

    protected ProgramClassVisitor(DexApplication application) {
        this.application = application;
    }

    private void accept(DexType type) {
        if (type == null || this.visited.contains(type)) {
            return;
        }
        DexProgramClass clazz = this.application.programDefinitionFor(type);
        if (clazz != null) {
            this.accept(clazz);
            return;
        }
        this.visit(type);
        this.visited.add(type);
    }

    private void accept(DexTypeList types) {
        for (DexType type : types.values) {
            this.accept(type);
        }
    }

    private void accept(DexClass clazz) {
        if (this.visited.contains(clazz)) {
            return;
        }
        this.accept(clazz.superType);
        this.accept(clazz.interfaces);
        this.visit(clazz);
        this.visited.add(clazz);
    }

    public void run(DexProgramClass[] classes) {
        for (DexProgramClass clazz : classes) {
            this.accept(clazz);
        }
    }

    public void run() {
        for (DexProgramClass clazz : this.application.classes()) {
            this.accept(clazz);
        }
    }

    public abstract void visit(DexType var1);

    public abstract void visit(DexClass var1);
}

