/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.code.CmpLong;
import com.android.tools.r8.code.CmpgDouble;
import com.android.tools.r8.code.CmpgFloat;
import com.android.tools.r8.code.CmplDouble;
import com.android.tools.r8.code.CmplFloat;
import com.android.tools.r8.code.Format23x;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.code.Binop;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstType;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.MoveType;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.utils.LongInterval;
import com.android.tools.r8.utils.StringUtils;

public class Cmp
extends Binop {
    private final Bias bias;

    public Cmp(NumericType type, Bias bias, Value dest, Value left, Value right) {
        super(type, dest, left, right);
        this.bias = bias;
    }

    @Override
    public boolean isCommutative() {
        return false;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format23x instruction;
        int dest = builder.allocatedRegister(this.outValue, this.getNumber());
        int left = builder.allocatedRegister(this.leftValue(), this.getNumber());
        int right = builder.allocatedRegister(this.rightValue(), this.getNumber());
        switch (this.type) {
            case DOUBLE: {
                assert (this.bias != Bias.NONE);
                if (this.bias == Bias.GT) {
                    instruction = new CmpgDouble(dest, left, right);
                    break;
                }
                assert (this.bias == Bias.LT);
                instruction = new CmplDouble(dest, left, right);
                break;
            }
            case FLOAT: {
                assert (this.bias != Bias.NONE);
                if (this.bias == Bias.GT) {
                    instruction = new CmpgFloat(dest, left, right);
                    break;
                }
                assert (this.bias == Bias.LT);
                instruction = new CmplFloat(dest, left, right);
                break;
            }
            case LONG: {
                assert (this.bias == Bias.NONE);
                instruction = new CmpLong(dest, left, right);
                break;
            }
            default: {
                throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
            }
        }
        builder.add((Instruction)this, instruction);
    }

    private String biasToString(Bias bias) {
        switch (bias) {
            case NONE: {
                return "none";
            }
            case GT: {
                return "gt";
            }
            case LT: {
                return "lt";
            }
        }
        throw new Unreachable("Unexpected bias " + (Object)((Object)bias));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(" (");
        switch (this.type) {
            case DOUBLE: {
                builder.append("double, ");
                builder.append(this.biasToString(this.bias));
                break;
            }
            case FLOAT: {
                builder.append("float, ");
                builder.append(this.biasToString(this.bias));
                break;
            }
            case LONG: {
                builder.append("long");
                break;
            }
            default: {
                throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
            }
        }
        builder.append(")");
        for (int i = builder.length(); i < 20; ++i) {
            builder.append(" ");
        }
        if (this.outValue != null) {
            builder.append(this.outValue);
            builder.append(" <- ");
        }
        StringUtils.append(builder, this.inValues, ", ", StringUtils.BraceType.NONE);
        return builder.toString();
    }

    @Override
    public boolean identicalNonValueParts(Instruction other) {
        return other.asCmp().bias == this.bias;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        return this.bias.ordinal() - other.asCmp().bias.ordinal();
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    private boolean nonOverlapingRanges() {
        return this.type == NumericType.LONG && this.leftValue().hasValueRange() && this.rightValue().hasValueRange() && this.leftValue().getValueRange().doesntOverlapWith(this.rightValue().getValueRange());
    }

    @Override
    public boolean canBeFolded() {
        return this.leftValue().isConstNumber() && this.rightValue().isConstNumber() || this.nonOverlapingRanges();
    }

    @Override
    public ConstInstruction fold(IRCode code) {
        int result;
        assert (this.canBeFolded());
        if (this.type == NumericType.LONG) {
            if (this.leftValue().isConstNumber() && this.rightValue().isConstNumber()) {
                long left = this.leftValue().getConstInstruction().asConstNumber().getLongValue();
                long right = this.rightValue().getConstInstruction().asConstNumber().getLongValue();
                result = Integer.signum(Long.compare(left, right));
            } else {
                assert (this.nonOverlapingRanges());
                LongInterval leftRange = this.leftValue().getValueRange();
                LongInterval rightRange = this.rightValue().getValueRange();
                result = Integer.signum(Long.compare(leftRange.getMin(), rightRange.getMin()));
            }
        } else if (this.type == NumericType.FLOAT) {
            float left = this.leftValue().getConstInstruction().asConstNumber().getFloatValue();
            float right = this.rightValue().getConstInstruction().asConstNumber().getFloatValue();
            result = Float.isNaN(left) || Float.isNaN(right) ? (this.bias == Bias.GT ? 1 : -1) : (int)Math.signum(left - right);
        } else {
            assert (this.type == NumericType.DOUBLE);
            double left = this.leftValue().getConstInstruction().asConstNumber().getDoubleValue();
            double right = this.rightValue().getConstInstruction().asConstNumber().getDoubleValue();
            result = Double.isNaN(left) || Double.isNaN(right) ? (this.bias == Bias.GT ? 1 : -1) : (int)Math.signum(left - right);
        }
        assert (result == -1 || result == 0 || result == 1);
        Value value = code.createValue(MoveType.SINGLE, this.getLocalInfo());
        return new ConstNumber(ConstType.INT, value, result);
    }

    @Override
    public boolean isCmp() {
        return true;
    }

    @Override
    public Cmp asCmp() {
        return this;
    }

    public static enum Bias {
        NONE,
        GT,
        LT;

    }
}

