/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningOracle;
import java.util.List;

public abstract class InvokeMethod
extends Invoke {
    private DexMethod method;

    public InvokeMethod(DexMethod target, Value result, List<Value> arguments) {
        super(result, arguments);
        this.method = target;
    }

    public DexMethod getInvokedMethod() {
        return this.method;
    }

    @Override
    public boolean identicalNonValueParts(Instruction other) {
        return this.method == other.asInvokeMethod().getInvokedMethod();
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        return this.getInvokedMethod().slowCompareTo(other.asInvokeMethod().getInvokedMethod());
    }

    @Override
    public String toString() {
        return super.toString() + "; method: " + this.method.toSourceString();
    }

    @Override
    public boolean isInvokeMethod() {
        return true;
    }

    @Override
    public InvokeMethod asInvokeMethod() {
        return this;
    }

    abstract DexEncodedMethod lookupTarget(AppInfo var1);

    @Override
    public Inliner.Constraint inliningConstraint(AppInfoWithSubtyping info, DexType holder) {
        DexType methodHolder;
        DexClass methodClass;
        if (this.method.holder.isArrayType()) {
            return Inliner.Constraint.ALWAYS;
        }
        DexEncodedMethod target = this.lookupTarget(info);
        if (target != null && (methodClass = info.definitionFor(methodHolder = target.method.holder)) != null) {
            Inliner.Constraint methodConstrain = Inliner.Constraint.deriveConstraint(holder, methodHolder, target.accessFlags, info);
            Inliner.Constraint classConstraint = Inliner.Constraint.deriveConstraint(holder, methodHolder, methodClass.accessFlags, info);
            return Inliner.Constraint.min(methodConstrain, classConstraint);
        }
        return Inliner.Constraint.NEVER;
    }

    public abstract Inliner.InlineAction computeInlining(InliningOracle var1);
}

