/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.ArrayGet;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.optimize.EnumOrdinalMapCollector;
import com.android.tools.r8.ir.optimize.SwitchMapCollector;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.shaking.Enqueuer;

public class SwitchUtils {
    public static EnumSwitchInfo analyzeSwitchOverEnum(Instruction switchInsn, Enqueuer.AppInfoWithLiveness appInfo) {
        Instruction input = switchInsn.inValues().get((int)0).definition;
        if (input == null || !input.isArrayGet()) {
            return null;
        }
        ArrayGet arrayGet = input.asArrayGet();
        Instruction index = arrayGet.index().definition;
        if (index == null || !index.isInvokeVirtual()) {
            return null;
        }
        InvokeVirtual ordinalInvoke = index.asInvokeVirtual();
        DexMethod ordinalMethod = ordinalInvoke.getInvokedMethod();
        DexClass enumClass = appInfo.definitionFor(ordinalMethod.holder);
        DexItemFactory dexItemFactory = appInfo.dexItemFactory;
        if (enumClass == null || !enumClass.accessFlags.isEnum() && enumClass.type != dexItemFactory.enumType || ordinalMethod.name != dexItemFactory.ordinalMethodName || ordinalMethod.proto.returnType != dexItemFactory.intType || !ordinalMethod.proto.parameters.isEmpty()) {
            return null;
        }
        Instruction array = arrayGet.array().definition;
        if (array == null || !array.isStaticGet()) {
            return null;
        }
        StaticGet staticGet = array.asStaticGet();
        Int2ReferenceMap<DexField> indexMap = SwitchMapCollector.getSwitchMapFor(staticGet.getField(), appInfo);
        if (indexMap == null || indexMap.isEmpty()) {
            return null;
        }
        DexType enumTyoe = ((DexField)indexMap.values().iterator().next()).getHolder();
        Reference2IntMap<DexField> ordinalsMap = EnumOrdinalMapCollector.getOrdinalsMapFor(enumTyoe, appInfo);
        if (ordinalsMap == null) {
            return null;
        }
        return new EnumSwitchInfo(enumTyoe, ordinalInvoke, arrayGet, staticGet, indexMap, ordinalsMap);
    }

    public static final class EnumSwitchInfo {
        public final DexType enumClass;
        public final Instruction ordinalInvoke;
        public final Instruction arrayGet;
        public final Instruction staticGet;
        public final Int2ReferenceMap<DexField> indexMap;
        public final Reference2IntMap ordinalsMap;

        private EnumSwitchInfo(DexType enumClass, Instruction ordinalInvoke, Instruction arrayGet, Instruction staticGet, Int2ReferenceMap<DexField> indexMap, Reference2IntMap ordinalsMap) {
            this.enumClass = enumClass;
            this.ordinalInvoke = ordinalInvoke;
            this.arrayGet = arrayGet;
            this.staticGet = staticGet;
            this.indexMap = indexMap;
            this.ordinalsMap = ordinalsMap;
        }
    }
}

