/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.ImmutableBiMap;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.naming.ClassNaming;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.utils.DescriptorUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Map;
import java.util.function.Consumer;

public class ClassNameMapper {
    private final ImmutableMap<String, ClassNaming> classNameMappings;
    private ImmutableBiMap<String, String> nameMapping;
    private Hashtable<MemberNaming.Signature, MemberNaming.Signature> signatureMap = new Hashtable();

    ClassNameMapper(Map<String, ClassNaming> classNameMappings) {
        this.classNameMappings = ImmutableMap.copyOf(classNameMappings);
    }

    private MemberNaming.Signature canonicalizeSignature(MemberNaming.Signature signature) {
        MemberNaming.Signature result = this.signatureMap.get(signature);
        if (result != null) {
            return result;
        }
        this.signatureMap.put(signature, signature);
        return signature;
    }

    public MemberNaming.MethodSignature getRenamedMethodSignature(DexMethod method) {
        DexType[] parameters = method.proto.parameters.values;
        String[] parameterTypes = new String[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameterTypes[i] = this.deobfuscateType(parameters[i].toDescriptorString());
        }
        String returnType = this.deobfuscateType(method.proto.returnType.toDescriptorString());
        MemberNaming.MethodSignature signature = new MemberNaming.MethodSignature(method.name.toString(), returnType, parameterTypes);
        return (MemberNaming.MethodSignature)this.canonicalizeSignature(signature);
    }

    public MemberNaming.Signature getRenamedFieldSignature(DexField field) {
        String type = this.deobfuscateType(field.type.toDescriptorString());
        return this.canonicalizeSignature(new MemberNaming.FieldSignature(field.name.toString(), type));
    }

    public String deobfuscateClassName(String name) {
        ClassNaming classNaming = this.classNameMappings.get(name);
        if (classNaming == null) {
            return name;
        }
        return classNaming.originalName;
    }

    private String deobfuscateType(String asString) {
        return DescriptorUtils.descriptorToJavaType(asString, this);
    }

    public ClassNaming getClassNaming(String name) {
        return this.classNameMappings.get(name);
    }

    public void write(Writer writer, boolean collapseRanges) throws IOException {
        for (ClassNaming naming : this.classNameMappings.values()) {
            naming.write(writer, collapseRanges);
        }
    }

    public void forAllClassNamings(Consumer<ClassNaming> consumer) {
        this.classNameMappings.values().forEach(consumer);
    }

    public String toString() {
        try {
            StringWriter writer = new StringWriter();
            this.write(writer, false);
            return writer.toString();
        }
        catch (IOException e) {
            return e.toString();
        }
    }

    public BiMap<String, String> getObfuscatedToOriginalMapping() {
        if (this.nameMapping == null) {
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            for (String name : this.classNameMappings.keySet()) {
                builder.put(name, this.classNameMappings.get((Object)name).originalName);
            }
            this.nameMapping = builder.build();
        }
        return this.nameMapping;
    }

    public boolean equals(Object o) {
        return o instanceof ClassNameMapper && this.classNameMappings.equals(((ClassNameMapper)o).classNameMappings);
    }

    public int hashCode() {
        return 31 * this.classNameMappings.hashCode();
    }

    public String originalNameOf(IndexedDexItem item) {
        if (item instanceof DexField) {
            return this.lookupName(this.getRenamedFieldSignature((DexField)item), ((DexField)item).clazz);
        }
        if (item instanceof DexMethod) {
            return this.lookupName(this.getRenamedMethodSignature((DexMethod)item), ((DexMethod)item).holder);
        }
        if (item instanceof DexType) {
            return DescriptorUtils.descriptorToJavaType(((DexType)item).toDescriptorString(), this);
        }
        return item.toString();
    }

    private String lookupName(MemberNaming.Signature signature, DexType clazz) {
        String decoded = DescriptorUtils.descriptorToJavaType(clazz.descriptor.toString());
        ClassNaming classNaming = this.getClassNaming(decoded);
        if (classNaming == null) {
            return decoded + " " + signature.toString();
        }
        MemberNaming memberNaming = classNaming.lookup(signature);
        if (memberNaming == null) {
            return classNaming.originalName + " " + signature.toString();
        }
        return classNaming.originalName + " " + memberNaming.signature.toString();
    }

    public MemberNaming.Signature originalSignatureOf(DexMethod method) {
        String decoded = DescriptorUtils.descriptorToJavaType(method.holder.descriptor.toString());
        MemberNaming.MethodSignature memberSignature = this.getRenamedMethodSignature(method);
        ClassNaming classNaming = this.getClassNaming(decoded);
        if (classNaming == null) {
            return memberSignature;
        }
        MemberNaming memberNaming = classNaming.lookup(memberSignature);
        if (memberNaming == null) {
            return memberSignature;
        }
        return memberNaming.signature;
    }

    public String originalNameOf(DexType clazz) {
        return this.deobfuscateType(clazz.descriptor.toString());
    }
}

