/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class MemberNaming {
    private static final int UNDEFINED_START_NUMBER = -1;
    final Signature signature;
    final Signature renamedSignature;
    public final List<InlineInformation> inlineInformation = new LinkedList<InlineInformation>();
    public final Range topLevelRange;
    private int collapsedStartLineNumber = -1;
    private int originalStartLineNumber = -1;
    public static final Range fakeZeroRange = new Range(0, 0);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MemberNaming)) {
            return false;
        }
        MemberNaming that = (MemberNaming)o;
        return this.signature.equals(that.signature) && this.renamedSignature.equals(that.renamedSignature) && this.topLevelRange.equals(that.topLevelRange) && this.inlineInformation.equals(that.inlineInformation);
    }

    public int hashCode() {
        int result = this.signature.hashCode();
        result = 31 * result + this.renamedSignature.hashCode();
        result = 31 * result + this.inlineInformation.hashCode();
        result = 31 * result + this.topLevelRange.hashCode();
        return result;
    }

    MemberNaming(Signature signature, String renamedName, Range inlinedLineRange) {
        this.signature = signature;
        this.renamedSignature = signature.asRenamed(renamedName);
        this.topLevelRange = inlinedLineRange == null ? fakeZeroRange : inlinedLineRange;
    }

    public void addInliningRange(Range inlinedRange, Signature signature, Range originalRange) {
        this.inlineInformation.add(new InlineInformation(inlinedRange, originalRange, signature));
    }

    public List<Range> getInlineRanges() {
        ArrayList<Range> inlineRanges = new ArrayList<Range>();
        for (InlineInformation information : this.inlineInformation) {
            if (!information.isActualInlining()) continue;
            inlineRanges.add(information.inlinedRange);
        }
        return inlineRanges;
    }

    public Signature getOriginalSignature() {
        return this.signature;
    }

    public String getRenamedName() {
        return this.renamedSignature.name;
    }

    public void setCollapsedStartLineNumber(int value) {
        assert (this.collapsedStartLineNumber == -1);
        this.collapsedStartLineNumber = value;
    }

    public boolean isMethodNaming() {
        return this.signature.kind() == Signature.SignatureKind.METHOD;
    }

    private int getCollapsedStartLineNumber() {
        return this.collapsedStartLineNumber;
    }

    protected void write(Writer writer, boolean collapseRanges, boolean indent) throws IOException {
        int rangeCounter;
        if (indent) {
            writer.append("    ");
        }
        int n = rangeCounter = collapseRanges ? this.getCollapsedStartLineNumber() : -1;
        if (this.topLevelRange != fakeZeroRange || rangeCounter != -1) {
            if (collapseRanges) {
                if (rangeCounter != -1) {
                    String rangeString = Integer.toString(rangeCounter);
                    writer.append(rangeString).append(":").append(rangeString).append(":");
                } else {
                    rangeCounter = 0;
                }
            } else {
                writer.append(this.topLevelRange.toString());
                writer.append(':');
            }
        } else if (collapseRanges) {
            rangeCounter = 0;
        }
        this.signature.write(writer);
        if (this.originalStartLineNumber != -1) {
            String originalSourceLineString = Integer.toString(this.originalStartLineNumber);
            writer.append(':').append(originalSourceLineString).append(':').append(originalSourceLineString);
        }
        writer.append(" -> ");
        writer.append(this.renamedSignature.name);
        writer.append("\n");
        for (InlineInformation information : this.inlineInformation) {
            assert (!collapseRanges || rangeCounter >= 0);
            if (collapseRanges && information.isActualInlining()) {
                ++rangeCounter;
            }
            information.write(writer, rangeCounter, indent);
        }
    }

    public String toString() {
        try {
            StringWriter writer = new StringWriter();
            this.write(writer, false, false);
            return writer.toString();
        }
        catch (IOException e) {
            return e.toString();
        }
    }

    public void setOriginalStartLineNumber(int originalStartLineNumber) {
        assert (this.originalStartLineNumber == -1);
        this.originalStartLineNumber = originalStartLineNumber;
    }

    public static class SingleLineRange
    extends Range {
        public SingleLineRange(int fromAndTo) {
            super(fromAndTo, fromAndTo);
        }

        @Override
        public boolean isSingle() {
            return true;
        }

        @Override
        public String toString() {
            return Integer.toString(this.from);
        }
    }

    public static class Range {
        public final int from;
        public final int to;

        Range(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public boolean contains(int value) {
            return value >= this.from && value <= this.to;
        }

        public boolean isSingle() {
            return false;
        }

        public String toString() {
            return this.from + ":" + this.to;
        }

        public static String toCollapsedString(int value) {
            return value + ":" + value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Range)) {
                return false;
            }
            Range range = (Range)o;
            return this.from == range.from && this.to == range.to;
        }

        public int hashCode() {
            int result = this.from;
            result = 31 * result + this.to;
            return result;
        }
    }

    public class InlineInformation {
        static final int DO_NOT_COLLAPSE = -1;
        public final Range inlinedRange;
        public final Range originalRange;
        public final Signature signature;

        public InlineInformation(Range inlinedRange, Range originalRange, Signature signature) {
            this.inlinedRange = inlinedRange;
            this.originalRange = originalRange;
            this.signature = signature;
        }

        public boolean isActualInlining() {
            return !(this.originalRange instanceof SingleLineRange);
        }

        public void write(Writer writer, int collapsedRange, boolean indent) throws IOException {
            if (indent) {
                writer.append("    ");
            }
            if (collapsedRange == -1) {
                writer.append(this.inlinedRange.toString());
            } else {
                writer.append(Range.toCollapsedString(collapsedRange));
            }
            writer.append(":");
            this.signature.write(writer);
            if (this.originalRange != null) {
                writer.append(':').append(this.originalRange.toString());
            }
            writer.append(" -> ").append(MemberNaming.this.renamedSignature.name);
            writer.append("\n");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof InlineInformation)) {
                return false;
            }
            InlineInformation that = (InlineInformation)o;
            return this.inlinedRange.equals(that.inlinedRange) && (this.originalRange == null && that.originalRange == null || this.originalRange.equals(that.originalRange)) && this.signature.equals(that.signature);
        }

        public int hashCode() {
            int result = this.inlinedRange.hashCode();
            result = 31 * result + this.originalRange.hashCode();
            result = 31 * result + this.signature.hashCode();
            return result;
        }
    }

    public static class MethodSignature
    extends Signature {
        public final String type;
        public final String[] parameters;

        public MethodSignature(String name, String type, String[] parameters) {
            super(name);
            this.type = type;
            this.parameters = parameters;
        }

        public static MethodSignature fromDexMethod(DexMethod method) {
            String[] paramNames = new String[method.getArity()];
            DexType[] values = method.proto.parameters.values;
            for (int i = 0; i < values.length; ++i) {
                paramNames[i] = values[i].toSourceString();
            }
            return new MethodSignature(method.name.toSourceString(), method.proto.returnType.toSourceString(), paramNames);
        }

        public static MethodSignature initializer(String[] parameters) {
            return new MethodSignature("<init>", "void", parameters);
        }

        @Override
        Signature asRenamed(String renamedName) {
            return new MethodSignature(renamedName, this.type, this.parameters);
        }

        @Override
        public Signature.SignatureKind kind() {
            return Signature.SignatureKind.METHOD;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodSignature)) {
                return false;
            }
            MethodSignature that = (MethodSignature)o;
            return this.type.equals(that.type) && this.name.equals(that.name) && Arrays.equals(this.parameters, that.parameters);
        }

        @Override
        public int hashCode() {
            return (this.type.hashCode() * 17 + this.name.hashCode()) * 31 + Arrays.hashCode(this.parameters);
        }

        @Override
        void write(Writer writer) throws IOException {
            writer.append(this.type).append(' ').append(this.name).append('(');
            for (int i = 0; i < this.parameters.length; ++i) {
                writer.append(this.parameters[i]);
                if (i >= this.parameters.length - 1) continue;
                writer.append(',');
            }
            writer.append(')');
        }
    }

    public static class FieldSignature
    extends Signature {
        public final String type;

        public FieldSignature(String name, String type) {
            super(name);
            this.type = type;
        }

        public static FieldSignature fromDexField(DexField field) {
            return new FieldSignature(field.name.toSourceString(), field.type.toSourceString());
        }

        @Override
        Signature asRenamed(String renamedName) {
            return new FieldSignature(renamedName, this.type);
        }

        @Override
        public Signature.SignatureKind kind() {
            return Signature.SignatureKind.FIELD;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldSignature)) {
                return false;
            }
            FieldSignature that = (FieldSignature)o;
            return this.name.equals(that.name) && this.type.equals(that.type);
        }

        @Override
        public int hashCode() {
            return this.name.hashCode() * 31 + this.type.hashCode();
        }

        @Override
        public String toString() {
            return this.type + " " + this.name;
        }

        @Override
        void write(Writer writer) throws IOException {
            writer.append(this.type);
            writer.append(' ');
            writer.append(this.name);
        }
    }

    public static abstract class Signature {
        public final String name;

        protected Signature(String name) {
            this.name = name;
        }

        abstract Signature asRenamed(String var1);

        public abstract SignatureKind kind();

        public abstract boolean equals(Object var1);

        public abstract int hashCode();

        abstract void write(Writer var1) throws IOException;

        public String toString() {
            try {
                StringWriter writer = new StringWriter();
                this.write(writer);
                return writer.toString();
            }
            catch (IOException e) {
                return e.toString();
            }
        }

        static enum SignatureKind {
            METHOD,
            FIELD;

        }
    }
}

