/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.InvalidDebugInfoException;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.shaking.ProguardConfiguration;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.DefaultDiagnosticsHandler;
import com.android.tools.r8.utils.OffOrAuto;
import com.android.tools.r8.utils.OutputMode;
import com.android.tools.r8.utils.StringDiagnostic;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public class InternalOptions {
    public final DexItemFactory itemFactory;
    public final ProguardConfiguration proguardConfiguration;
    public final int NOT_SPECIFIED = -1;
    public boolean printTimes = false;
    public boolean skipDebugLineNumberOpt = false;
    public boolean skipClassMerging = true;
    public boolean inlineAccessors = true;
    public boolean removeSwitchMaps = true;
    public final OutlineOptions outline = new OutlineOptions();
    public int numberOfThreads = -1;
    public boolean useSmaliSyntax = false;
    public boolean verbose = false;
    public boolean quiet = false;
    private boolean hasMarker = false;
    private Marker marker;
    public List<String> methodsFilter = ImmutableList.of();
    public int minApiLevel = AndroidApiLevel.getDefault().getLevel();
    public boolean intermediate = false;
    public List<String> logArgumentsFilter = ImmutableList.of();
    public boolean enableDesugaring = true;
    public OffOrAuto interfaceMethodDesugaring = OffOrAuto.Auto;
    public OffOrAuto tryWithResourcesDesugaring = OffOrAuto.Auto;
    public OutputMode outputMode = OutputMode.Indexed;
    public boolean useTreeShaking = true;
    public boolean useDiscardedChecker = true;
    public boolean printCfg = false;
    public String printCfgFile;
    public Path printMainDexListFile;
    public boolean ignoreMissingClasses = false;
    public boolean forceProguardCompatibility = false;
    public boolean skipMinification = false;
    public boolean disableAssertions = true;
    public boolean debugKeepRules = false;
    public final KeepAttributeOptions keepAttributes = new KeepAttributeOptions();
    public boolean allowParameterName = false;
    public boolean debug = false;
    public boolean singleStepDebug = false;
    public final TestingOptions testing = new TestingOptions();
    public ImmutableList<ProguardConfigurationRule> mainDexKeepRules = ImmutableList.of();
    public boolean minimalMainDex;
    public String warningInvalidParameterAnnotations = null;
    public boolean warningMissingEnclosingMember = false;
    public int warningInvalidDebugInfoCount = 0;
    public boolean skipReadingDexCode = false;
    public Path proguardMapOutput = null;
    public DiagnosticsHandler diagnosticsHandler = new DefaultDiagnosticsHandler();

    public InternalOptions() {
        this.itemFactory = new DexItemFactory();
        this.proguardConfiguration = ProguardConfiguration.defaultConfiguration(this.itemFactory);
    }

    public InternalOptions(DexItemFactory factory) {
        assert (factory != null);
        this.itemFactory = factory;
        this.proguardConfiguration = ProguardConfiguration.defaultConfiguration(this.itemFactory);
    }

    public InternalOptions(ProguardConfiguration proguardConfiguration) {
        assert (proguardConfiguration != null);
        this.proguardConfiguration = proguardConfiguration;
        this.itemFactory = proguardConfiguration.getDexItemFactory();
    }

    public boolean hasMarker() {
        return this.hasMarker;
    }

    public void setMarker(Marker marker) {
        this.hasMarker = true;
        this.marker = marker;
    }

    public Marker getMarker() {
        assert (this.hasMarker());
        return this.marker;
    }

    public void warningInvalidDebugInfo(DexEncodedMethod method, InvalidDebugInfoException e) {
        ++this.warningInvalidDebugInfoCount;
    }

    public boolean printWarnings() {
        boolean printed = false;
        boolean printOutdatedToolchain = false;
        if (this.warningInvalidParameterAnnotations != null) {
            this.diagnosticsHandler.warning(new StringDiagnostic(this.warningInvalidParameterAnnotations));
            printed = true;
        }
        if (this.warningInvalidDebugInfoCount > 0) {
            this.diagnosticsHandler.warning(new StringDiagnostic("Stripped invalid locals information from " + this.warningInvalidDebugInfoCount + (this.warningInvalidDebugInfoCount == 1 ? " method." : " methods.")));
            printed = true;
            printOutdatedToolchain = true;
        }
        if (this.warningMissingEnclosingMember) {
            this.diagnosticsHandler.warning(new StringDiagnostic("InnerClass annotations are missing corresponding EnclosingMember annotations. Such InnerClass annotations are ignored."));
            printed = true;
            printOutdatedToolchain = true;
        }
        if (printOutdatedToolchain) {
            this.diagnosticsHandler.warning(new StringDiagnostic("Some warnings are typically a sign of using an outdated Java toolchain. To fix, recompile the source with an updated toolchain."));
        }
        return printed;
    }

    public boolean hasMethodsFilter() {
        return this.methodsFilter.size() > 0;
    }

    public boolean methodMatchesFilter(DexEncodedMethod method) {
        if (!this.hasMethodsFilter()) {
            return true;
        }
        String qualifiedName = method.qualifiedName();
        return this.methodsFilter.indexOf(qualifiedName) >= 0;
    }

    public boolean methodMatchesLogArgumentsFilter(DexEncodedMethod method) {
        if (this.logArgumentsFilter.size() == 0) {
            return false;
        }
        String qualifiedName = method.qualifiedName();
        return this.logArgumentsFilter.indexOf(qualifiedName) >= 0;
    }

    public boolean canUseInvokePolymorphic() {
        return this.minApiLevel >= AndroidApiLevel.O.getLevel();
    }

    public boolean canUseConstantMethodHandle() {
        return this.minApiLevel >= AndroidApiLevel.P.getLevel();
    }

    public boolean canUseInvokeCustom() {
        return this.minApiLevel >= AndroidApiLevel.O.getLevel();
    }

    public boolean canUseDefaultAndStaticInterfaceMethods() {
        return this.minApiLevel >= AndroidApiLevel.N.getLevel();
    }

    public boolean canUsePrivateInterfaceMethods() {
        return this.minApiLevel >= AndroidApiLevel.N.getLevel();
    }

    public boolean canUseMultidex() {
        return this.intermediate || this.minApiLevel >= AndroidApiLevel.L.getLevel();
    }

    public boolean canUseLongCompareAndObjectsNonNull() {
        return this.minApiLevel >= AndroidApiLevel.K.getLevel();
    }

    public boolean canUseSuppressedExceptions() {
        return this.minApiLevel >= AndroidApiLevel.K.getLevel();
    }

    public boolean canUseParameterNameAnnotations() {
        return this.minApiLevel >= AndroidApiLevel.O.getLevel();
    }

    public static class KeepAttributeOptions {
        public static final String SOURCE_FILE = "SourceFile";
        public static final String SOURCE_DIR = "SourceDir";
        public static final String INNER_CLASSES = "InnerClasses";
        public static final String ENCLOSING_METHOD = "EnclosingMethod";
        public static final String SIGNATURE = "Signature";
        public static final String EXCEPTIONS = "Exceptions";
        public static final String SOURCE_DEBUG_EXTENSION = "SourceDebugExtension";
        public static final String RUNTIME_VISIBLE_ANNOTATIONS = "RuntimeVisibleAnnotations";
        public static final String RUNTIME_INVISIBLE_ANNOTATIONS = "RuntimeInvisibleAnnotations";
        public static final String RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS = "RuntimeVisibleParameterAnnotations";
        public static final String RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS = "RuntimeInvisibleParameterAnnotations";
        public static final String RUNTIME_VISIBLE_TYPE_ANNOTATIONS = "RuntimeVisibleTypeAnnotations";
        public static final String RUNTIME_INVISIBLE_TYPE_ANNOTATIONS = "RuntimeInvisibleTypeAnnotations";
        public static final String ANNOTATION_DEFAULT = "AnnotationDefault";
        public static final List<String> KEEP_ALL = ImmutableList.of("*");
        public boolean sourceFile = false;
        public boolean sourceDir = false;
        public boolean innerClasses = false;
        public boolean enclosingMethod = false;
        public boolean signature = false;
        public boolean exceptions = false;
        public boolean sourceDebugExtension = false;
        public boolean runtimeVisibleAnnotations = false;
        public boolean runtimeInvisibleAnnotations = false;
        public boolean runtimeVisibleParameterAnnotations = false;
        public boolean runtimeInvisibleParamterAnnotations = false;
        public boolean runtimeVisibleTypeAnnotations = false;
        public boolean runtimeInvisibleTypeAnnotations = false;
        public boolean annotationDefault = false;

        private KeepAttributeOptions() {
        }

        public static KeepAttributeOptions filterOnlySignatures() {
            KeepAttributeOptions result = new KeepAttributeOptions();
            result.applyPatterns(KEEP_ALL);
            result.signature = false;
            return result;
        }

        private boolean update(boolean previous, String text, List<String> patterns) {
            for (String pattern : patterns) {
                if (previous) {
                    return true;
                }
                if (pattern.charAt(0) == '!') {
                    if (!this.matches(pattern, 1, text, 0)) continue;
                    break;
                }
                previous = this.matches(pattern, 0, text, 0);
            }
            return previous;
        }

        private boolean matches(String pattern, int patternPos, String text, int textPos) {
            while (patternPos < pattern.length()) {
                char next;
                if ((next = pattern.charAt(patternPos++)) == '*') {
                    while (textPos < text.length()) {
                        if (!this.matches(pattern, patternPos, text, textPos++)) continue;
                        return true;
                    }
                    return patternPos >= pattern.length();
                }
                if (textPos >= text.length() || text.charAt(textPos) != next) {
                    return false;
                }
                ++textPos;
            }
            return textPos == text.length();
        }

        public void applyPatterns(List<String> patterns) {
            this.sourceFile = this.update(this.sourceFile, SOURCE_FILE, patterns);
            this.sourceDir = this.update(this.sourceDir, SOURCE_DIR, patterns);
            this.innerClasses = this.update(this.innerClasses, INNER_CLASSES, patterns);
            this.enclosingMethod = this.update(this.enclosingMethod, ENCLOSING_METHOD, patterns);
            this.signature = this.update(this.signature, SIGNATURE, patterns);
            this.exceptions = this.update(this.exceptions, EXCEPTIONS, patterns);
            this.sourceDebugExtension = this.update(this.sourceDebugExtension, SOURCE_DEBUG_EXTENSION, patterns);
            this.runtimeVisibleAnnotations = this.update(this.runtimeVisibleAnnotations, RUNTIME_VISIBLE_ANNOTATIONS, patterns);
            this.runtimeInvisibleAnnotations = this.update(this.runtimeInvisibleAnnotations, RUNTIME_INVISIBLE_ANNOTATIONS, patterns);
            this.runtimeVisibleParameterAnnotations = this.update(this.runtimeVisibleParameterAnnotations, RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS, patterns);
            this.runtimeInvisibleParamterAnnotations = this.update(this.runtimeInvisibleParamterAnnotations, RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS, patterns);
            this.runtimeVisibleTypeAnnotations = this.update(this.runtimeVisibleTypeAnnotations, RUNTIME_VISIBLE_TYPE_ANNOTATIONS, patterns);
            this.runtimeInvisibleTypeAnnotations = this.update(this.runtimeInvisibleTypeAnnotations, RUNTIME_INVISIBLE_TYPE_ANNOTATIONS, patterns);
            this.annotationDefault = this.update(this.annotationDefault, ANNOTATION_DEFAULT, patterns);
        }

        public void ensureValid() {
            if (this.innerClasses && !this.enclosingMethod) {
                throw new CompilationError("Attribute InnerClasses requires EnclosingMethod attribute. Check -keepattributes directive.");
            }
            if (!this.innerClasses && this.enclosingMethod) {
                throw new CompilationError("Attribute EnclosingMethod requires InnerClasses attribute. Check -keepattributes directive.");
            }
            if (this.signature && !this.innerClasses) {
                throw new CompilationError("Attribute Signature requires InnerClasses attribute. Check -keepattributes directive.");
            }
        }
    }

    public static class TestingOptions {
        public Function<Set<DexEncodedMethod>, Set<DexEncodedMethod>> irOrdering = Function.identity();
        public boolean invertConditionals = false;
    }

    public static class OutlineOptions {
        public boolean enabled = true;
        public static final String className = "r8.GeneratedOutlineSupport";
        public String methodPrefix = "outline";
        public int minSize = 3;
        public int maxSize = 99;
        public int threshold = 20;
    }

    public static enum PackageObfuscationMode {
        NONE,
        REPACKAGE,
        FLATTEN;

    }
}

