/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.Resource;
import com.android.tools.r8.com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class PreloadedClassFileProvider
implements ClassFileResourceProvider {
    private final Map<String, byte[]> content;

    private PreloadedClassFileProvider(Map<String, byte[]> content) {
        this.content = content;
    }

    @Override
    public Set<String> getClassDescriptors() {
        return Sets.newHashSet(this.content.keySet());
    }

    @Override
    public Resource getResource(String descriptor) {
        byte[] bytes = this.content.get(descriptor);
        if (bytes == null) {
            return null;
        }
        return Resource.fromBytes(Resource.Kind.CLASSFILE, bytes, Collections.singleton(descriptor));
    }

    public static ClassFileResourceProvider fromClassData(String descriptor, byte[] data) {
        Builder builder = PreloadedClassFileProvider.builder();
        builder.addResource(descriptor, data);
        return builder.build();
    }

    public String toString() {
        return this.content.size() + " preloaded resources";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Map<String, byte[]> content = new HashMap<String, byte[]>();

        private Builder() {
        }

        public Builder addResource(String descriptor, byte[] bytes) {
            assert (this.content != null);
            assert (descriptor != null);
            assert (bytes != null);
            assert (!this.content.containsKey(descriptor));
            this.content.put(descriptor, bytes);
            return this;
        }

        public PreloadedClassFileProvider build() {
            assert (this.content != null);
            PreloadedClassFileProvider provider = new PreloadedClassFileProvider(this.content);
            this.content = null;
            return provider;
        }
    }
}

