/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.utils.InternalOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ThreadUtils {
    public static <T> List<T> awaitFutures(Collection<? extends Future<? extends T>> futures) throws ExecutionException {
        ArrayList<T> result = new ArrayList<T>(futures.size());
        for (Future<T> f : futures) {
            try {
                result.add(f.get());
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while waiting for future.", e);
            }
        }
        return result;
    }

    public static ExecutorService getExecutorService(int threads) {
        return Executors.newWorkStealingPool(threads);
    }

    public static ExecutorService getExecutorService(InternalOptions options) {
        int threads = options.numberOfThreads;
        if (threads == options.NOT_SPECIFIED) {
            threads = Integer.min(Runtime.getRuntime().availableProcessors(), 16) / 2;
        }
        return ThreadUtils.getExecutorService(threads);
    }
}

