/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;

public class CfConstNumber
extends CfInstruction {
    private final long value;
    private final ValueType type;

    public CfConstNumber(long value, ValueType type) {
        this.value = value;
        this.type = type;
    }

    @Override
    public void write(MethodVisitor visitor) {
        switch (this.type) {
            case INT: {
                visitor.visitLdcInsn((int)this.value);
                break;
            }
            case LONG: {
                visitor.visitLdcInsn(this.value);
                break;
            }
            case FLOAT: {
                visitor.visitLdcInsn(Float.valueOf(Float.intBitsToFloat((int)this.value)));
                break;
            }
            case DOUBLE: {
                visitor.visitLdcInsn(Double.longBitsToDouble(this.value));
                break;
            }
            default: {
                throw new Unreachable("Non supported type in cf backend: " + (Object)((Object)this.type));
            }
        }
    }
}

