/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCommand;
import com.android.tools.r8.CompilationException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.OutputSink;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.DefaultDiagnosticsHandler;
import com.android.tools.r8.utils.FileSystemOutputSink;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.IgnoreContentsOutputSink;
import com.android.tools.r8.utils.OutputMode;
import java.io.IOException;
import java.nio.file.Path;

abstract class BaseCompilerCommand
extends BaseCommand {
    private final Path outputPath;
    private final OutputMode outputMode;
    private final CompilationMode mode;
    private final int minApiLevel;
    private final DiagnosticsHandler diagnosticsHandler;
    private final boolean enableDesugaring;
    private OutputSink outputSink;

    BaseCompilerCommand(boolean printHelp, boolean printVersion) {
        super(printHelp, printVersion);
        this.outputPath = null;
        this.outputMode = OutputMode.Indexed;
        this.mode = null;
        this.minApiLevel = 0;
        this.diagnosticsHandler = new DefaultDiagnosticsHandler();
        this.enableDesugaring = true;
    }

    BaseCompilerCommand(AndroidApp app, Path outputPath, OutputMode outputMode, CompilationMode mode, int minApiLevel, DiagnosticsHandler diagnosticsHandler, boolean enableDesugaring) {
        super(app);
        assert (mode != null);
        assert (minApiLevel > 0);
        this.outputPath = outputPath;
        this.outputMode = outputMode;
        this.mode = mode;
        this.minApiLevel = minApiLevel;
        this.diagnosticsHandler = diagnosticsHandler;
        this.enableDesugaring = enableDesugaring;
    }

    public Path getOutputPath() {
        return this.outputPath;
    }

    public CompilationMode getMode() {
        return this.mode;
    }

    public int getMinApiLevel() {
        return this.minApiLevel;
    }

    public OutputMode getOutputMode() {
        return this.outputMode;
    }

    public DiagnosticsHandler getDiagnosticsHandler() {
        return this.diagnosticsHandler;
    }

    private OutputSink createOutputSink() throws IOException {
        if (this.outputPath == null) {
            return new IgnoreContentsOutputSink();
        }
        return FileSystemOutputSink.create(this.outputPath, this.getInternalOptions());
    }

    public OutputSink getOutputSink() throws IOException {
        if (this.outputSink == null) {
            this.outputSink = this.createOutputSink();
        }
        return this.outputSink;
    }

    public boolean getEnableDesugaring() {
        return this.enableDesugaring;
    }

    public static abstract class Builder<C extends BaseCompilerCommand, B extends Builder<C, B>>
    extends BaseCommand.Builder<C, B> {
        private Path outputPath = null;
        private OutputMode outputMode = OutputMode.Indexed;
        private CompilationMode mode;
        private int minApiLevel = AndroidApiLevel.getDefault().getLevel();
        private DiagnosticsHandler diagnosticsHandler = new DefaultDiagnosticsHandler();
        private boolean enableDesugaring = true;

        protected Builder(CompilationMode mode) {
            this(mode, false, AndroidApp.builder());
        }

        protected Builder(CompilationMode mode, boolean ignoreDexInArchive) {
            this(mode, ignoreDexInArchive, AndroidApp.builder());
        }

        Builder(CompilationMode mode, AndroidApp app) {
            this(mode, false, AndroidApp.builder(app));
        }

        private Builder(CompilationMode mode, boolean ignoreDexInArchive, AndroidApp.Builder builder) {
            super(builder, ignoreDexInArchive);
            assert (mode != null);
            this.mode = mode;
        }

        public CompilationMode getMode() {
            return this.mode;
        }

        public B setMode(CompilationMode mode) {
            assert (mode != null);
            this.mode = mode;
            return (B)((Builder)this.self());
        }

        public Path getOutputPath() {
            return this.outputPath;
        }

        public OutputMode getOutputMode() {
            return this.outputMode;
        }

        public B setOutputPath(Path outputPath) {
            this.outputPath = outputPath;
            return (B)((Builder)this.self());
        }

        public B setOutputMode(OutputMode outputMode) {
            this.outputMode = outputMode;
            return (B)((Builder)this.self());
        }

        public int getMinApiLevel() {
            return this.minApiLevel;
        }

        public B setMinApiLevel(int minApiLevel) {
            assert (minApiLevel > 0);
            this.minApiLevel = minApiLevel;
            return (B)((Builder)this.self());
        }

        public DiagnosticsHandler getDiagnosticsHandler() {
            return this.diagnosticsHandler;
        }

        public B setDiagnosticsHandler(DiagnosticsHandler diagnosticsHandler) {
            this.diagnosticsHandler = diagnosticsHandler;
            return (B)((Builder)this.self());
        }

        public B setEnableDesugaring(boolean enableDesugaring) {
            this.enableDesugaring = enableDesugaring;
            return (B)((Builder)this.self());
        }

        public boolean getEnableDesugaring() {
            return this.enableDesugaring;
        }

        @Override
        protected void validate() throws CompilationException {
            super.validate();
            if (this.getAppBuilder().hasMainDexList() && this.outputMode == OutputMode.FilePerInputClass) {
                throw new CompilationException("Option --main-dex-list cannot be used with --file-per-class");
            }
            FileUtils.validateOutputFile(this.outputPath);
        }
    }
}

