/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.Descriptor;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DirectMappedDexApplication;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.KeyedDexItem;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.shaking.Enqueuer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;

public class AppInfo {
    public final DexApplication app;
    public final DexItemFactory dexItemFactory;
    private final ConcurrentHashMap<DexType, Map<Descriptor<?, ?>, KeyedDexItem<?>>> definitions = new ConcurrentHashMap();

    public AppInfo(DexApplication application) {
        this.app = application;
        this.dexItemFactory = this.app.dexItemFactory;
    }

    protected AppInfo(AppInfo previous) {
        this.app = previous.app;
        this.dexItemFactory = this.app.dexItemFactory;
        this.definitions.putAll(previous.definitions);
    }

    protected AppInfo(DirectMappedDexApplication application, GraphLense lense) {
        this(application);
    }

    private Map<Descriptor<?, ?>, KeyedDexItem<?>> computeDefinitions(DexType type) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        DexClass clazz = this.app.definitionFor(type);
        if (clazz != null) {
            clazz.forEachMethod(method -> builder.put(method.getKey(), method));
            clazz.forEachField(field -> builder.put(field.getKey(), field));
        }
        return builder.build();
    }

    public Iterable<DexProgramClass> classes() {
        return this.app.classes();
    }

    public DexClass definitionFor(DexType type) {
        return this.app.definitionFor(type);
    }

    public DexEncodedMethod definitionFor(DexMethod method) {
        return (DexEncodedMethod)this.getDefinitions(method.getHolder()).get(method);
    }

    public DexEncodedField definitionFor(DexField field) {
        return (DexEncodedField)this.getDefinitions(field.getHolder()).get(field);
    }

    private Map<Descriptor<?, ?>, KeyedDexItem<?>> getDefinitions(DexType type) {
        Map<Descriptor<?, ?>, KeyedDexItem<?>> typeDefinitions = this.definitions.get(type);
        if (typeDefinitions != null) {
            return typeDefinitions;
        }
        typeDefinitions = this.computeDefinitions(type);
        Map<Descriptor<?, ?>, KeyedDexItem<?>> existing = this.definitions.putIfAbsent(type, typeDefinitions);
        return existing != null ? existing : typeDefinitions;
    }

    private DexEncodedMethod lookupDirectStaticOrConstructorTarget(DexMethod method) {
        assert (method.holder.isClassType());
        return this.lookupTargetAlongSuperChain(method.holder, method, DexClass::findDirectTarget);
    }

    public DexEncodedMethod lookupStaticTarget(DexMethod method) {
        DexEncodedMethod target = this.lookupDirectStaticOrConstructorTarget(method);
        return target == null || target.accessFlags.isStatic() ? target : null;
    }

    public DexEncodedMethod lookupDirectTarget(DexMethod method) {
        DexEncodedMethod target = this.lookupDirectStaticOrConstructorTarget(method);
        return target == null || !target.accessFlags.isStatic() ? target : null;
    }

    public DexEncodedMethod lookupVirtualTarget(DexType type, DexMethod method) {
        assert (type.isClassType());
        DexEncodedMethod result = this.lookupTargetAlongSuperChain(type, method, DexClass::findVirtualTarget);
        if (result != null) {
            return result;
        }
        return this.lookupTargetAlongInterfaceChain(type, method, (dexClass, dexMethod) -> {
            DexEncodedMethod virtualTarget = dexClass.findVirtualTarget((DexMethod)dexMethod);
            return virtualTarget != null && virtualTarget.getCode() != null ? virtualTarget : null;
        });
    }

    public DexEncodedMethod lookupVirtualDefinition(DexType type, DexMethod method) {
        assert (type.isClassType());
        DexEncodedMethod result = this.lookupTargetAlongSuperChain(type, method, DexClass::findVirtualTarget);
        if (result != null) {
            return result;
        }
        return this.lookupTargetAlongInterfaceChain(type, method, DexClass::findVirtualTarget);
    }

    public DexEncodedField lookupInstanceTarget(DexType type, DexField field) {
        assert (type.isClassType());
        return this.lookupTargetAlongSuperChain(type, field, DexClass::findInstanceTarget);
    }

    public DexEncodedField lookupStaticTarget(DexType type, DexField field) {
        assert (type.isClassType());
        DexEncodedField target = this.lookupTargetAlongSuperChain(type, field, DexClass::findStaticTarget);
        if (target == null) {
            target = this.lookupTargetAlongInterfaceChain(type, field, DexClass::findStaticTarget);
        }
        return target;
    }

    private <S extends DexItem, T extends Descriptor<S, T>> S lookupTargetAlongSuperChain(DexType type, T desc, BiFunction<DexClass, T, S> lookup) {
        assert (type != null);
        DexClass holder = this.definitionFor(type);
        while (holder != null) {
            DexItem result = (DexItem)lookup.apply(holder, (DexClass)((Object)desc));
            if (result != null) {
                return (S)result;
            }
            if (holder.superType == null) {
                return null;
            }
            holder = this.definitionFor(holder.superType);
        }
        return null;
    }

    private <S extends DexItem, T extends Descriptor<S, T>> S lookupTargetAlongSuperAndInterfaceChain(DexType type, T desc, BiFunction<DexClass, T, S> lookup) {
        DexClass holder = this.definitionFor(type);
        if (holder == null) {
            return null;
        }
        DexItem result = (DexItem)lookup.apply(holder, (DexClass)((Object)desc));
        if (result != null) {
            return (S)result;
        }
        if (holder.superType != null && (result = this.lookupTargetAlongSuperAndInterfaceChain(holder.superType, desc, lookup)) != null) {
            return (S)result;
        }
        for (DexType iface : holder.interfaces.values) {
            result = this.lookupTargetAlongSuperAndInterfaceChain(iface, desc, lookup);
            if (result == null) continue;
            return (S)result;
        }
        return null;
    }

    private boolean isDefaultMethod(DexItem dexItem) {
        return dexItem != null && dexItem instanceof DexEncodedMethod && !((DexEncodedMethod)dexItem).accessFlags.isStatic() && ((DexEncodedMethod)dexItem).getCode() != null;
    }

    private boolean isSuperInterfaceOf(DexType interface1, DexType interface2) {
        assert (this.definitionFor(interface1).isInterface());
        DexClass holder = this.definitionFor(interface2);
        assert (holder.isInterface());
        for (DexType iface : holder.interfaces.values) {
            if (iface != interface1 && !this.isSuperInterfaceOf(interface1, iface)) continue;
            return true;
        }
        return false;
    }

    private <S extends DexItem> S resolveAmbiguousResult(S previousResult, S newResult) {
        if (previousResult != null && previousResult != newResult && this.isDefaultMethod(previousResult) && this.isDefaultMethod(newResult)) {
            DexEncodedMethod previousMethod = (DexEncodedMethod)previousResult;
            DexEncodedMethod newMethod = (DexEncodedMethod)newResult;
            if (this.isSuperInterfaceOf(previousMethod.method.getHolder(), newMethod.method.getHolder())) {
                return newResult;
            }
            if (this.isSuperInterfaceOf(newMethod.method.getHolder(), previousMethod.method.getHolder())) {
                return previousResult;
            }
            throw new CompilationError("Duplicate default methods named " + previousResult.toSourceString() + " are inherited from the types " + previousMethod.method.holder.getName() + " and " + newMethod.method.holder.getName());
        }
        return previousResult != null ? previousResult : newResult;
    }

    private <S extends DexItem, T extends Descriptor<S, T>> S lookupTargetAlongInterfaceChain(DexType type, T desc, BiFunction<DexClass, T, S> lookup) {
        S localResult;
        DexClass holder = this.definitionFor(type);
        if (holder == null) {
            return null;
        }
        Object result = null;
        for (DexType iface : holder.interfaces.values) {
            S localResult2 = this.lookupTargetAlongSuperAndInterfaceChain(iface, desc, lookup);
            if (localResult2 == null) continue;
            result = this.resolveAmbiguousResult((S)result, localResult2);
        }
        if (holder.superType != null && (localResult = this.lookupTargetAlongInterfaceChain(holder.superType, desc, lookup)) != null) {
            result = this.resolveAmbiguousResult((S)result, localResult);
        }
        return result;
    }

    public DexEncodedMethod lookup(Invoke.Type type, DexMethod target) {
        DexEncodedMethod definition;
        DexType holder = target.getHolder();
        if (!holder.isClassType()) {
            return null;
        }
        if (type == Invoke.Type.VIRTUAL || type == Invoke.Type.INTERFACE) {
            definition = this.lookupVirtualDefinition(holder, target);
        } else if (type == Invoke.Type.DIRECT) {
            definition = this.lookupDirectTarget(target);
        } else if (type == Invoke.Type.STATIC) {
            definition = this.lookupStaticTarget(target);
        } else if (type == Invoke.Type.SUPER) {
            definition = this.lookupVirtualTarget(holder, target);
        } else {
            return null;
        }
        return definition;
    }

    public boolean hasSubtyping() {
        return false;
    }

    public AppInfoWithSubtyping withSubtyping() {
        return null;
    }

    public boolean hasLiveness() {
        return false;
    }

    public Enqueuer.AppInfoWithLiveness withLiveness() {
        return null;
    }

    public void registerNewType(DexType newType, DexType superType) {
    }

    public boolean isInMainDexList(DexType type) {
        return this.app.mainDexList.contains(type);
    }

    public List<DexClass> getSuperTypeClasses(DexType type) {
        DexClass clazz;
        ArrayList<DexClass> result = new ArrayList<DexClass>();
        while ((clazz = this.definitionFor(type)) != null) {
            result.add(clazz);
            type = clazz.superType;
            if (type != null) continue;
        }
        return result;
    }
}

