/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.utils.StringUtils;
import java.util.TreeSet;

public class DexDebugEntry {
    public final int address;
    public final int line;
    public final DexString sourceFile;
    public final boolean prologueEnd;
    public final boolean epilogueBegin;
    public final ImmutableMap<Integer, DebugLocalInfo> locals;

    public DexDebugEntry(int address, int line, DexString sourceFile, boolean prologueEnd, boolean epilogueBegin, ImmutableMap<Integer, DebugLocalInfo> locals) {
        this.address = address;
        this.line = line;
        this.sourceFile = sourceFile;
        this.prologueEnd = prologueEnd;
        this.epilogueBegin = epilogueBegin;
        this.locals = locals;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean withPcPrefix) {
        StringBuilder builder = new StringBuilder();
        if (withPcPrefix) {
            builder.append("pc ");
        }
        builder.append(StringUtils.hexString(this.address, 2));
        builder.append(", line ").append(this.line);
        if (this.sourceFile != null) {
            builder.append(", file ").append(this.sourceFile);
        }
        if (this.prologueEnd) {
            builder.append(", prologue_end = true");
        }
        if (this.epilogueBegin) {
            builder.append(", epilogue_begin = true");
        }
        if (!this.locals.isEmpty()) {
            builder.append(", locals: [");
            TreeSet keys = new TreeSet(this.locals.keySet());
            boolean first = true;
            for (Integer register : keys) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(register).append(" -> ").append(this.locals.get(register));
            }
            builder.append("]");
        }
        return builder.toString();
    }
}

