/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringUtils;

public class DebugLocalsChange
extends Instruction {
    private final Int2ReferenceMap<DebugLocalInfo> ending;
    private final Int2ReferenceMap<DebugLocalInfo> starting;

    public DebugLocalsChange(Int2ReferenceMap<DebugLocalInfo> ending, Int2ReferenceMap<DebugLocalInfo> starting) {
        super(null);
        assert (!ending.isEmpty() || !starting.isEmpty());
        this.ending = ending;
        this.starting = starting;
        super.setPosition(Position.none());
    }

    @Override
    public void setPosition(Position position) {
        throw new Unreachable();
    }

    public Int2ReferenceMap<DebugLocalInfo> getEnding() {
        return this.ending;
    }

    public Int2ReferenceMap<DebugLocalInfo> getStarting() {
        return this.starting;
    }

    @Override
    public boolean isDebugLocalsChange() {
        return true;
    }

    @Override
    public DebugLocalsChange asDebugLocalsChange() {
        return this;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        builder.addNop(this);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        assert (other.isDebugLocalsChange());
        DebugLocalsChange o = (DebugLocalsChange)other;
        return DebugLocalInfo.localsInfoMapsEqual(this.ending, o.ending) && DebugLocalInfo.localsInfoMapsEqual(this.starting, o.starting);
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        assert (other.isDebugLocalsChange());
        return 0;
    }

    @Override
    public int maxInValueRegister() {
        throw new Unreachable();
    }

    @Override
    public int maxOutValueRegister() {
        throw new Unreachable();
    }

    @Override
    public boolean canBeDeadCode(IRCode code, InternalOptions options) {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("ending: ");
        StringUtils.append(builder, this.ending.int2ReferenceEntrySet());
        builder.append(", starting: ");
        StringUtils.append(builder, this.starting.int2ReferenceEntrySet());
        return builder.toString();
    }

    @Override
    public Inliner.Constraint inliningConstraint(AppInfoWithSubtyping info, DexType holder) {
        return Inliner.Constraint.ALWAYS;
    }

    public void apply(Int2ReferenceMap<DebugLocalInfo> locals) {
        for (Int2ReferenceMap.Entry entry : this.getEnding().int2ReferenceEntrySet()) {
            assert (locals.get(entry.getIntKey()) == entry.getValue());
            locals.remove(entry.getIntKey());
        }
        for (Int2ReferenceMap.Entry entry : this.getStarting().int2ReferenceEntrySet()) {
            assert (!locals.containsKey(entry.getIntKey()));
            locals.put(entry.getIntKey(), (DebugLocalInfo)entry.getValue());
        }
    }
}

