/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.graph.DexString;
import java.util.Objects;

public class Position {
    private static final Position NO_POSITION = new Position(-1, null, false);
    public final int line;
    public final DexString file;
    public final boolean synthetic;

    public Position(int line, DexString file) {
        this(line, file, false);
        assert (line >= 0);
    }

    private Position(int line, DexString file, boolean synthetic) {
        this.line = line;
        this.file = file;
        this.synthetic = synthetic;
    }

    public static Position synthetic(int line) {
        return new Position(line, null, true);
    }

    public static Position none() {
        return NO_POSITION;
    }

    public boolean isNone() {
        return this == NO_POSITION;
    }

    public boolean isSome() {
        return this != NO_POSITION;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Position) {
            Position o = (Position)other;
            return !this.isNone() && this.line == o.line && this.file == o.file;
        }
        return false;
    }

    public int hashCode() {
        int result = this.line;
        result = 31 * result + Objects.hashCode(this.file);
        result = 31 * result + (this.synthetic ? 1 : 0);
        return result;
    }

    public String toString() {
        if (this.isNone()) {
            return "--";
        }
        StringBuilder builder = new StringBuilder();
        if (this.file != null) {
            builder.append(this.file).append(":");
        }
        builder.append(this.line);
        return builder.toString();
    }
}

