/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.ClassKind;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.desugar.LambdaRewriter;
import com.android.tools.r8.utils.ClassMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Supplier;

public class ProgramClassCollection
extends ClassMap<DexProgramClass> {
    public static ProgramClassCollection create(List<DexProgramClass> classes) {
        IdentityHashMap<DexType, Supplier<DexProgramClass>> map = new IdentityHashMap<DexType, Supplier<DexProgramClass>>();
        for (DexProgramClass clazz : classes) {
            map.merge(clazz.type, clazz, (a, b) -> ProgramClassCollection.resolveClassConflictImpl((DexProgramClass)a.get(), (DexProgramClass)b.get()));
        }
        return new ProgramClassCollection(map);
    }

    private ProgramClassCollection(IdentityHashMap<DexType, Supplier<DexProgramClass>> classes) {
        super(classes, null);
    }

    @Override
    public String toString() {
        return "program classes: " + super.toString();
    }

    @Override
    DexProgramClass resolveClassConflict(DexProgramClass a, DexProgramClass b) {
        return ProgramClassCollection.resolveClassConflictImpl(a, b);
    }

    @Override
    Supplier<DexProgramClass> getTransparentSupplier(DexProgramClass clazz) {
        return clazz;
    }

    @Override
    ClassKind getClassKind() {
        return ClassKind.PROGRAM;
    }

    private static DexProgramClass resolveClassConflictImpl(DexProgramClass a, DexProgramClass b) {
        if (a.originatesFromDexResource() && b.originatesFromDexResource() && a.accessFlags.isSynthetic() && b.accessFlags.isSynthetic() && LambdaRewriter.hasLambdaClassPrefix(a.type) && LambdaRewriter.hasLambdaClassPrefix(b.type)) {
            return a;
        }
        throw new CompilationError("Program type already present: " + a.type.toSourceString());
    }
}

