/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.ClassFileEntry;
import com.android.builder.dexing.DexArchiveBuilder;
import com.android.builder.dexing.DexArchiveBuilderException;
import com.android.builder.dexing.r8.ClassFileProviderFactory;
import com.android.tools.r8.ApiLevelException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.utils.OutputMode;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import java.util.stream.Stream;

final class D8DexArchiveBuilder
extends DexArchiveBuilder {
    private static final Logger LOGGER = Logger.getLogger(D8DexArchiveBuilder.class.getName());
    private static final String INVOKE_CUSTOM = "Invoke-customs are only supported starting with Android O";
    private final int minSdkVersion;
    private final CompilationMode compilationMode;
    private final List<Path> bootClasspath;
    private final List<Path> classpath;
    private final ClassFileProviderFactory classFileProviderFactory;
    private final boolean desugaring;

    public D8DexArchiveBuilder(int minSdkVersion, boolean isDebuggable, List<Path> bootClasspath, List<Path> classpath, ClassFileProviderFactory classFileProviderFactory, boolean desugaring) {
        this.minSdkVersion = minSdkVersion;
        this.compilationMode = isDebuggable ? CompilationMode.DEBUG : CompilationMode.RELEASE;
        this.bootClasspath = bootClasspath;
        this.classpath = classpath;
        this.classFileProviderFactory = classFileProviderFactory;
        this.desugaring = desugaring;
    }

    @Override
    public void convert(Stream<ClassFileEntry> input, Path output, boolean isIncremental) throws DexArchiveBuilderException {
        try (ClassFileProviderFactory.Handler factory = this.classFileProviderFactory.open();){
            Iterator data = input.map(D8DexArchiveBuilder::readAllBytes).iterator();
            if (!data.hasNext()) {
                return;
            }
            OutputMode outputMode = isIncremental ? OutputMode.FilePerInputClass : OutputMode.Indexed;
            D8Command.Builder builder = (D8Command.Builder)((D8Command.Builder)((D8Command.Builder)D8Command.builder().setMode(this.compilationMode)).setMinApiLevel(this.minSdkVersion)).setIntermediate(true).setOutputMode(outputMode);
            if (this.desugaring) {
                for (Path entry : this.bootClasspath) {
                    builder.addLibraryResourceProvider(factory.getProvider(entry));
                }
                for (Path entry : this.classpath) {
                    builder.addClasspathResourceProvider(factory.getProvider(entry));
                }
                builder.setEnableDesugaring(true);
            } else {
                builder.setEnableDesugaring(false);
            }
            while (data.hasNext()) {
                builder.addClassProgramData(new byte[][]{(byte[])data.next()});
            }
            builder.setOutputPath(output);
            D8.run(builder.build(), (ExecutorService)MoreExecutors.newDirectExecutorService());
        }
        catch (Throwable e) {
            throw this.getExceptionToRethrow(e);
        }
    }

    private static byte[] readAllBytes(ClassFileEntry entry) {
        try {
            return entry.readAllBytes();
        }
        catch (IOException ex) {
            throw new DexArchiveBuilderException(ex);
        }
    }

    private DexArchiveBuilderException getExceptionToRethrow(Throwable t) {
        StringBuilder msg = new StringBuilder();
        msg.append("Error while dexing.");
        msg.append(System.lineSeparator());
        if (t instanceof ApiLevelException && t.getMessage().startsWith(INVOKE_CUSTOM)) {
            msg.append("The dependency contains Java 8 bytecode. Please enable desugaring by adding the following to build.gradle\nandroid {\n    compileOptions {\n        sourceCompatibility 1.8\n        targetCompatibility 1.8\n    }\n}\nSee https://developer.android.com/studio/write/java8-support.html for details. Alternatively, increase the minSdkVersion to 26 or above.\n");
        }
        return new DexArchiveBuilderException(msg.toString(), t);
    }
}

