/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.code.OrInt;
import com.android.tools.r8.code.OrInt2Addr;
import com.android.tools.r8.code.OrIntLit16;
import com.android.tools.r8.code.OrIntLit8;
import com.android.tools.r8.code.OrLong;
import com.android.tools.r8.code.OrLong2Addr;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.LogicalBinop;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.Value;

public class Or
extends LogicalBinop {
    public Or(NumericType type, Value dest, Value left, Value right) {
        super(type, dest, left, right);
    }

    @Override
    public boolean isOr() {
        return true;
    }

    @Override
    public Or asOr() {
        return this;
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public com.android.tools.r8.code.Instruction CreateInt(int dest, int left, int right) {
        return new OrInt(dest, left, right);
    }

    @Override
    public com.android.tools.r8.code.Instruction CreateLong(int dest, int left, int right) {
        assert (dest != left + 1);
        assert (dest != right + 1);
        return new OrLong(dest, left, right);
    }

    @Override
    public com.android.tools.r8.code.Instruction CreateInt2Addr(int left, int right) {
        return new OrInt2Addr(left, right);
    }

    @Override
    public com.android.tools.r8.code.Instruction CreateLong2Addr(int left, int right) {
        return new OrLong2Addr(left, right);
    }

    @Override
    public com.android.tools.r8.code.Instruction CreateIntLit8(int dest, int left, int constant) {
        return new OrIntLit8(dest, left, constant);
    }

    @Override
    public com.android.tools.r8.code.Instruction CreateIntLit16(int dest, int left, int constant) {
        return new OrIntLit16(dest, left, constant);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.asOr().type == this.type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        return this.type.ordinal() - other.asOr().type.ordinal();
    }

    @Override
    int foldIntegers(int left, int right) {
        return left | right;
    }

    @Override
    long foldLongs(long left, long right) {
        return left | right;
    }
}

