/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.OutputSink;
import com.android.tools.r8.Resource;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.ForwardingOutputSink;
import com.android.tools.r8.utils.IgnoreContentsOutputSink;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public class AndroidAppOutputSink
extends ForwardingOutputSink {
    private final AndroidApp.Builder builder = AndroidApp.builder();
    private final TreeMap<String, DescriptorsWithContents> dexFilesWithPrimary = new TreeMap();
    private final TreeMap<Integer, DescriptorsWithContents> dexFilesWithId = new TreeMap();
    private final List<DescriptorsWithContents> classFiles = new ArrayList<DescriptorsWithContents>();
    private boolean closed = false;

    public AndroidAppOutputSink(OutputSink forwardTo) {
        super(forwardTo);
    }

    public AndroidAppOutputSink() {
        super(new IgnoreContentsOutputSink());
    }

    @Override
    public synchronized void writeDexFile(byte[] contents, Set<String> classDescriptors, int fileId) throws IOException {
        assert (this.dexFilesWithPrimary.isEmpty() && this.classFiles.isEmpty());
        this.dexFilesWithId.put(fileId, new DescriptorsWithContents(classDescriptors, contents));
        super.writeDexFile(contents, classDescriptors, fileId);
    }

    @Override
    public synchronized void writeDexFile(byte[] contents, Set<String> classDescriptors, String primaryClassName) throws IOException {
        assert (this.dexFilesWithId.isEmpty() && this.classFiles.isEmpty());
        this.dexFilesWithPrimary.put(primaryClassName, new DescriptorsWithContents(classDescriptors, contents));
        super.writeDexFile(contents, classDescriptors, primaryClassName);
    }

    @Override
    public synchronized void writeClassFile(byte[] contents, Set<String> classDescriptors, String primaryClassName) throws IOException {
        assert (this.dexFilesWithPrimary.isEmpty() && this.dexFilesWithId.isEmpty());
        this.classFiles.add(new DescriptorsWithContents(classDescriptors, contents));
        super.writeClassFile(contents, classDescriptors, primaryClassName);
    }

    @Override
    public void writePrintUsedInformation(byte[] contents) throws IOException {
        this.builder.setDeadCode(contents);
        super.writePrintUsedInformation(contents);
    }

    @Override
    public void writeProguardMapFile(byte[] contents) throws IOException {
        this.builder.setProguardMapData(contents);
        super.writeProguardMapFile(contents);
    }

    @Override
    public void writeProguardSeedsFile(byte[] contents) throws IOException {
        this.builder.setProguardSeedsData(contents);
        super.writeProguardSeedsFile(contents);
    }

    @Override
    public void writeMainDexListFile(byte[] contents) throws IOException {
        this.builder.setMainDexListOutputData(contents);
        super.writeMainDexListFile(contents);
    }

    @Override
    public void close() throws IOException {
        assert (!this.closed);
        if (!this.dexFilesWithPrimary.isEmpty()) {
            assert (this.dexFilesWithId.isEmpty() && this.classFiles.isEmpty());
            this.dexFilesWithPrimary.forEach((v, d) -> this.builder.addDexProgramData(d.contents, d.descriptors, (String)v));
        } else if (!this.dexFilesWithId.isEmpty()) {
            assert (this.dexFilesWithPrimary.isEmpty() && this.classFiles.isEmpty());
            this.dexFilesWithId.forEach((v, d) -> this.builder.addDexProgramData(d.contents, d.descriptors));
        } else if (!this.classFiles.isEmpty()) {
            assert (this.dexFilesWithPrimary.isEmpty() && this.dexFilesWithId.isEmpty());
            this.classFiles.forEach(d -> this.builder.addClassProgramData(d.contents, Resource.Origin.unknown(), d.descriptors));
        }
        this.closed = true;
        super.close();
    }

    public AndroidApp build() {
        assert (this.closed);
        return this.builder.build();
    }

    private static class DescriptorsWithContents {
        final Set<String> descriptors;
        final byte[] contents;

        private DescriptorsWithContents(Set<String> descriptors, byte[] contents) {
            this.descriptors = descriptors;
            this.contents = contents;
        }
    }
}

