/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class VersionProperties {
    private static final String VERSION_CODE_KEY = "version-file.version.code";
    private static final String SHA_KEY = "version.sha";
    private static final String RELEASER_KEY = "releaser";
    private static final String RESOURCE_NAME = "r8-version.properties";
    private String codeBase;
    private String releaser;

    public VersionProperties(ClassLoader loader) throws IOException {
        try (InputStream resourceStream = loader.getResourceAsStream(RESOURCE_NAME);){
            if (resourceStream == null) {
                throw new FileNotFoundException(RESOURCE_NAME);
            }
            this.initWithInputStream(resourceStream);
        }
    }

    private void initWithInputStream(InputStream is) throws IOException {
        Properties prop = new Properties();
        prop.load(is);
        long versionFileVersion = Long.parseLong(prop.getProperty(VERSION_CODE_KEY));
        assert (versionFileVersion >= 1L);
        this.codeBase = prop.getProperty(SHA_KEY);
        this.releaser = prop.getProperty(RELEASER_KEY);
    }

    public String getDescription() {
        if (this.codeBase != null && !this.codeBase.trim().isEmpty()) {
            return "build " + this.codeBase + (this.releaser != null ? " from " + this.releaser : "");
        }
        return "eng build" + (this.releaser != null ? " from " + this.releaser : "");
    }

    public String toString() {
        return this.codeBase + " from " + this.releaser;
    }
}

