/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.compatdexbuilder;

import com.android.tools.r8.CompilationException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.D8Output;
import com.android.tools.r8.Resource;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.compatdexbuilder.CompatDexBuilderCommandBuilder;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.ThreadUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class CompatDexBuilder {
    private String input = null;
    private String output = null;
    private int numberOfThreads = 8;
    private boolean noLocals = false;

    public static void main(String[] args) throws IOException, InterruptedException, ExecutionException {
        new CompatDexBuilder().run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(String[] args) throws IOException, InterruptedException, ExecutionException {
        System.out.println("CompatDexBuilder " + String.join((CharSequence)" ", args));
        ArrayList<String> flags = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("@")) {
                flags.addAll(Files.readAllLines(Paths.get(arg.substring(1), new String[0])));
                continue;
            }
            flags.add(arg);
        }
        block41: for (int i = 0; i < flags.size(); ++i) {
            String flag = (String)flags.get(i);
            if (flag.startsWith("--positions")) continue;
            if (flag.startsWith("--num-threads=")) {
                this.numberOfThreads = Integer.parseInt(flag.substring("--num-threads=".length()));
            }
            switch (flag) {
                case "--input_jar": {
                    this.input = (String)flags.get(++i);
                    continue block41;
                }
                case "--output_zip": {
                    this.output = (String)flags.get(++i);
                    continue block41;
                }
                case "--verify-dex-file": 
                case "--no-verify-dex-file": 
                case "--show_flags": 
                case "--no-optimize": 
                case "--nooptimize": 
                case "--help": {
                    continue block41;
                }
                case "--nolocals": {
                    this.noLocals = true;
                    continue block41;
                }
                default: {
                    System.err.println("Unsupported option: " + flag);
                    System.exit(1);
                }
            }
        }
        if (this.input == null) {
            System.err.println("No input jar specified");
            System.exit(1);
        }
        if (this.output == null) {
            System.err.println("No output jar specified");
            System.exit(1);
        }
        ExecutorService executor = ThreadUtils.getExecutorService(this.numberOfThreads);
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(Paths.get(this.output, new String[0]), new OpenOption[0]));){
            ArrayList<ZipEntry> toDex = new ArrayList<ZipEntry>();
            try (ZipFile zipFile = new ZipFile(this.input);){
                int i;
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().endsWith(".class")) {
                        InputStream stream = zipFile.getInputStream(entry);
                        Throwable throwable = null;
                        try {
                            CompatDexBuilder.addEntry(entry.getName(), stream, entry.getTime(), out);
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (stream != null) {
                                CompatDexBuilder.$closeResource(throwable, stream);
                            }
                            continue;
                        }
                    }
                    toDex.add(entry);
                }
                ArrayList<Future<D8Output>> futures = new ArrayList<Future<D8Output>>(toDex.size());
                for (i = 0; i < toDex.size(); ++i) {
                    ZipEntry classEntry = (ZipEntry)toDex.get(i);
                    futures.add(executor.submit(() -> this.dexEntry(zipFile, classEntry, executor)));
                }
                for (i = 0; i < futures.size(); ++i) {
                    D8Output result = (D8Output)((Future)futures.get(i)).get();
                    ZipEntry entry = (ZipEntry)toDex.get(i);
                    assert (result.getDexResources().size() == 1);
                    try (InputStream dexStream = ((Resource)result.getDexResources().get(0)).getStream();){
                        CompatDexBuilder.addEntry(entry.getName() + ".dex", dexStream, entry.getTime(), out);
                        continue;
                    }
                }
            }
        }
        finally {
            executor.shutdown();
        }
    }

    private D8Output dexEntry(ZipFile zipFile, ZipEntry classEntry, ExecutorService executor) throws IOException, CompilationException {
        try (InputStream stream = zipFile.getInputStream(classEntry);){
            CompatDexBuilderCommandBuilder builder = new CompatDexBuilderCommandBuilder();
            ((D8Command.Builder)((D8Command.Builder)builder.addClassProgramData(new byte[][]{ByteStreams.toByteArray(stream)})).setMode(this.noLocals ? CompilationMode.RELEASE : CompilationMode.DEBUG)).setMinApiLevel(AndroidApiLevel.H_MR2.getLevel());
            D8Output d8Output = D8.run(builder.build(), executor);
            return d8Output;
        }
    }

    private static void addEntry(String name, InputStream in, long time, ZipOutputStream out) throws IOException {
        ZipEntry zipEntry = new ZipEntry(name);
        byte[] bytes = ByteStreams.toByteArray(in);
        CRC32 crc32 = new CRC32();
        crc32.update(bytes);
        zipEntry.setSize(bytes.length);
        zipEntry.setMethod(0);
        zipEntry.setCrc(crc32.getValue());
        zipEntry.setTime(time);
        out.putNextEntry(zipEntry);
        out.write(bytes);
        out.closeEntry();
    }
}

