/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemBasedString;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.utils.DescriptorUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class IdentifierNameStringMarker {
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final DexItemFactory dexItemFactory;
    private final Set<DexItem> identifierNameStrings;

    public IdentifierNameStringMarker(Enqueuer.AppInfoWithLiveness appInfo) {
        this.appInfo = appInfo;
        this.dexItemFactory = appInfo.dexItemFactory;
        this.identifierNameStrings = appInfo.identifierNameStrings;
    }

    public void decoupleIdentifierNameStringsInFields() {
        for (DexProgramClass clazz : this.appInfo.classes()) {
            clazz.forEachField(this::decoupleIdentifierNameStringInField);
        }
    }

    private void decoupleIdentifierNameStringInField(DexEncodedField encodedField) {
        if (!this.identifierNameStrings.contains(encodedField.field)) {
            return;
        }
        if (!(encodedField.staticValue instanceof DexValue.DexValueString)) {
            return;
        }
        DexString original = ((DexValue.DexValueString)encodedField.staticValue).getValue();
        String maybeDescriptor = DescriptorUtils.javaTypeToDescriptorIfValidJavaType(original.toString());
        if (maybeDescriptor == null) {
            return;
        }
        DexType type = this.dexItemFactory.createType(maybeDescriptor);
        DexItemBasedString typeString = this.dexItemFactory.createItemBasedString(type);
        encodedField.staticValue = new DexValue.DexValueString(typeString);
    }

    public void decoupleIdentifierNameStringsInMethod(DexEncodedMethod encodedMethod, IRCode code) {
        for (BasicBlock block : code.blocks) {
            InstructionListIterator iterator = block.listIterator();
            while (iterator.hasNext()) {
                List<Value> newIns;
                InvokeMethod invoke;
                DexMethod invokedMethod;
                Value in2;
                Value newIn;
                DexField field;
                Instruction instruction = (Instruction)iterator.next();
                if (instruction.isStaticPut()) {
                    StaticPut staticPut = instruction.asStaticPut();
                    field = staticPut.getField();
                    if (!this.identifierNameStrings.contains(field) || (newIn = this.decoupleTypeIdentifierIfNecessary(code, iterator, staticPut, in2 = staticPut.inValue())) == in2) continue;
                    iterator.replaceCurrentInstruction(new StaticPut(staticPut.getType(), newIn, field));
                    encodedMethod.markUseIdentifierNameString();
                    continue;
                }
                if (instruction.isInstancePut()) {
                    InstancePut instancePut = instruction.asInstancePut();
                    field = instancePut.getField();
                    if (!this.identifierNameStrings.contains(field) || (newIn = this.decoupleTypeIdentifierIfNecessary(code, iterator, instancePut, in2 = instancePut.value())) == in2) continue;
                    ArrayList<Value> values = new ArrayList<Value>(2);
                    values.add(newIn);
                    values.add(instancePut.object());
                    iterator.replaceCurrentInstruction(new InstancePut(instancePut.getType(), values, field));
                    encodedMethod.markUseIdentifierNameString();
                    continue;
                }
                if (!instruction.isInvokeMethod() || !this.identifierNameStrings.contains(invokedMethod = (invoke = instruction.asInvokeMethod()).getInvokedMethod())) continue;
                List<Value> ins = invoke.arguments();
                if (this.isReflectiveCase(invokedMethod.proto)) {
                    Value in3 = ins.get(1);
                    Value newIn2 = this.decoupleReflectiveMemberIdentifier(code, iterator, invoke, in3);
                    newIns = ins.stream().map(i -> i == in3 ? newIn2 : i).collect(Collectors.toList());
                } else {
                    newIns = ins.stream().map(in -> this.decoupleTypeIdentifierIfNecessary(code, iterator, invoke, (Value)in)).collect(Collectors.toList());
                }
                if (ins.equals(newIns)) continue;
                iterator.replaceCurrentInstruction(Invoke.create(invoke.getType(), invokedMethod, invokedMethod.proto, invoke.outValue(), newIns));
                encodedMethod.markUseIdentifierNameString();
            }
        }
    }

    private Value decoupleTypeIdentifierIfNecessary(IRCode code, InstructionListIterator iterator, Instruction base, Value in) {
        if (!in.isConstString()) {
            return in;
        }
        ConstString constString = in.getConstInstruction().asConstString();
        String maybeDescriptor = DescriptorUtils.javaTypeToDescriptorIfValidJavaType(constString.getValue().toString());
        if (maybeDescriptor == null) {
            return in;
        }
        DexType type = this.dexItemFactory.createType(maybeDescriptor);
        DexItemBasedString typeString = this.dexItemFactory.createItemBasedString(type);
        iterator.previous();
        Value newIn = code.createValue(in.outType(), in.getLocalInfo());
        ConstString decoupled = new ConstString(newIn, typeString);
        decoupled.setPosition(base.getPosition());
        iterator.add(decoupled);
        iterator.next();
        return newIn;
    }

    private Value decoupleReflectiveMemberIdentifier(IRCode code, InstructionListIterator iterator, InvokeMethod invoke, Value in) {
        return in;
    }

    private boolean isReflectiveCase(DexProto proto) {
        int numOfParams = proto.parameters.size();
        if (numOfParams != 2 && numOfParams != 3) {
            return false;
        }
        if (numOfParams == 2 ? proto.returnType.descriptor != this.dexItemFactory.fieldDescriptor : proto.returnType.descriptor != this.dexItemFactory.methodDescriptor) {
            return false;
        }
        if (proto.parameters.values[0].descriptor != this.dexItemFactory.classDescriptor) {
            return false;
        }
        if (proto.parameters.values[1].descriptor != this.dexItemFactory.stringDescriptor) {
            return false;
        }
        return numOfParams != 3 || !proto.parameters.values[2].toDescriptorString().equals("[Ljava/lang/Class;");
    }
}

