/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.naming.ClassNaming;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.naming.ProguardMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.function.Consumer;

public class ProguardMapReader
implements AutoCloseable {
    private final BufferedReader reader;
    private int lineNo = 0;
    private int lineOffset = 0;
    private String line;
    final HashMap<String, String> cache = new HashMap();

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    ProguardMapReader(BufferedReader reader) {
        this.reader = reader;
    }

    private char peek() {
        return this.peek(0);
    }

    private char peek(int distance) {
        return this.lineOffset + distance < this.line.length() ? this.line.charAt(this.lineOffset + distance) : (char)'\n';
    }

    private char next() {
        try {
            return this.line.charAt(this.lineOffset++);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ParseException("Unexpected end of line");
        }
    }

    private boolean nextLine() throws IOException {
        if (this.line.length() != this.lineOffset) {
            throw new ParseException("Expected end of line");
        }
        return this.skipLine();
    }

    private boolean skipLine() throws IOException {
        ++this.lineNo;
        this.lineOffset = 0;
        this.line = this.reader.readLine();
        return this.hasLine();
    }

    private boolean hasLine() {
        return this.line != null;
    }

    private void skipWhitespace() {
        while (Character.isWhitespace(this.peek())) {
            this.next();
        }
    }

    private char expect(char c) {
        if (this.next() != c) {
            throw new ParseException("Expected '" + c + "'");
        }
        return c;
    }

    void parse(ProguardMap.Builder mapBuilder) throws IOException {
        this.line = this.reader.readLine();
        this.parseClassMappings(mapBuilder);
    }

    private void parseClassMappings(ProguardMap.Builder mapBuilder) throws IOException {
        while (this.hasLine()) {
            String before = this.parseType(false);
            this.skipWhitespace();
            if (!this.acceptArrow()) {
                if (!before.endsWith("package") || !this.acceptString("-info")) {
                    throw new ParseException("Expected arrow after class name " + before);
                }
                this.skipLine();
                continue;
            }
            this.skipWhitespace();
            String after = this.parseType(false);
            this.expect(':');
            ClassNaming.Builder currentClassBuilder = mapBuilder.classNamingBuilder(after, before);
            if (!this.nextLine()) continue;
            this.parseMemberMappings(currentClassBuilder);
        }
    }

    private void parseMemberMappings(ClassNaming.Builder classNamingBuilder) throws IOException {
        MemberNaming current = null;
        MemberNaming.Range previousInlineRange = null;
        MemberNaming.Signature previousSignature = null;
        String previousRenamedName = null;
        ArrayList<Consumer<MemberNaming>> collectedInfos = new ArrayList<Consumer<MemberNaming>>(10);
        while (Character.isWhitespace(this.peek())) {
            MemberNaming.Range originalLineRange;
            this.skipWhitespace();
            MemberNaming.Range inlinedLineRange = this.maybeParseRange();
            if (inlinedLineRange != null) {
                this.expect(':');
            }
            MemberNaming.Signature signature = this.parseSignature();
            if (this.peek() == ':') {
                this.next();
                originalLineRange = this.maybeParseRange();
                if (originalLineRange == null) {
                    if (this.skipLine()) continue;
                    break;
                }
            } else {
                originalLineRange = null;
            }
            this.skipWhitespace();
            this.skipArrow();
            this.skipWhitespace();
            String renamedName = this.parseMethodName();
            if (inlinedLineRange == null || previousInlineRange == null || originalLineRange == null || !previousInlineRange.equals(inlinedLineRange) || !originalLineRange.isSingle()) {
                if (current == null || !previousSignature.equals(current.signature)) {
                    if (collectedInfos.size() == 1) {
                        current = new MemberNaming(previousSignature, previousRenamedName, previousInlineRange);
                        classNamingBuilder.addMemberEntry(current);
                    }
                } else {
                    MemberNaming finalCurrent = current;
                    collectedInfos.forEach(info -> info.accept(finalCurrent));
                }
                collectedInfos.clear();
            }
            collectedInfos.add(m -> m.addInliningRange(inlinedLineRange, signature, originalLineRange));
            previousInlineRange = inlinedLineRange;
            previousSignature = signature;
            previousRenamedName = renamedName;
            if (this.nextLine()) continue;
            break;
        }
        if (current == null || !previousSignature.equals(current.signature)) {
            if (collectedInfos.size() == 1) {
                current = new MemberNaming(previousSignature, previousRenamedName, previousInlineRange);
                classNamingBuilder.addMemberEntry(current);
            }
        } else {
            MemberNaming finalCurrent = current;
            collectedInfos.forEach(info -> info.accept(finalCurrent));
        }
        collectedInfos.clear();
    }

    private void skipIdentifier(boolean allowInit) {
        boolean isInit = false;
        if (allowInit && this.peek() == '<') {
            this.next();
            isInit = true;
        }
        if (!Character.isJavaIdentifierStart(this.peek())) {
            throw new ParseException("Identifier expected");
        }
        this.next();
        while (Character.isJavaIdentifierPart(this.peek())) {
            this.next();
        }
        if (isInit) {
            this.expect('>');
        }
        if (Character.isJavaIdentifierPart(this.peek())) {
            throw new ParseException("End of identifier expected");
        }
    }

    private String substring(int start) {
        String result = this.line.substring(start, this.lineOffset);
        if (this.cache.containsKey(result)) {
            return this.cache.get(result);
        }
        this.cache.put(result, result);
        return result;
    }

    private String parseMethodName() {
        int startPosition = this.lineOffset;
        this.skipIdentifier(true);
        while (this.peek() == '.') {
            this.next();
            this.skipIdentifier(true);
        }
        return this.substring(startPosition);
    }

    private String parseType(boolean allowArray) {
        int startPosition = this.lineOffset;
        this.skipIdentifier(false);
        while (this.peek() == '.') {
            this.next();
            this.skipIdentifier(false);
        }
        if (allowArray) {
            while (this.peek() == '[') {
                this.next();
                this.expect(']');
            }
        }
        return this.substring(startPosition);
    }

    private MemberNaming.Signature parseSignature() {
        MemberNaming.Signature signature;
        String type = this.parseType(true);
        this.expect(' ');
        String name = this.parseMethodName();
        if (this.peek() == '(') {
            String[] arguments;
            this.next();
            if (this.peek() == ')') {
                arguments = new String[]{};
            } else {
                LinkedList<String> items = new LinkedList<String>();
                items.add(this.parseType(true));
                while (this.peek() != ')') {
                    this.expect(',');
                    items.add(this.parseType(true));
                }
                arguments = items.toArray(new String[items.size()]);
            }
            this.expect(')');
            signature = new MemberNaming.MethodSignature(name, type, arguments);
        } else {
            signature = new MemberNaming.FieldSignature(name, type);
        }
        return signature;
    }

    private void skipArrow() {
        this.expect('-');
        this.expect('>');
    }

    private boolean acceptArrow() {
        if (this.peek() == '-' && this.peek(1) == '>') {
            this.next();
            this.next();
            return true;
        }
        return false;
    }

    private boolean acceptString(String s) {
        int i;
        for (i = 0; i < s.length(); ++i) {
            if (this.peek(i) == s.charAt(i)) continue;
            return false;
        }
        for (i = 0; i < s.length(); ++i) {
            this.next();
        }
        return true;
    }

    private MemberNaming.Range maybeParseRange() {
        if (!Character.isDigit(this.peek())) {
            return null;
        }
        int from = this.parseNumber();
        if (this.peek() != ':') {
            return new MemberNaming.SingleLineRange(from);
        }
        this.expect(':');
        int to = this.parseNumber();
        return new MemberNaming.Range(from, to);
    }

    private int parseNumber() {
        int result = 0;
        if (!Character.isDigit(this.peek())) {
            throw new ParseException("Number expected");
        }
        do {
            result *= 10;
            result += Character.getNumericValue(this.next());
        } while (Character.isDigit(this.peek()));
        return result;
    }

    private class ParseException
    extends RuntimeException {
        private final int lineNo;
        private final int lineOffset;
        private final String msg;

        ParseException(String msg) {
            this.lineNo = ProguardMapReader.this.lineNo;
            this.lineOffset = ProguardMapReader.this.lineOffset;
            this.msg = msg;
        }

        @Override
        public String toString() {
            return "Parse error [" + this.lineNo + ":" + this.lineOffset + "] " + this.msg;
        }
    }
}

