/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.aapt2;

import com.android.SdkConstants;
import com.android.tools.aapt2.Aapt2Exception;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashCode;
import com.google.common.io.Resources;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;

enum Aapt2JniPlatform {
    WIN_64("win64", HashCode.fromString((String)"57bf459da6a740956630dec3f39d95ba0fbb6d2540f6b34729fa048a253c85be"), "libwinpthread-1.dll", "libaapt2_jni.dll"),
    WIN_32("win32", HashCode.fromString((String)"868550f705679e2d6a3f6a80f5d0872ee2c7d37f59c2c9bfb5d68a0460109cba"), "libwinpthread-1.dll", "libaapt2_jni.dll"),
    MAC_64("mac64", HashCode.fromString((String)"aecb30785e93480af0bc81013386850b0fb5d3d8921eec9bd2a026c07578dac4"), "libc++.dylib", "libaapt2_jni.dylib"),
    LINUX_64("linux64", HashCode.fromString((String)"b21d816cee1d00e30034af0a8c9b2c2711233c6cc5f4ff9c586df439215a24a6"), "libc++.so", "libaapt2_jni.so");

    private final String directoryName;
    private final HashCode cacheKey;
    private final ImmutableList<String> fileNames;

    private Aapt2JniPlatform(String directoryName, HashCode cacheKey, String ... fileNames) {
        this.directoryName = directoryName;
        this.cacheKey = cacheKey;
        this.fileNames = ImmutableList.copyOf((Object[])fileNames);
    }

    static Aapt2JniPlatform getCurrentPlatform() {
        boolean is64Bit = System.getProperty("os.arch").contains("64");
        switch (SdkConstants.CURRENT_PLATFORM) {
            case 2: {
                return is64Bit ? WIN_64 : WIN_32;
            }
            case 3: {
                if (!is64Bit) {
                    throw new Aapt2Exception("32-bit JVM is not supported");
                }
                return MAC_64;
            }
            case 1: {
                if (!is64Bit) {
                    throw new Aapt2Exception("32-bit JVM is not supported");
                }
                return LINUX_64;
            }
        }
        throw new IllegalStateException("Unknown platform");
    }

    HashCode getCacheKey() {
        return this.cacheKey;
    }

    void writeToDirectory(Path directory) throws IOException {
        for (String fileName : this.fileNames) {
            URL url = this.getResource(fileName);
            BufferedInputStream inputStream = new BufferedInputStream(url.openStream());
            Throwable throwable = null;
            try {
                Files.copy(inputStream, directory.resolve(fileName), new CopyOption[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((InputStream)inputStream).close();
            }
        }
    }

    List<Path> getFiles(Path cacheDirectory) {
        return this.fileNames.stream().map(cacheDirectory::resolve).collect(Collectors.toList());
    }

    private URL getResource(String fileName) {
        return Resources.getResource((String)(this.directoryName + "/" + fileName));
    }
}

